{ PERFORM.INC: Procedures to implement the performance window }
{ Variables shared between functions in this file: }
var   Plottime: real;                      { time to complete last plot }
      Plot_nsurf: word;                    { # surfaces plotted last }
      Plotstart: real;                     { time when plot started }

procedure PERF_START;
var hr, min, sec, sec100: word;

begin
  gettime (hr, min, sec, sec100);
  Plotstart := 3600.0*hr + 60.0*min + sec + 0.01*sec100;
end; { PERF_START }

procedure PERF_STOP (Plottype: integer);
var hr, min, sec, sec100: word;
    Plotstop: real;

begin
  Lastplot := Plottype;
  if (Lastplot > 0) then begin
    Plot_nsurf := Nsurf;
    gettime (hr, min, sec, sec100);
    Plotstop := 3600.0*hr + 60.0*min + sec + 0.01*sec100;
    if (Plotstop < Plotstart) then
      { Assume we just crossed a day boundary.
        Hey, we might have crossed two days, but let's hope SURFMODL
        never gets THAT slow!
      }
      Plottime := Plotstop + 24.0 - Plotstart
    else
      Plottime := Plotstop - Plotstart;
  end;
end; { PERF_STOP }

procedure PERF_SHOW;
var Surf_per_sec: real;

begin
  { Clear the screen }
  window (1,1,80,25);       { use full screen }
  clrscr;
  if (Lastplot > 0) then begin
    { Print performance statistics at bottom of screen. }
    window (13,24,80,25);
    gotoXY(1,1);
    write ('PERFORMANCE: ', Plot_nsurf);
    if (Lastplot = 5) then
      write (' Gouraud-Shaded');
    writeln (' Surfaces in ', Plottime:4:1, ' Seconds');
    Surf_per_sec := Plot_nsurf / Plottime;
    write ('             (', Surf_per_sec:4:1, ' Surfaces/Second)');
  end;
end; { PERF_SHOW }
