procedure OPENFILE (var Flnm: text80; var Infile: text);
{ Open a file with error checking. Prompt for new one if file not found }

begin   Fileread := FALSE;
  while (NOT Fileread) do begin
    assign (Infile, Flnm);
    {$I-}
    reset (Infile);
    {$I+}
    if (ioresult <> 0) then begin
      writeln ('Error: file ',Flnm,' does not exist.');
      write ('Enter new file name (or <enter> to exit): ');
      readln (Flnm);
      if (Flnm = '') then
        halt;
    end else
      Fileread := TRUE;
  end;
end;   { procedure OPENFILE }



procedure READFILE (Flnm: text80);
{ read the input data from the file }

var
  Version: integer;       { used for multiple version input flag (only 4 now) }
  j: integer;             { counter for looping and reading into arrays}
  Infile: text;           { file to read}
  Realvar: vartype;       { temporary array for storage of line input }
  Num: integer;           { number of inputted values on the line }
  Comment: text80;        { comment at end of line }
  Line_num: integer;      { line number in input file }
  Nvread: integer;        { #vertices read so far in this surface }
  Vert: integer;          { vertex # }
  Nscript: integer;       { #script inputs }
  Mat: integer;           { material # }
  Node: word;             { node # }
  Surf: word;             { surface # }
  Connection: word;       { next connection number on surface }
  Command: cmmdtype;      { symbolic command type }
  Parm: parmtype;         { symbolic parameter }
  ch: char;

begin
  clrscr;
  writeln ('Reading data file . . .');

  openfile (Flnm, Infile);
  readln (Infile, Flpurpose);
  Line_num := 1;
  Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num, FALSE);
  if (Num <> 1) then begin
    writeln ('Bad input: Reading version number.');
    close (Infile);
    halt;
  end;
  Version := round(Realvar[1]);
  if (Version = 1) then begin
    Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num, FALSE);
    if (Num <> 4) then begin
      writeln ('Bad input: Reading #nodes, #surfaces, Maxvert and #materials',
          ' (line ',Line_num,')');
      close (Infile);
      halt;
    end;
    Nnodes := round(Realvar[1]);
    Nsurf := round(Realvar[2]);
    Maxvert := round(Realvar[3]);
    Nmatl := round(Realvar[4]);
    Nscript := 0;
    Nsides := 1;
  end else if (Version = 2) then begin
    Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num, FALSE);
    if (Num <> 6) then begin
      writeln ('Bad input: Reading #matl, #nodes, #surf, #script, Maxvert,',
          ' #sides (line ',Line_num,')');
      close (Infile);
      halt;
    end;
    Nmatl := round(Realvar[1]);
    Nnodes := round(Realvar[2]);
    Nsurf := round(Realvar[3]);
    Nscript := round(Realvar[4]);
    Maxvert := round(Realvar[5]);
    Nsides := round(Realvar[6]);
  end else if (Version = 3) or (Version = 4) or (Version = 5) then begin
    Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num, FALSE);
    if (Num <> 5) then begin
      writeln ('Bad input: Reading #matl, #nodes, #surf, Maxvert,',
          ' #sides (line ',Line_num,')');
      close (Infile);
      halt;
    end;
    Nmatl := round(Realvar[1]);
    Nnodes := round(Realvar[2]);
    Nsurf := round(Realvar[3]);
    Maxvert := round(Realvar[4]);
    Nsides := round(Realvar[5]);
  end else begin
    writeln('Wrong data input version number specified');
    close (Infile);
    halt;
  end;

{$ifdef BIGMEM}
  { Check for valid range }
  if (Nnodes > MAXALLOC) or (Nnodes < 3) or (Nsurf * Maxvert > MAXALLOC) or
      (Nsurf * Maxvert < 1) or (Maxvert < 3) then begin
    writeln('Invalid Nnodes=', Nnodes, ' or Nsurf=', Nsurf,
        ' or Maxvert=', Maxvert);
    halt;
  end;

  { Dynamically allocate enough space for all nodes & surfaces }
  if (not alloc_nodes) then begin
    writeln('Can not allocate sufficient memory for ', Nnodes, ' nodes.');
    halt;
  end;
  if (not alloc_surfs) then begin
    writeln('Can not allocate sufficient memory for ', Nsurf, ' surfaces.');
    halt;
  end;

  with ptra^ do with ptrb^ do with ptrc^ do with ptrg^ do
    with ptrh^ do with ptri^ do
      begin {with}
{$endif}

  if (Nnodes<=MAXNODES) and (Nsurf<=MAXSURF) and (Nmatl<=MAXMATL) and
       (Maxvert*Nsurf<=MAXCONNECT) and (Nsides<=2) and (Nnodes>0) and
       (Nsurf>0) and (Nmatl>0) then begin
    for Mat := 1 to Nmatl do begin
        Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num,
            FALSE);
        if (Version <= 2) then begin
          if (Num <> 3) then begin
            writeln ('Bad input: Reading data for material #',Mat,' (line ',
                Line_num,')');
            close (Infile);
            halt;
          end;
          R1[Mat] := Realvar[1];
          R2[Mat] := Realvar[2];
          R3[Mat] := 0.0;
          Color[Mat] := round(Realvar[3]);
          Ambient[Mat] := 0.1;
          color_to_RGB (Color[Mat], Redmax[Mat], Grnmax[Mat], Blumax[Mat]);
        end else if (Version = 3) then begin
          if (Num <> 4) then begin
            writeln ('Bad input: Reading data for material #',Mat,' (line ',
                Line_num,')');
            close (Infile);
            halt;
          end;
          R1[Mat] := Realvar[1];
          R2[Mat] := Realvar[2];
          R3[Mat] := Realvar[3];
          Color[Mat] := round(Realvar[4]);
          Ambient[Mat] := 0.1;
          color_to_RGB (Color[Mat], Redmax[Mat], Grnmax[Mat], Blumax[Mat]);
        end else begin
          { Version 4 or 5 }
          if (Num <> 5) then begin
            writeln ('Bad input: Reading data for material #',Mat,' (line ',
                Line_num,')');
            close (Infile);
            halt;
          end;
          R1[Mat] := Realvar[1];
          R2[Mat] := Realvar[2];
          R3[Mat] := Realvar[3];
          Color[Mat] := round(Realvar[4]);
          Ambient[Mat] := Realvar[5];
          if (Version > 4) then begin
            Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num,
                FALSE);
            if (Num <> 6) then begin
              writeln ('Bad input: Reading data for material #',Mat,' (line ',
                  Line_num,')');
              close (Infile);
              halt;
            end;
            Redmax[Mat] := round(Realvar[1]);
            Grnmax[Mat] := round(Realvar[2]);
            Blumax[Mat] := round(Realvar[3]);
            if Redmax[Mat] < 1 then
              Redmax[Mat] := 1;
            if Redmax[Mat] > 256 then
              Redmax[Mat] := 256;
            if Grnmax[Mat] < 1 then
              Grnmax[Mat] := 1;
            if Grnmax[Mat] > 256 then
              Grnmax[Mat] := 256;
            if Blumax[Mat] < 1 then
              Blumax[Mat] := 1;
            if Blumax[Mat] > 256 then
              Blumax[Mat] := 256;
          end else { if Version > 4 }
            color_to_RGB (Color[Mat], Redmax[Mat], Grnmax[Mat], Blumax[Mat]);
        end; { if Version }
      end;  {for Mat}

      for Node := 1 to Nnodes do
      begin
           Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num,
              FALSE);
           if (Num <> 3) then
           begin
                writeln ('Bad input: Reading data for node #',Node,' (line ',
                Line_num,')');
                close (Infile);
                halt;
           end;
           Xworld[Node] := Realvar[1];
           Yworld[Node] := Realvar[2];
           Zworld[Node] := Realvar[3];
      end; {for Node}
      for Surf := 1 to Nsurf do
      begin
        Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num,
            FALSE);
        if (Num < 5) then begin
           writeln ('Bad input: Reading data for surface #',Surf,' (line ',
           Line_num,')');
           if (Num > 2) then
              writeln ('Must have at least 3 nodes on a surface!');
           close (Infile);
           halt;
        end;
        Nvert[Surf] := round(Realvar[1]);
        Matl[Surf] := round(Realvar[2]);
        if (Nvert[Surf]<3) or (Nvert[Surf]>Maxvert) or (Nvert[Surf]<Num-2)
           or (Matl[Surf]<1) or (Matl[Surf]>Nmatl) then begin
           writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
           if (Nvert[Surf] < 3) then
              writeln ('Must have at least 3 nodes per surface')
           else if (Nvert[Surf] > Maxvert) then
             writeln ('#vertices exceeds Maxvert')
           else if (Matl[Surf]<1) or (Matl[Surf]>Nmatl) then
             writeln ('Matl no. not in range 0..Nmatl (',Nmatl,')')
           else
             writeln ('#vertices specified does not match #arguments');
           close (Infile);
           halt;
        end; { if Nvert... }
        Nvread := Num - 2;
        for Vert := 1 to Nvread do begin
          Connection := round(Realvar[Vert+2]);
          if (Connection<1) or (Connection>Nnodes) then begin
            writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
            writeln ('Connection #,',Vert,' not in range 0..Nnodes (',
              Nnodes,')');
            close (Infile);
             halt;
          end;
          Connect[(Surf-1)*Maxvert+Vert] := Connection;
        end; { for Vert }
        while (Nvread < Nvert[Surf]) do begin
          Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num,
              FALSE);
          if (Num < 1) or (Nvread + Num > Nvert[Surf]) then begin
            writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
            if (Num = 0) then writeln ('No data read.')
            else if (Nvread + Num > Nvert[Surf]) then
              writeln ('Too many vertices read.');
            close (Infile);
            halt;
          end; { if Num... }
          Vert := Nvread + 1;
          for j := 1 to Num do begin
            Connection := round(Realvar[j]);
            if (Connection<1) or (Connection>Nnodes) then begin
              writeln ('Error in surface ',Surf,'(line ', Line_num,'): ');
              writeln ('Connection #,',Vert,
                       ' not in range 0..Nnodes (',Nnodes,')');
              close (Infile);
              halt;
            end;
            Connect[(Surf-1)*Maxvert+Vert] := Connection;
            Vert := Vert + 1;
          end;
          Nvread := Nvread + Num;
        end; { while }
      end; { for Surf }
    end
    else begin
      if (Nnodes>MAXNODES) or (Nnodes<1) then
        writeln('Nnodes (',Nnodes,') must be between 1 and ',MAXNODES);
      if (Nsurf>MAXSURF) or (Nsurf<1) then
        writeln('Nsurf (',Nsurf,') must be between 1 and ',MAXSURF);
      if (Nmatl>MAXMATL) or (Nmatl<1) then
        writeln('Nmatl (',Nmatl,') must be between 1 and ',MAXMATL);
      if Maxvert*Nsurf>MAXCONNECT then begin
        writeln('Number of surfaces or max number of vertices too large!');
        writeln('Maxvert (',Maxvert,') * Nsurf (',Nsurf,
                ') must be smaller than ',MAXCONNECT);
      end;
      if (Nsides<1) or (Nsides>2) then
        writeln('Nsides (',Nsides,') must be either 1 or 2');
      close (Infile);
      halt;
    end; { if Nnodes... }

    close (Infile);

    readcfg (Flnm, FALSE);

{$ifdef BIGMEM}
  end; {with}
{$endif}
end; { procedure READFILE }
