unit SHAREDEC;

{ This file just contains declarations that are shared between units. }

INTERFACE

const MAXMATL = 50;     { maximum # of materials in entire solid }
      MAXLITE = 20;     { maximum # of light sources }
      MAXPICBUF = 8;    { max # 64K picture buffers available per screen }
                        { this should be adequate for Super VGA too }
      MAXVAR = 20;      { maximum # of numeric inputs on a line }
      MAXCMMD = 34;     { # of valid SURFMODL commands }
      MAXPARM = 6;      { # of valid SURFMODL symbolic parameters }
      MAXALLOC = 65520; { maximum # of bytes TP can allocate in a
                          single GETMEM call
                        }
      MAXCOLORS = 256;  { max # colors SURFMODL can handle at a time }

type  picbuf = array[1..MAXPICBUF] of pointer;
      nlpic = array[1..MAXPICBUF] of longint;
      xmsbuf = array[1..MAXPICBUF] of word;
      buffertype = array[1..MAXPICBUF] of integer;
      text80 = string[80];
      text255 = string[255];
      vartype = array[1..MAXVAR] of real;

type
  ColorValue     = record
                     Rvalue, Gvalue, Bvalue : byte;
                   end;
  SurfPalette    = array[0..MAXCOLORS] of ColorValue;
  RowArray       = array[0..79] of byte;

{ This is the list of valid commands recognized by chkcmmd: }
type  cmmdtype =
( CMD_INVALID, CMD_NONE, CMD_GRSYS, CMD_GRMODE, CMD_VERSION, CMD_EYE,
  CMD_FOCAL, CMD_MAGNIFY, CMD_VIEWTYPE, CMD_MATL, CMD_MATCONST,
  CMD_MATCOLOR, CMD_MATAMBIENT, CMD_MATRGB, CMD_LIGHT, CMD_LTCOORD,
  CMD_LTINTENS, CMD_GOURAUD, CMD_SHADOWING, CMD_AXISSHOW, CMD_AXISLEN,
  CMD_AXISCOLOR, CMD_DITHER, CMD_RANDOM, CMD_BORDERS, CMD_TITLE,
  CMD_MAXVERT, CMD_NSIDES, CMD_NODES, CMD_SURFACES, CMD_TEXTCOL,
  CMD_BGCOL, CMD_GRAPHTEXT, CMD_REVVIDEO, CMD_SHOWTITLE, CMD_XYADJUST
);

{ And this is the list of valid symbolic parameters recognized by chkcmmd: }
type  parmtype =
( PRM_NONE, PRM_ON, PRM_OFF, PRM_STD, PRM_XY, PRM_XZ, PRM_YZ
);

{ Following holds a list of valid commands in SURFMODL: }
type cmmdlist = record
    Cname: string[10];      { name of command }
    Ctype: cmmdtype;
    Sym_param: boolean;     { is parameter symbolic? }
end;

{ And this holds a list of valid parameters: }
type parmlist = record
    Pname: string[10];
    Ptype: parmtype;
end;

{ These are all the valid SURFMODL commands: }
const cmmd_name: array[1..MAXCMMD] of cmmdlist = (
  (Cname: 'GRSYS';      Ctype: CMD_GRSYS;       Sym_param: FALSE),
  (Cname: 'GRMODE';     Ctype: CMD_GRMODE;      Sym_param: FALSE),
  (Cname: 'VERSION';    Ctype: CMD_VERSION;     Sym_param: FALSE),
  (Cname: 'EYE';        Ctype: CMD_EYE;         Sym_param: FALSE),
  (Cname: 'FOCAL';      Ctype: CMD_FOCAL;       Sym_param: FALSE),
  (Cname: 'MAGNIFY';    Ctype: CMD_MAGNIFY;     Sym_param: FALSE),
  (Cname: 'VIEWTYPE';   Ctype: CMD_VIEWTYPE;    Sym_param: TRUE),
  (Cname: 'MATL';       Ctype: CMD_MATL;        Sym_param: FALSE),
  (Cname: 'MATCONST';   Ctype: CMD_MATCONST;    Sym_param: FALSE),
  (Cname: 'MATCOLOR';   Ctype: CMD_MATCOLOR;    Sym_param: FALSE),
  (Cname: 'MATAMBIENT'; Ctype: CMD_MATAMBIENT;  Sym_param: FALSE),
  (Cname: 'MATRGB';     Ctype: CMD_MATRGB;      Sym_param: FALSE),
  (Cname: 'LIGHT';      Ctype: CMD_LIGHT;       Sym_param: FALSE),
  (Cname: 'LTCOORD';    Ctype: CMD_LTCOORD;     Sym_param: FALSE),
  (Cname: 'LTINTENS';   Ctype: CMD_LTINTENS;    Sym_param: FALSE),
  (Cname: 'GOURAUD';    Ctype: CMD_GOURAUD;     Sym_param: FALSE),
  (Cname: 'SHADOWING';  Ctype: CMD_SHADOWING;   Sym_param: TRUE),
  (Cname: 'AXISSHOW';   Ctype: CMD_AXISSHOW;    Sym_param: TRUE),
  (Cname: 'AXISLEN';    Ctype: CMD_AXISLEN;     Sym_param: FALSE),
  (Cname: 'AXISCOLOR';  Ctype: CMD_AXISCOLOR;   Sym_param: FALSE),
  (Cname: 'DITHER';     Ctype: CMD_DITHER;      Sym_param: FALSE),
  (Cname: 'RANDOM';     Ctype: CMD_RANDOM;      Sym_param: FALSE),
  (Cname: 'BORDERS';    Ctype: CMD_BORDERS;     Sym_param: TRUE),
  (Cname: 'TITLE';      Ctype: CMD_TITLE;       Sym_param: FALSE),
  (Cname: 'MAXVERT';    Ctype: CMD_MAXVERT;     Sym_param: FALSE),
  (Cname: 'NSIDES';     Ctype: CMD_NSIDES;      Sym_param: FALSE),
  (Cname: 'NODES';      Ctype: CMD_NODES;       Sym_param: FALSE),
  (Cname: 'SURFACES';   Ctype: CMD_SURFACES;    Sym_param: FALSE),
  (Cname: 'TEXTCOL';    Ctype: CMD_TEXTCOL;     Sym_param: FALSE),
  (Cname: 'BGCOL';      Ctype: CMD_BGCOL;       Sym_param: FALSE),
  (Cname: 'GRAPHTEXT';  Ctype: CMD_GRAPHTEXT;   Sym_param: FALSE),
  (Cname: 'REVVIDEO';   Ctype: CMD_REVVIDEO;    Sym_param: TRUE),
  (Cname: 'SHOWTITLE';  Ctype: CMD_SHOWTITLE;   Sym_param: TRUE),
  (Cname: 'XYADJUST';   Ctype: CMD_XYADJUST;    Sym_param: FALSE)
);

{ And these are the valid symbolic parameters: }
const parm_name: array[1..MAXPARM] of parmlist = (
  (Pname: 'ON';         Ptype: PRM_ON),
  (Pname: 'OFF';        Ptype: PRM_OFF),
  (Pname: 'STD';        Ptype: PRM_STD),
  (Pname: 'XY';         Ptype: PRM_XY),
  (Pname: 'XZ';         Ptype: PRM_XZ),
  (Pname: 'YZ';         Ptype: PRM_YZ)
);

var
  Redmax, Grnmax, Blumax: array[1..MAXMATL] of integer;
     { RGB values of matl at full intensity }

IMPLEMENTATION

END.
