procedure SHELLPTS (var Xpt, Ypt: points; Npts: integer);

{ Shell sort the line point data, using Ypt as the primary sorting
  criterion and Xpt as the secondary (tie-breaking) sorting
  criterion. Procedure as published in Tanenbaum, "Structured
  Computer Organization", Prentice-Hall, Englewood Cliffs, NJ, 1976.
}
var Dist: integer;              { sorting distance }
    K, I: integer;              { genl sorting indexes }

begin

{ Determine the initial value of Dist by finding the largest power
  of 2 less than Npts, and subtracting 1 from it. The final step in
  this calculation is performed inside the main sorting loop.
}
  Dist := 4;
  while (Dist < Npts) do
    Dist := Dist + Dist;
  Dist := Dist - 1;

{ Main sorting loop. The outer loop is executed once per pass. }
  while (Dist > 1) do begin
    Dist := Dist div 2;
    for K := 1 to (Npts - Dist) do begin
      I := K;
      while (I > 0) do begin
        { This stmt. is the comparison. It also controls moving values
          upward after an exchange. }
        if (Ypt[I] > Ypt[I+Dist]) or
          ((Ypt[I] = Ypt[I+Dist]) and (Xpt[I] > Xpt[I+Dist])) then begin
          { The next 2 stmts. perform the exchange }
          swapint (Xpt[I], Xpt[I+Dist]);
          swapint (Ypt[I], Ypt[I+Dist]);
        end else
          I := 0;      { stop the while loop! }
        I := I - Dist;
      end; { while }
    end; { for K }
  end; { while Dist }
end; { procedure SHELLPTS }

procedure SHELLSHADES (var Xpt, Ypt: points; var Shpt: realpts; Npts: integer);

{ Shell sort the line point & shade data, using Ypt as the primary sorting
  criterion and Xpt as the secondary (tie-breaking) sorting
  criterion. Procedure as published in Tanenbaum, "Structured
  Computer Organization", Prentice-Hall, Englewood Cliffs, NJ, 1976.
}
var Dist: integer;              { sorting distance }
    K, I: integer;              { genl sorting indexes }

begin

{ Determine the initial value of Dist by finding the largest power
  of 2 less than Npts, and subtracting 1 from it. The final step in
  this calculation is performed inside the main sorting loop.
}
  Dist := 4;
  while (Dist < Npts) do
    Dist := Dist + Dist;
  Dist := Dist - 1;

{ Main sorting loop. The outer loop is executed once per pass. }
  while (Dist > 1) do begin
    Dist := Dist div 2;
    for K := 1 to (Npts - Dist) do begin
      I := K;
      while (I > 0) do begin
        { This stmt. is the comparison. It also controls moving values
          upward after an exchange. }
        if (Ypt[I] > Ypt[I+Dist]) or
          ((Ypt[I] = Ypt[I+Dist]) and (Xpt[I] > Xpt[I+Dist])) then begin
          { The next 2 stmts. perform the exchange }
          swapint (Xpt[I], Xpt[I+Dist]);
          swapint (Ypt[I], Ypt[I+Dist]);
          swapreal (Shpt[I], Shpt[I+Dist]);
        end else
          I := 0;      { stop the while loop! }
        I := I - Dist;
      end; { while }
    end; { for K }
  end; { while Dist }
end; { procedure SHELLSHADES }
