procedure STORLINE (X1, Y1, X2, Y2: integer; var Xpt, Ypt: points;
    var Npts: integer);

{ Store the line from (X1,Y1) to (X2,Y2) in an internal buffer array }

var X, Y: integer;                   { current point being stored }
    Xfact: real;                     { factor for (X,Y) interpolation }
    Ylow, Yhigh: integer;            { range of for loop }
    First: boolean;                  { flag first dot of line }

begin
  First := TRUE;
  if (Y2 = Y1) then
    Xfact := 0.0
  else
    Xfact := (X2-X1) / (Y2-Y1);
  if (Y1 > Y2) then begin
    Ylow := Y2;
    Yhigh := Y1;
  end else begin
    Ylow := Y1;
    Yhigh := Y2;
  end;
  if (Ylow < Gymin) then
    Ylow := Gymin;
  if (Yhigh > Gymax) then
    Yhigh := Gymax;

{ Store the line segment, making sure there is not more than one X
  value for any given Y (unless Y1 = Y2, in which case only the two
  endpoints should be saved).
}
{ Make sure the entire line isn't out of bounds }
  if (Ylow <= Gymax) and (Yhigh >= Gymin) then begin
    for Y := Ylow to Yhigh do begin
      if (Xfact = 0.0) then
        if (First) then begin
          X := X1;
          First := FALSE;
        end else
          X := X2
      else
        X := X1 + round((Y-Y1) * Xfact);
      Npts := Npts + 1;
      if (Npts <= MAXPTS) then begin
        Xpt[Npts] := X;
        Ypt[Npts] := Y;
      end;
    end;  { for Y }
  end; { if Ylow... }

{ Flag error condition if array dimension exceeded }
  if (Npts > MAXPTS) then
    Npts := -1;
end;  { procedure STORLINE }
