program SURFINST;

{$I DEFINES.INC}
{$M 10000, 0, 20000}     { Leave memory for EXEC call }

uses crt,
     dos,
{$IFDEF EXTERNAL}
  SURFbgi,
{$ELSE}
  Graph,
{$ENDIF}
 SurfGRAF,
 SHAREDEC;

{ SURFMODL automated installation program }

type  ModuleType = record
        Modname: string[8];     { Module name }
        Relpath: string[10];    { Default path relative to main directory }
        Docopy:  boolean;       { User want to do the copy? }
        Diskspace: integer;     { Approx size in Kbytes }
        Descr:   string[80];    { Description of module contents }
        Dirname: string[80];    { Directory to install to }
      end;

const NMODULE = 8;

const modlist: array[1..NMODULE] of ModuleType = (
  (Modname: 'SURFMAIN'; Relpath: ''; Docopy: TRUE; Diskspace: 555;
    Descr: 'Main SURFMODL Program Files'),
  (Modname: 'SURFDATA'; Relpath: ''; Docopy: TRUE; Diskspace: 373;
    Descr: 'Example Data Files'),
  (Modname: 'SURFDOC'; Relpath: '\DOC'; Docopy: TRUE; Diskspace: 155;
    Descr: 'SURFMODL Documentation Files'),
  (Modname: 'SURFSRC'; Relpath: '\SRC'; Docopy: FALSE; Diskspace: 258;
    Descr: 'Source Code to SURFMODL'),
  (Modname: 'SURFUTIL'; Relpath: '\SRC'; Docopy: FALSE; Diskspace: 280;
    Descr: 'Source Code to SURFMODL Utilities'),
  (Modname: 'SURFEMUL'; Relpath: '\EMULATT'; Docopy: FALSE; Diskspace: 22;
    Descr: 'Code to Make a VaxMate Emulate an AT&T PC'),
  (Modname: 'SURFIFF'; Relpath: ''; Docopy: FALSE; Diskspace: 102;
    Descr: 'Executable for IFF version of SURFMODL'),
  (Modname: 'SURFPRNT'; Relpath: '\PRNT'; Docopy: FALSE; Diskspace: 53;
    Descr: 'Color Screen Dump Utility')
);

procedure COPY_MODULE (Fromdir, Modname, Dirname: string);
var Comspec: string[128]; { path to COMMAND.COM }
    Cmmd: string[128];    { path to PKUNZIP }
    Filename: string[128];
    F: file;
    ch: char;
    Ready: boolean;

begin
  { Check for existence of the ZIP file on the disk: }
  Ready := FALSE;
  Filename := Fromdir + Modname + '.ZIP';
  assign (F, Filename);
  repeat
    {$I-}
    reset (F);
    {$I+}
    if ioresult <> 0 then begin
      writeln (chr(7), '***** Insert the ', Modname,
          ' Installation Disk *****');
      writeln ('Options:');
      writeln ('  C - Continue');
      writeln ('  S - Skip This Module');
      writeln ('  A - Abort Installation');
      repeat
        write   ('Option: ');
        ch := readkey;
        ch := upcase (ch);
        writeln(ch);
        if (ch <> 'C') and (ch <> 'S') and (ch <> 'A') then
          writeln ('Please type C, S or A.');
      until (ch = 'C') or (ch = 'S') or (ch = 'A');
      if (ch = 'S') then
        exit
      else if (ch = 'A') then begin
        writeln ('Installation Aborted!');
        halt(1);
      end;
    end else begin
      Ready := TRUE;
      close (F);
    end;
  until Ready;

  writeln ('Installing Module ', Modname, ' From ', Fromdir, ' To ', Dirname);

  { Build a command to unpack the module.  Note that we don't even have
    to create the directory first, because PKUNZIP will do it with the
    -d option (isn't that nice!)
  }
  Comspec := getenv ('COMSPEC');
  Cmmd := '/C ' + Fromdir + 'PKUNZIP -o -d ' + Filename + ' ' + Dirname + '\';
  writeln (Comspec, ' ', Cmmd);
  exec (Comspec, Cmmd);
  writeln;
  writeln;

end; { COPY_MODULE }

procedure COPY_FILES;
var Line: string[128];
    Maindir: string[128];
    Fromdir: string[128];
    Modnum: integer;
    ch: char;
    Done: boolean;
    i: integer;
    F: file;
    Comspec: string[128]; { path to COMMAND.COM }

begin
  Maindir := 'C:\SURFMODL';
  repeat
    write ('What Drive is the Installation Disk in (A, B, etc.): ');
    ch := readkey;
    ch := upcase (ch);
    writeln(ch);
    if (ch < 'A') or (ch > 'Z') then
      writeln ('Please enter a drive letter (A-Z).');
  until (ch >= 'A') and (ch <= 'Z');

  Fromdir := ch + ':\';

  { Initialize the directory names }
  for Modnum := 1 to NMODULE do
    Modlist[Modnum].Dirname := Maindir + Modlist[Modnum].Relpath;

  { menu loop }
  Done := FALSE;
  repeat
    writeln;
    writeln ('              MODULE SELECTION MENU');
    writeln;
    writeln ('    MODULE    KBYTES  COPY?  DIRECTORY');
    for Modnum := 1 to NMODULE do begin
      with Modlist[Modnum] do begin
        write (Modnum, ' - ', Modname);
        { Pad blanks to 12 chars }
        for i := 1 to (12 - length(Modname)) do
          write (' ');
        write (Diskspace:4, '      ');
        if (Docopy) then
          write ('Y')
        else
          write ('N');
        writeln ('  ', Dirname);
      end;
    end;
    writeln;
    writeln ('Type a Module Number, or ''A'' to Abort,');
    write ('  or ''S'' to Start Installation: ');
    ch := readkey;
    ch := upcase(ch);
    writeln(ch);
    if (ch = 'A') then begin
      writeln ('Installation Aborted!');
      halt(1);
    end;
    if (ch = 'S') then
      Done := TRUE
    else begin
      Modnum := ord(ch) - 48;
      if (Modnum < 1) or (Modnum > NMODULE) then
        writeln ('You must type a number between 1 and ', NMODULE)
      else begin
        with Modlist[Modnum] do begin
          writeln ('Module ', Modname, ': ', Descr);
          writeln ('  Uses About ', Diskspace, ' Kbytes of Disk Space.');
          repeat
            write ('Do you want to install this module (Y/N)? ');
            ch := readkey;
            ch := upcase(ch);
            writeln(ch);
            if (ch <> 'Y') and (ch <> 'N') then
              writeln ('Please press Y or N');
          until (ch = 'Y') or (ch = 'N');
          if (ch = 'Y') then begin
            Docopy := TRUE;
            writeln ('Destination for install is currently ', Dirname);
            write ('Hit Enter to keep this destination, or type a new one: ');
            readln (Line);
            if (Line <> '') then
              Dirname := Line;
          end else
            Docopy := FALSE;
        end; { with }

        { If SURFMAIN is moved, everything goes with it. }
        if (Modnum = 1) then begin
          Maindir := Modlist[Modnum].Dirname;
          for Modnum := 2 to NMODULE do
            Modlist[Modnum].Dirname := Maindir + Modlist[Modnum].Relpath;
        end;
      end; { if Modnum }
    end; { if ch }

  until Done;

  { Copy the selected modules }
  for Modnum := 1 to NMODULE do begin
    with Modlist[Modnum] do begin
      if Docopy then
        copy_module (Fromdir, Modname, Dirname);
    end;
  end;

  { Finally, copy the SURFINST.EXE file: }
  Done := FALSE;
  while not Done do begin
    { Make sure the right floppy is in }
    assign (F, Fromdir + 'SURFINST.EXE'); 
    {$I-}
    reset (F);
    {$I+}
    if ioresult = 0 then begin
      close (F);
      Done := TRUE;
    end else begin
      writeln ('Insert the floppy with SURFINST on it.');
      write ('Press a key when ready...');
      ch := readkey;
    end;
  end;

  { Change to the main directory before proceeding }
  writeln ('CD ', Maindir);
  chdir (Maindir);

  { Now make a DOS command to copy the file }
  Comspec := getenv ('COMSPEC');
  Line := '/C ' + 'COPY ' + Fromdir + 'SURFINST.EXE';
  writeln (Comspec, ' ', Line);
  exec (Comspec, Line);
  writeln;
  
  writeln ('Files have been successfully copied.');

end; { COPY_FILES }

procedure CFG_STUFF;
var Cfgfile: text;
    Filename: string[80];
    Filebad: boolean;
    Errcode: integer;
    i: integer;
    ch: char;
    success: boolean;

begin

  writeln ('Next we will auto-detect your graphics adapter type.');
  write ('Hit ''A'' to Abort, or any other key to continue: ');
  ch := readkey;
  ch := upcase(ch);
  writeln(ch);
  if (ch = 'A') then begin
    writeln ('Installation aborted.');
    writeln ('You must manually create the SURFMODL.CFG file, or run');
    writeln ('SURFINST again.  If you want to use SURFINST to create');
    writeln ('SURFMODL.CFG but want to avoid the auto-detect, you may');
    writeln ('specify the system number on the command line.');
    halt(1);
  end;

  { Graphics initialization: Make sure the .BGI files are already copied
    over before this is done, and that we have chdir'd to that directory.
  }
  Grsys := -1;    { not initialized }
  Textcol := 1;

  if (paramcount > 1) then begin
    writeln ('usage: SURFINST [systype]');
    halt(1);
  end;
  if (paramcount = 1) then begin
    { System type specified on cmmd line, don't detect }
    val (paramstr(1), Grsys, Errcode);
    if (Errcode <> 0) then begin
      writeln ('usage: SURFINST [systype]');
      halt(1);
    end;
    if (Grsys < 1) or (Grsys > MAXSYS) then begin
      writeln ('Illegal GRSYS: ', Grsys);
      writeln ('Valid system numbers are: ');
      for i := 1 to MAXSYS do
        writeln (i:3, ' - ', Sys_name[i]);
      halt(1);
    end;
  end;

  { Select the graphics adapter type }
  select_sys;

  { Go into graphics mode, print a message to user }
  success := true;
  setgraphmode(grmode);
  if (graphresult < 0) then
    success := false
  else begin
    ngraphchar := GetMaxX div textwidth ('Z');
    GXmin := 0;
    GXMax := GetMaxX ;
    Gymin := 0;
    GYMax := GetMaxY;
    Ncolors := GetMaxColor;

    { Select good default colors for system: }
    if (Ncolors < 2) then begin
      { Best text colors for a monochrome system }
      Textcol := 1;
      BGcol := 0;
      Graphcol := 1;
      RevVideo := TRUE;
    end else if (Ncolors < 7) then begin
      { Best text colors for a 4-color system }
      Textcol := 2;
      BGcol := 0;
      Graphcol := 2;
      RevVideo := FALSE;
    end else begin
      { Best text colors for a full-color system.  Sometimes Textcol 7
        blinks in monochrome modes.
      }
      Textcol := 7;
      BGcol := 0;
      Graphcol := 2;
      RevVideo := FALSE;
    end;

    puttext (1, 10, 'Can You Read This (Y or N)?', Graphcol);
    ch := readkey;
    ch := upcase(ch);
    writeln;
    restorecrtmode;
    if (ch <> 'Y') then
      success := false;
  end;

  if (not success) then begin
    clrscr;
    writeln ('Installation aborted due to problems with GRSYS=', Grsys,
        ' GRMODE=', Grmode);
    writeln ('Suggest you run SURFINST again and try a different GRSYS');
    writeln ('or possibly GRMODE.');
    halt(1);
  end;

  { Write out the configuration file }
  Filename := 'SURFMODL.CFG';
  repeat
    Filebad := FALSE;
    assign (Cfgfile, Filename);
    { Check to see if file already exists }
{$I-}
    reset (Cfgfile);
{$I+}
    if (ioresult = 0) then begin
      close (Cfgfile);
      write ('WARNING: ', Filename,
          ' already exists.  OK to overwrite (Y/N)? ');
      ch := readkey;
      writeln (ch);
      if (ch <> 'y') and (ch <> 'Y') then begin
        writeln ('Installation aborted!');
        halt(1);
      end;
    end;

{$I-}
    rewrite (Cfgfile);
{$I+}
    if (ioresult <> 0) then begin
      Filebad := TRUE;
      writeln ('Error: Can''t create ', Filename);
      writeln ('Enter alternative file name, or hit Enter to abort');
      write (': ');
      readln (Filename);
      if (Filename = '') then
        halt(1);
    end;
  until (not Filebad);

  writeln (Cfgfile, '* This is the SURFMODL configuration file.');
  writeln (Cfgfile, 
    '* It was created by SURFINST, but may be edited by the user with any');
  writeln (Cfgfile, '* standard text editor.');
  writeln (Cfgfile, '* The format is a command, followed by a colon, followed');
  writeln (Cfgfile, '* by one or more values.');
  writeln (Cfgfile, '* Any line starting with an asterisk is a comment.');
  writeln (Cfgfile,
      '* At the very least, it must contain entries for GRSYS and GRMODE');
  writeln (Cfgfile, 'VERSION: 5');
  writeln (Cfgfile, 'GRSYS: ', grsys);
  writeln (Cfgfile, 'GRMODE: ', grmode);
  writeln (Cfgfile, 'EYE: 100, -70, 75');
  writeln (Cfgfile, 'FOCAL: 0, 0, 0');
  writeln (Cfgfile, 'MAGNIFY: 1');
  writeln (Cfgfile, 'VIEWTYPE: STD');
  writeln (Cfgfile, 'LIGHT: 1');
  writeln (Cfgfile, 'LTCOORD: 100, 30, 0');
  writeln (Cfgfile, 'LTINTENS: 0.7');
  writeln (Cfgfile, 'GOURAUD: 0.3');
  writeln (Cfgfile, 'SHADOWING: OFF');
  writeln (Cfgfile, 'AXISSHOW: OFF');
  writeln (Cfgfile, 'AXISLEN: 0.2, 0.2, 0.2');
  writeln (Cfgfile, 'AXISCOLOR: ', Graphcol);
  writeln (Cfgfile, 'RANDOM: 0');
  writeln (Cfgfile, 'BORDERS: OFF');
  writeln (Cfgfile, 'TEXTCOL: ', Textcol);
  writeln (Cfgfile, 'BGCOL: ', BGcol);
  writeln (Cfgfile, 'GRAPHTEXT: ', Graphcol);
  if RevVideo then
    writeln (Cfgfile, 'REVVIDEO: ON')
  else
    writeln (Cfgfile, 'REVVIDEO: OFF');
  writeln (Cfgfile, 'SHOWTITLE: ON');
  writeln (Cfgfile, 'XYADJUST: 1.0');
  close (Cfgfile);

end; { CFG_STUFF }

{ Local variables for main }
var Line: string[20];
    Errcode: integer;
    Select: integer;
    Done: boolean;

begin { main }

  clrscr;
  writeln ('       SURFINST: SURFMODL Automated Installation Utility');
  writeln;
  writeln ('       NOTE that in all prompts the value in brackets');
  writeln ('       is the default, if you just hit Enter.');
  writeln;
  repeat
    writeln ('       Options:');
    writeln ('          1 - Full Installation');
    writeln ('          2 - Just Update System Type in SURFMODL.CFG');
    writeln ('          3 - Abort Installation');
    writeln;
    write ('       Selection [1]: ');
    readln (Line);
    Done := TRUE;
    if Line = '' then
      Select := 1
    else begin
      val (Line, Select, Errcode);
      if (Errcode <> 0) or (Select < 1) or (Select > 3) then begin
        writeln ('You must enter 1, 2 or 3.');
        Done := FALSE;
      end;
    end;
  until Done;

  if (Select = 3) then begin
    writeln ('Installation Aborted!');
    halt;
  end;

  if (Select = 1) then
    copy_files;

  cfg_stuff;

  if (Select = 1) then begin
    writeln;
    writeln ('Full installation completed.');
    writeln ('For a demo of SURFMODL, type DEMO.');
  end;
end. { main }
