	page	,132
;NEWBELL 2-24-83 by Jim Keesey, 2945 Sandra Pl., Palo Alto, CA  94303
;	changes 2-25-83 by J. R. Celoni, S.J.
;	DOS 3.0 bugs fixed 1-25-85 by Hal Sampson
;Run after boot to change DOS (not Basic) bell tone and length.
; (Should be converted to .COM by EXE2BIN)

note_length	equ	1311	;length (ms) * 131.072
note		equ	0a98h	;2712 = 1193180. / 440Hz

cseg	segment public 'code'
	assume	cs:cseg,ds:cseg
	org	100h
start	proc	far
	jmp	initial
start	endp

		even
video_io	dd	0

new_bell	proc	near
	sti			;enable
	cmp	ah,0eh		;tty mode?
	jz	nb1		;yes
vid:	jmp	cs:video_io	;goto rom
nb1:	cmp	al,7		;bell?
  	jnz	vid		;no, let rom do it

;see IBM Tech. Ref. Man. p. A-18:  BEEP & ERR_BEEP
;
	cli			;MUST disable
	push ax
	push cx
	mov	al,0b6h		;sel tim 2,lsb,msb,binary
	out	43h,al		;set up timer chip
	mov	ax,note		;get note
	out	42h,al		;write timer 2 count:  lsb...
	mov	al,ah
	out	42h,al		;...and msb
	in	al,61h
	mov	ah,al		;save current port setting
	or	al,3
	out	61h,al		;turn spkr on
	mov	cx,note_length	;64K = 500 ms
here:	loop	here		;delay
	mov	al,ah
	out	61h,al		;restore port setting
	pop 	cx
	pop	ax
	sti			;enable
	iret

resident_end	equ $+1		;(end of code +1 for int 27H)
new_bell	endp

initial	proc	near
	cli
	lds	si,int10vect 	;int10 = video i/o
	lea	di,video_io
	movsw
	movsw			;save old trap location
	lea	ax,new_bell
	mov	word ptr [si-4],ax	;store new trap loc...
	mov	word ptr [si-2],cs	;...& code seg
	lea	dx,resident_end
	int	27h		;terminate & stay resident
initial	endp
int10vect	dd	40H	;address of int10 vector

cseg	ends
	end	start
