/*	enable auto power up at time on asus TX97-XE board


checksum:
7a-7b

Startup:
4f   bit (0) = 1 enabled
             = 0 disabled
 */

#include <stdio.h>
#include <dos.h>

#define	cmos_sel	0x70		/* address port of CMOS */
#define	cmos_io	0x71		/* data port for CMOS */

main()

{

short en,enstore,h,h1,h2,time,hours,minute,second;
int checksum;
char onoff;

printf("TXE-97-Asus enable Wake up at time  V1.0 by C.H. 1998\n\n\n");
printf("To disable Alarm press: 0  \nTo set PowerUP Time press any key !\n\n");
getclock();
onoff=getch();
if (onoff == '0')goto reset;

printf("Enter hours (0-23): ");
scanf ("%d",&hours);
printf("\nEnter minutes: ");
scanf ("%d",&minute);
printf("\nEnter seconds: ");
scanf ("%d",&second);

if (hours>23)  hours=23;
if (minute>59) minute=59;
if (second>59)second=59;

printf("\nAutomatic PowerUP Time is: %dh.%dm.%ds\n\n",hours,minute,second);

hours=dez_hex(hours);
minute=dez_hex(minute);
second=dez_hex(second);

/*set wakeup time */
outportb(cmos_sel,0x05);
outportb(cmos_io,hours);/*{alarm - stunden}*/
outportb(cmos_sel,0x03);
outportb(cmos_io,minute);/*{alarm - minuten}*/
outportb(cmos_sel,0x01);
outportb(cmos_io,second);/*{alarm - sekunden}*/

reset:
/*enable alarm*/
outportb(cmos_sel,0x4f);
en=inportb(cmos_io);
enstore=en;
/*{set enable bit}*/
if (onoff == '0')en=(en & 254);
else en=(en | 1);
outport(cmos_io,en);

/*correct cmos checksum*/
checksum=readchecksum();
checksum=checksum-enstore+en;
writechecksum(checksum);

if (onoff == '0')printf("Alarm off!\n\n");
else printf("Alarm on!\n\n");

printf("Press any key!");
getch();

return 0;
}

int dez_hex(int time)
{
int h,h1,h2;
h=(time / 10);
h1=h*10;
h2=time-h1;
time=h*16+h2;
return time;}

int readchecksum()
{int checksum;
int h,h1,h2;
disable();			            /* disable interrupts */
outportb(cmos_sel,0x7a);		/* specify byte to get */
checksum=inportb(cmos_io);        	/* get data */
swab(&checksum, &checksum,2 );
outportb(cmos_sel,0x7b);
checksum=checksum+inportb(cmos_io);
enable();			            /* enable interrupts */
return checksum;}

int writechecksum(int checksum)
{char h;
disable();
outportb(cmos_sel,0x7a);
swab(&checksum, &checksum,2 );
h=checksum;
outportb(cmos_io,h);
outportb(cmos_sel,0x7b);
swab(&checksum, &checksum,2 );
h=checksum;
outportb(cmos_io,h);

enable();
return 0;}

int getclock(void)
{
   struct  time t;

   gettime(&t);
	printf("The current time is: %2d:%02d:%02d\n\n",
			 t.ti_hour, t.ti_min, t.ti_sec);
   return 0;
}