/* xkb.c - changes the keyboard repeat rate and the delay
			  (maximum) 30/cps : (minimum) delay 250 msec    */

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

union REGS rin,rout;
void print_error();

main(ac,av)

int ac;
char *av[];

{
	unsigned int int1,int2;

	if(ac < 3)
		{
		print_error();
		exit(1);
		}
	int1 = atoi(av[1]);				/* atoi() returns 0 if not number */
	int2 = atoi(av[2]);           /* if non-numbers are entered as
												arguments, the results are the
												same as : XKB 0 0              */

	if(int1 >= 0 && int1 < 4 && int2 >= 0 && int2 < 33)
		{
		rin.h.ah = 0x03;				/* function 03H of INT 16H */
		rin.h.al = 0x05;

		rin.h.bh = int1;				/* delay 00H-03H (250-1000 msec) */
		rin.h.bl = int2;				/* repeat rate 00H-1FH (2-30cps) */

		int86(0x16,&rin,&rout);		/* call INT 16H   */
		}
	else
		print_error();
}

void print_error()

{
	fprintf(stderr,"\nChange Keyboard Delay and Repeat Rate :\n");
	fprintf(stderr,"   USAGE : XKB num1 num2\n");
	fprintf(stderr,"              (0-3) (0-32)\n");
	fprintf(stderr,"** XKB 0 0 (fast) ** XKB 3 32 (slow) **\n");
}