{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Devices/Keyboard.pas             [x] Protected mode

  How to handle the keyboard device to control user key presses.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFKEYBRD;
     { Incorporate EFLIBDEF and EFLIBKBD units }


begin
     { Wait for ALT to be pressed }
     WriteLn ('Welcome to EFLIB - press the ALT key!');
     repeat until Keyboard^.AltPressed;

     { Wait for CTRL to be pressed }
     WriteLn ('And now press the CTRL key!');
     repeat until Keyboard^.CtrlPressed;

     { Wait for a key press; look at (peek) the key and check character and
       then read the key from the keyboard buffer and return it's scan code. }
     WriteLn ('... and any of your own choice!');
     repeat until Keyboard^.KeyPressed; { Wait for a key }
     WriteLn ('You pressed: ', Keyboard^.PeekKey, ' [', Keyboard^.ReadScanCode, ']');

     WriteLn ('Good bye!');

     Keyboard^.Clear; { Clear the keyboard buffer }
end.