{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Misc/Bitsets.pas                 [x] Protected mode

  EFBASIC contains a fast bit-set class. Bit-sets are ordered sets
  that can contain up to 524,280 elements. All set operations are
  supported, and implemented in fast 32-bit transfers.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC;


var Set1, Set2 : tSet;


procedure Display (What : pSet);
var  Index : byte;
begin
     for Index := 1 to What^.Size do
         if What^.Element (Index) then Write ('o') else Write ('-');
end;

procedure Randomize (What : pSet);
var  Index : byte;
begin
     for Index := 1 to What^.Size do { Random elements }
         What^.SetElement (Index, Random(2) = 1);
end;


begin
     Set1.Initialize (32); Randomize (@Set1);
     Set2.Initialize (32); Randomize (@Set2);

     Write ('Set1   = {'); Display (@Set1); WriteLn ('}');
     Write ('Set2   = {'); Display (@Set2); WriteLn ('}');

     { Let Set1 become the intersection of Set1 and Set2
       (Set1 := Set1 * Set2), ie. the common elements only. }
     Set1.Intersection (@Set2);

     { Display the common elements in the (previous) sets }
     Write ('Common = {'); Display (@Set1); WriteLn ('}');

     Set2.Intercept; Set1.Intercept;
end.