{ CHRTST.PAS : Test CHRLIB unit

  Title   : CHRTST
  Version : 3.3
  Language: Turbo Pascal v4.0+ (all targets)
  Date    : Nov 09, 1996
  Author  : J.R. Ferguson
  Usage   : Test program
}

program ChrTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ENDIF}
  DefLib, ConLib, ChrLib;

const
  MaxName   = 8;

type
 NameIndex = 1..MaxName;
 Name      = packed array[NameIndex] of char;

var
  c0, c     : char;
  i         : integer;


procedure PutAsc(c:char);
 begin if IsPrint(c) then write(c:1) else write('.':1) end;

procedure PutByte(i:integer);
  procedure PutHexDigit(d:integer);
  begin if d<10 then write  (chr(48+d):1) else write  (chr(55+d):1) end;
begin PutHexDigit(i div 16); PutHexDigit(i mod 16) end;

procedure WrCond(txt:Name; cond: boolean);
  var i:NameIndex;
  begin
    if cond then for i:= 1 to MaxName do txt[i]:= UpCase(txt[i]);
    write(txt:MaxName+1)
  end;

procedure WrOrder(i:integer);
  begin
    if i=0 then write('0':1)
    else if i>0 then write('+':1)
    else write('-':1)
  end;

begin { ChrTst }
  writeln; writeln('Test ChrLib');
  c0:= chr(AsciiESC);
  repeat
    writeln;
    write  ('Press a key (ESC=stop) : '); c:= Key; i:= ord(c);
    PutAsc(c); write('  decimal: ',i:3,'  hexadec: '); PutByte(i); writeln;
    write(  'ToAscii: '); PutAsc(ToAscii(c));
    write('  ToUpper: '); PutAsc(ToUpper(c));
    write('  ToLower: '); PutAsc(ToLower(c));
    if c0 <> chr(AsciiESC) then begin
      write('  Order: '   ); WrOrder(   Order(c,c0));
      write('  UppOrder: '); WrOrder(UppOrder(c,c0));
      write('  LexOrder: '); WrOrder(LexOrder(c,c0))
    end;
    writeln;
    WrCond('isalpha ',IsAlpha(c));
    WrCond('isdigit ',IsDigit(c));
    WrCond('isalnum ',IsAlnum(c));
    WrCond('isascii ',IsAscii(c));
    WrCond('iscntrl ',IsCntrl(c));
    WrCond('isprint ',IsPrint(c));
    WrCond('isgraph ',IsGraph(c));
    writeln;
    WrCond('islower ',IsLower(c));
    WrCond('isupper ',IsUpper(c));
    WrCond('ispunct ',IsPunct(c));
    WrCond('isspace ',IsSpace(c));
    WrCond('isbdigit',IsBDigit(c));
    WrCond('isqdigit',IsQDigit(c));
    WrCond('isxdigit',IsXDigit(c));
    writeln;
    c0:= c
  until c=chr(AsciiESC);
  WaitCR;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ENDIF}
end.
