{ VIDLIB.PAS - fast video display routine library

  title   : VIDLIB
  version : 1.0
  date    : Dec 15,1995
  author  : J R Ferguson
  language: Borland Pascal v7.0
  usage   : Unit

  This unit uses the routine library module VIDL86 written in Intel 8086
  assemby language to perform the actual video display routines. It is
  interfaced to that library by a small assembler language module VIDL86P
  which translates the Turbo Pascal parameter-passing conventions into
  the register parameter-passing convention used in VIDL86. Both modules
  are linked into the implementation part of this unit.
}


UNIT VidLib;


INTERFACE


procedure VidInit;
{ Initialize video parameters.
  This procedure MUST be performed once before any other routine in this
  unit is used. It is therefore included in the Initialization part
  of this unit so it will be executed automatically at program start.
  It performs the following initialization:
   - Determine the type of video adapter currently in use.
   - Determine the current video mode (monochrome or color).
   - Set the current display position to row 0 and column 0.
   - Set the snow check mode on.
   - Set the current display attribute to an initial value.
  It will not alter the current screen contents and does not interfere
  with screen I/O not going through this library (for instance MS-DOS
  or BIOS calls.

  The procedure may be performed repeatedly to re-initialize the state of
  the library. The current display position, snow check mode and current
  display attribute can be reset afterwards by means of the procedures
  VidSetPos, VidSnow and VidSetAttr.
}


procedure VidSnow(snowcheck: boolean);
{ Set snow check on/off.

  Avoiding "snow" means the video write routines will wait for the start
  of a horizontal video beam retraction period before writing to the
  video buffer. This slows down the display speed a little, but avoids
  glitches ("snow") on some CGA monitors.

  Note that VidInit will set snow check on. If you want the initial snow
  check mode off, you should specify so by performing this procedure
  after VidInit is performed.
}


function VidSetPos(row,col: byte): boolean;
{ Set current display position to row(0..24), col(0..79).

  The row range is 0..24, the column range 0..79. The upper-left corner
  of the screen corresponds to row 0, column 0. When the row or column
  are out of screen boundaries the function returns false and the current
  position is left unchanged. On success, the function result is true.

  Note that VidInit sets the current display position to row 0, column 0.
  If you want another initial value, specify it by performing this routi-
  ne after the VidInit is performed.
}


procedure VidGetPos(var row,col: byte);
{ Get current display position.

  The row range is 0..24, the column range 0..79. The upper-left corner
  of the screen corresponds to row 0, column 0.
}


procedure VidSetAttr(attr: byte);
{ Set current display attribute to attr.

  Note that VidInit sets the current display attribute to a default
  value. If you want another initial value, specify it by performing
  this procedure after VidInit is performed.
}


function VidGetAttr: byte;
{ Get current display attribute.
}


procedure VidDspChr(c: char);
{ Display ASCII character with current attribute.

  Display a character using the current display attribute at the current
  row and column position. The current display position is incremented,
  wrapping around to the next line if needed. When the last screen
  position is written, the current position wraps around to the upper-
  left corner of the screen.

  The full character code value range of 0..255 is accepted. The parity
  bit is stripped before display, and the following control characters
  are recognized (ord-values in hex):
   $08,$88: Backspace   Decrement current display position
   $09,$89: Tab         Increment current column to next 8-position stop
   $0A,$8A: Line feed   Increment current row
   $0D,$8D: Return      Return to start of current row
  Control characters may cause the current display position to wrap
  around.
}


procedure VidPutChr(c: char);
{ Display literal character with current attribute.

  Display a character using the current display attribute at the current
  row and column position. The current display position is incremented,
  wrapping around to the next line if needed. When the last screen
  position is written, the current position wraps around to the upper-
  left corner of the screen.

  The full character code value range of 0..255 is accepted. Special
  characters like Return, Linefeed, Backspace, Horizontal Tab and Bell
  are not recognized as such but are displayed as found in the computer's
  character font table.
}


procedure VidPutChrAttr(c: char; attr: byte);
{ Display literal character with specified attribute.

  Display a character using the specified display attribute at the
  current row and column position. The current display position is
  incremented, wrapping around to the next line if needed. When the
  last screen position is written, the current position wraps around
  to the upper-left corner of the screen. The current display attribute
  is left unchanged.

  The full character code value range of 0..255 is accepted. Special
  characters like Return, Linefeed, Backspace, Horizontal Tab and Bell
  are not recognized as such but are displayed as found in the computer's
  character font table.
}


procedure VidChgAttr(attr: byte);
{
  Change display attribute at current position.

  Change the display attribute of the character displayed at the current
  row and column position without altering its contents nor the current
  (default) display attribute used with the VidDsp.. and VidPut.. proce-
  dures. The current display position is incremented, wrapping around if
  needed.
}


procedure VidChgChr(c: char);
{
  Change character at current position.

  Change the character displayed at the current row and column position
  without altering its attribute. The current display position is
  incremented, wrapping around if needed.
}


function  VidRetChr: char;
{
  Retrieve character at current position.

  Get the value of the character displayed at the current row and column
  position. The current display position is incremented, wrapping around
  if needed.
}


function  VidRetAttr: byte;
{
  Retrieve attribute at current position.

  Get the attribute of the character displayed at the current row and
  column position. The current display position is incremented, wrapping
  around if needed.
}


procedure VidRetChrAttr(var c: char; var attr: byte);
{
  Retrieve character and attribute at current position.

  Get the value and the attribute of the character displayed at the
  current row and column position. The current display position is
  incremented, wrapping around if needed.
}


procedure VidPutNChr(c: char; n: word);
{ Display literal character repeatedly using the current display
  attribute.

  Display character c using the current display attribute n times in a
  row, starting at the current display position. The display position
  is adjusted with each character and may wrap aroud to a following
  line or to the top of the page.

  The full character code value range of 0..255 is accepted. Special
  characters like Return, Linefeed, Backspace, Horizontal Tab and Bell
  are not recognized as such but are displayed as found in the computer's
  character font table.
}


procedure VidPutNChrAttr(c: char; attr: byte; n: word);
{ Display literal character repeatedly using a specified display
  attribute.

  Display character c using attribute attr for n times in a row, starting
  at the current display position. The display position is adjusted with
  each character and may wrap aroud to a following line or to the top of
  the page. The current display attribute is left unchanged.

  The full character code value range of 0..255 is accepted. Special
  characters like Return, Linefeed, Backspace, Horizontal Tab and Bell
  are not recognized as such but are displayed as found in the computer's
  character font table.
}


procedure VidChgNAttr(attr: byte; n: word);
{
  Change attribute repeatedly

  Change the display attribute for n consecutive characters starting at
  the current display position, without altering their contents or the
  current display attribute.
  The current display position is incremented by n, wrapping around if
  needed.
}


procedure VidChgNChr(c: char; n: word);
{
  Change character repeatedly

  Change the contents of n consecutive characters to c, starting at
  the current display position, without altering their display attribute.
  The current display position is incremented by n, wrapping around if
  needed.
}


procedure VidPutStz(var s);
{ Display literal 0-ended string.

  Display a 0-ended character string using the current display attribute
  at the current row and column position. The current display position is
  incremented with each character, wrapping around to the next line if
  needed. When the last screen position is written, the current position
  wraps around to the upperleft corner of the screen.

  The full character code value range of 0..255 is accepted. Special
  characters like Return, Linefeed, Backspace, Horizontal Tab and Bell
  are not recognized as such but are displayed as found in the computer's
  character font table.

  Remarks:
   The string may not cross its segment.
}


procedure VidDspStz(var s);
{ Display 0-ended ASCII string

  Display a 0-ended character string using the current display attribute
  at the current row and column position. The current display position is
  incremented with each character, wrapping around to the next line if
  needed. When the last screen position is written, the current position
  wraps around to the upperleft corner of the screen.

  The full character code value range of 0..255 is accepted. The parity
  bit is stripped before display, and the following control characters
  are recognized (ord-values in hex):
   $08,$88: Backspace   Decrement current display position
   $09,$89: Tab         Increment current column to next 8-position stop
   $0A,$8A: Line feed   Increment current row
   $0D,$8D: Return      Return to start of current row
  Control characters may cause the current display position to wrap
  around.

  Remarks:
   The string may not cross its segment.
}


procedure VidPutStp(s: string);
{ Display Turbo Pascal type ASCII string.

  Display a Turbo Pascal type string using the current display attribute
  at the current row and column position. The current display position is
  incremented with each character, wrapping around to the next line if
  needed. When the last screen position is written, the current position
  wraps around to the upperleft corner of the screen.

  The full character code value range of 0..255 is accepted. Special
  characters like Return, Linefeed, Backspace, Horizontal Tab and Bell
  are not recognized as such but are displayed as found in the computer's
  character font table.
}


procedure VidDspStp(s: string);
{ Display Turbo Pascal type literal string.

  Display a Turbo Pascal type string using the current display attribute
  at the current row and column position. The current display position is
  incremented with each character, wrapping around to the next line if
  needed. When the last screen position is written, the current position
  wraps around to the upperleft corner of the screen.

  The full character code value range of 0..255 is accepted. The parity
  bit is stripped before display, and the following control characters
  are recognized (ord-values in hex):
   $08,$88: Backspace   Decrement current display position
   $09,$89: Tab         Increment current column to next 8-position stop
   $0A,$8A: Line feed   Increment current row
   $0D,$8D: Return      Return to start of current row
  Control characters may cause the current display position to wrap
  around.
}


procedure VidClrEol;
{ Clear to end of line using current attribute.

  Clears from current position to the end of the line by writing spaces
  with the current attribute. The current display position is not changed.
}


procedure VidClrEolAttr(attr: byte);
{ Clear to end of line using specified attribute.

  Clears from current position to the end of the line by writing spaces
  with the specified attribute. The current display position is not
  changed.
}


procedure VidClrEos;
{ Clear to end of screen using current attribute.

  Clears from current position to the end of the screen by writing spaces
  with the current attribute. The current display position is not changed.
}


procedure VidClrEosAttr(attr: byte);
{ Clear Screen using the specified attribute.

  Clears from current position to the end of the screen by writing spaces
  with the specified attribute. The current display position is not
  changed.
}


procedure VidClrScr;
{ Clear Screen using current attribute.

  Clears the entire screen, writing spaces with the current attribute to
  all rows and columns. Repositions the current display position to row 0,
  column 0 afterwards.
}


procedure VidClrScrAttr(attr: byte);
{ Clear Screen using the specified attribute.

  Clears the entire screen, writing spaces with the specified attribute to
  all rows and columns. Repositions the current display position to row 0,
  column 0 afterwards. The current display attribute is left unchanged.
}


IMPLEMENTATION


{$L VIDL86 }    { The actual video display routines }
procedure _VidInit;                                     external;
procedure _VidSnow;                                     external;
procedure _VidSetPos;                                   external;
procedure _VidGetPos;                                   external;
procedure _VidSetAttr;                                  external;
procedure _VidGetAttr;                                  external;
procedure _VidDspChr;                                   external;
procedure _VidPutChr;                                   external;
procedure _VidPutChrAttr;                               external;
procedure _VidChgAttr;                                  external;
procedure _VidChgChr;                                   external;
procedure _VidRetChrAttr;                               external;
procedure _VidPutNChr;                                  external;
procedure _VidPutNChrAttr;                              external;
procedure _VidChgNAttr;                                 external;
procedure _VidChgNChr;                                  external;
procedure _VidPutStz;                                   external;
procedure _VidDspStz;                                   external;
procedure _VidPutStp;                                   external;
procedure _VidDspStp;                                   external;
procedure _VidClrEol;                                   external;
procedure _VidClrEolAttr;                               external;
procedure _VidClrEos;                                   external;
procedure _VidClrEosAttr;                               external;
procedure _VidClrScr;                                   external;
procedure _VidClrScrAttr;                               external;


{$L VIDL86P}    { Turbo Pascal interface to VIDL86 }
procedure VidInit;                                      external;
procedure VidSnow(snowcheck: boolean);                  external;
function  VidSetPos(row,col: byte): boolean;            external;
procedure VidGetPos(var row,col: byte);                 external;
procedure VidSetAttr(attr: byte);                       external;
function  VidGetAttr: byte;                             external;
procedure VidDspChr(c: char);                           external;
procedure VidPutChr(c: char);                           external;
procedure VidPutChrAttr(c: char; attr: byte);           external;
procedure VidChgAttr(attr: byte);                       external;
procedure VidChgChr(c: char);                           external;
function  VidRetChr: char;                              external;
function  VidRetAttr: byte;                             external;
procedure VidRetChrAttr(var c: char; var attr: byte);   external;
procedure VidPutNChr(c: char; n: word);                 external;
procedure VidPutNChrAttr(c: char; attr: byte; n: word); external;
procedure VidChgNAttr(attr: byte; n: word);             external;
procedure VidChgNChr(c: char; n: word);                 external;
procedure VidPutStz(var s);                             external;
procedure VidDspStz(var s);                             external;
procedure VidPutStp(s: string);                         external;
procedure VidDspStp(s: string);                         external;
procedure VidClrEol;                                    external;
procedure VidClrEolAttr(attr: byte);                    external;
procedure VidClrEos;                                    external;
procedure VidClrEosAttr(attr: byte);                    external;
procedure VidClrScr;                                    external;
procedure VidClrScrAttr(attr: byte);                    external;


BEGIN
  VidInit;
END.
