PROGRAM Scldemo;
{$R-,I+,F-,V-,B-,N-}
{$M 16384,0,655360 }


Uses Dos,Scl;
(*$F+*)   (*Required FOR Background Task*)
PROCEDURE Lp_Background_Task;
BEGIN;
  IF (W_Ptr > 0) AND (R_Ptr > 0) THEN
    BEGIN;                          {both pointers valid}
      IF G_Cont(2) <> Date THEN     {if date has changed}
        W_Cont(2,Date);             {write new one }
      IF G_Cont(3) <> Time(TRUE) THEN {if time has changed}
        W_Cont(3,Time(TRUE));   {write new one with seconds}
    END;
END;
(*$F-*)   (*RESET Option Again*)

FUNCTION Dayname(Dow:INTEGER):String10;  {returns name of day}
BEGIN;
  CASE Dow OF
   0 : Dayname:='Sunday';
   1 : Dayname:='Monday';
   2 : Dayname:='Tuesday';
   3 : Dayname:='Wednesday';
   4 : Dayname:='Thursday';
   5 : Dayname:='Friday';
   6 : Dayname:='Saturday';
  END;
END;

PROCEDURE Do_Format(Formatname:String10);
BEGIN;
  Select_Format(Formatname);  {Load the format from disk}
  Display_Format(0,0);        {Display it in the upper left corner}
  REPEAT
    Handle_Format;        {Complete Loop to handle format input}
    IF End_Of_Format THEN
      Blank_Format;       {if finished then clear the screen}
  UNTIL Format_Done; {completely filled in or abort pressed}
END;

PROCEDURE Date_Demo;
VAR
  J,
  Diff_J,
  Tj        :REAL;
  Wrkstr    :String80;
  H,Min,S,
  Ty,Tm,Td,Tdow,
  Y,M,D,Dow :Word;

PROCEDURE Prefill;
BEGIN;
  Getdate(Ty,Tm,Td,Tdow);   {todays date in integer format}
  W_Cont(4,Dayname(Tdow));   {write name of day to field 4}
  Tj:=Julian_Date(Ty,Tm,Td); {convert date to julian format}
  STR(Tj:1:0,Wrkstr);        {convert julian date to string}
  W_Cont(5,Wrkstr);          {and display it in field 5}
END;

PROCEDURE Update_User_Date;
BEGIN;
  W_Cont(7,St(D));           {write day to field 7}
  W_Cont(8,St(M));           {write month to field 8}
  W_Cont(9,St(Y));           {write year to field 9}
  W_Cont(10,Date_String(Y,M,D)); {formatted date to field 10}
  J:=Julian_Date(Y,M,D);     {convert to y,m,d to julian date}
  STR(J:1:0,Wrkstr);         {convert julian date to string}
  W_Cont(11,Wrkstr);         {display it in field 11}
  Diff_J:=Abs(Tj - J);       {calculate number of days between}
  STR(Diff_J:1:0,Wrkstr);    {today and  date entered, convert}
  W_Cont(12,Wrkstr);         {to a string and write to field 12}
  W_Cont(13,Dayname(Weekday(Y,M,D))); {name of day to field 13}
  Normal_Date(J+100,Y,M,D);  {caculate entered date + 100 days}
  W_Cont(14,Date_String(Y,M,D)); {convert it to a string and}
END;                         {write it to field 14}

PROCEDURE Update_User_Time;
BEGIN;
  W_Cont(16,St(H));      {hours to field 16}
  W_Cont(17,St(Min));    {minutes to field 17}
  W_Cont(18,St(S));      {seconds to field 18}
  W_Cont(19,Time_String(H,Min,S)); {formatted time to field 19}
END;


PROCEDURE Clear_Fields(Field_From,Field_To:INTEGER);
VAR
  Field:INTEGER;
BEGIN;
  FOR Field:=Field_From TO Field_To DO
    C_Cont(Field);                     {blank this field}
END;

PROCEDURE Handle_End_Of_Field;
BEGIN;
  CASE Active_Field OF
    6 : BEGIN;                  {user date entry field}
          Wrkstr:=G_Cont(6);    {read it}
          IF Wrkstr > ' ' THEN  {data was entered}
            BEGIN;
              Check_Date(Wrkstr,Y,M,D); {check and convert}
              IF NOT Glb_Ok THEN        {invalid date entered}
                BEGIN;
                  Glb_Error:=22;        {error number to SCL}
                  Clear_Fields(7,14);   {blank fields 7-14}
                END
              ELSE                      {valid entry}
                Update_User_Date;       {display what we know}
            END
          ELSE                          {blank entered}
            Clear_Fields(7,14);         {clear fields 7-14}
        END;
   15 : BEGIN;                 {user time entry field}
          Wrkstr:=G_Cont(15);  {read it}
          IF Wrkstr > ' ' THEN {time was entered}
            BEGIN;
              Check_Time(Wrkstr,H,Min,S); {check & convert}
              IF NOT Glb_Ok THEN     {invalid time entered}
                BEGIN;
                  Clear_Fields(16,19); {clear fields 16-19}
                  Glb_Error:=23;       {error number to SCL}
                END
              ELSE
                Update_User_Time;      {display user time}
            END
          ELSE                         {blank entered}
            Clear_Fields(16,19);       {clear fields 16-19}
        END;
  END;
END;



BEGIN;
  Select_Format('Datedemo');  {Load the format from disk}
  Prefill;
  Display_Format(0,0);        {Display it in the upper left corner}
  REPEAT
    Handle_Format;
    IF End_Of_Field THEN
      Handle_End_Of_Field     {user interrupt procedures}
    ELSE
    IF End_Of_Format THEN
      Blank_Format;      {if finished then clear the screen}
  UNTIL Format_Done;     {completely filled in or abort pressed}
END;


PROCEDURE Country_Demo;

PROCEDURE Update_Fields;
BEGIN;
  W_Cont(5,St(Country)); {presently used CountryCode to field 5}
  W_Cont(6,Currency);    {currency symbol to field 6}
  W_Cont(7,St(Date_Format)); {date format (0 or 1) to field 7}
  W_Cont(8,Date_Separator);  {..to field 8}
  W_Cont(9,Time_Separator);  {..to field 9}
END;

PROCEDURE Handle_End_Of_Field; {user interrupt procedure}
BEGIN;
  IF Active_Field = 4 THEN     {new country code entered}
    BEGIN;
      IF G_Cont(4) > ' ' THEN  {not blank}
        BEGIN;
          Scl_Country:=Nr(G_Cont(4)); {move it to SCL_Country}
          Get_Country;                {get country information}
          IF (Country <> Scl_Country) AND (Scl_Country > 0) THEN
            BEGIN;            {invalid country code was entered}
              Glb_Error:=24;  {error number to SCL}
              Scl_Country:=Nr(G_Cont(5)); {restore old country}
              Get_Country;                {get country info}
            END
          ELSE                {country code was valid}
            Update_Fields;    {display new country info}
        END;
    END;
END;

BEGIN;
  Select_Format('Countrydem');  {Load the format from disk}
  Update_Fields;              {prefill fields}
  Display_Format(0,0);  {Display it in the upper left corner}
  REPEAT
    Handle_Format;
    IF End_Of_Field THEN
      Handle_End_Of_Field     {user interrupt procedures}
    ELSE
    IF End_Of_Format THEN
      Blank_Format;       {if finished then clear the screen}
  UNTIL Format_Done;  {completely filled in or abort pressed}
END;


PROCEDURE Special_Demo;          {showing tricky fields}
PROCEDURE Handle_User_Function;  {key was pressed}
VAR
  Ch:CHAR;
  Wrkstr:String80;
BEGIN;
  CASE Active_Field OF
    5 : BEGIN;                    {multiple states field}
          IF Char_Code = 32 THEN
            BEGIN;
              Wrkstr:=G_Cont(5);
              IF Wrkstr='Red' THEN Wrkstr:='Yellow' ELSE
              IF Wrkstr='Yellow' THEN Wrkstr:='Green' ELSE
              IF Wrkstr='Green' THEN Wrkstr:='Red';
              W_Cont(5,Wrkstr);
              Char_Code:=Code_Noop;
            END;
        END;
    6 : BEGIN;
          Ch:=CHR(Char_Code);
          IF Ch IN ['Y','y','N','n','?'] THEN
            BEGIN;
              IF (Ch = 'Y') OR (Ch = 'y') THEN
                Wrkstr:='YES'
              ELSE
              IF (Ch = 'N') OR (Ch = 'n') THEN
                Wrkstr:='NO'
              ELSE
                Wrkstr:='Dont Know';   {'?' key pressed}
              W_Cont(6,Wrkstr);
              Char_Code:=Code_Noop;
            END;
        END;
    7 : BEGIN;              {display character code}
          IF (Char_Code <> Code_Return) AND (Char_Code > 0) THEN
            BEGIN;                       {not return or NoOp}
              IF Char_Code > 1000 THEN   {a two code key}
                Wrkstr:='<#27><#'+St(Char_Code-1000)+'>'
              ELSE
                Wrkstr:='<#'+St(Char_Code)+'>'; {a normal key}
              W_Cont(7,Wrkstr);
              Char_Code:=Code_Noop;
            END;
        END;
    8 : BEGIN;                   {upper case display}
          IF Char_Code < 1000 THEN   {not a <esc> nnn key}
            Char_Code:=ORD(UPCASE(CHR(Char_Code)));
        END;
   END;
END;

PROCEDURE Handle_End_Of_Field;
BEGIN;
  IF Active_Field = 4 THEN
    BEGIN;
      IF G_Sel(4) THEN        {if selected the display 'Yes'}
        W_Cont(4,'Yes')
      ELSE
        W_Cont(4,'No');       {otherwise display 'No'}
    END;
END;


BEGIN;
  Select_Format('Special');   {Load the format from disk}
  Display_Format(0,0);    {Display it in the upper left corner}
  REPEAT
    Handle_Format;
    IF User_Function THEN
      Handle_User_Function
    ELSE
    IF End_Of_Field THEN
      Handle_End_Of_Field
    ELSE
    IF End_Of_Format THEN
      Blank_Format;       {if finished then clear the screen}
  UNTIL Format_Done;   {completely filled in or abort pressed}
END;


PROCEDURE Menu;         {This Procedure handles format 'menu'.}
CONST
  Progend:BOOLEAN=FALSE;   {typed constant, saves a statement}
BEGIN;
  REPEAT
    Select_Format('menu'); {Loads the format from disk}
    Display_Format(X_Max DIV 2,Y_Max DIV 2); {Display in center}
    REPEAT
      Handle_Format;     {Complete Loop to handle format input}
    UNTIL Format_Done;   {completely filled in or abort pressed}
    IF G_Sel(4) THEN Do_Format('var') ELSE {variable field demo}
    IF G_Sel(5) THEN Do_Format('const') ELSE {const field demo}
    IF G_Sel(6) THEN Do_Format('outp') ELSE {output field demo}
    IF G_Sel(7) THEN Do_Format('formatting') ELSE {frmtng demo}
    IF G_Sel(8) THEN Do_Format('layout') ELSE  {formLayout demo}
    IF G_Sel(9) THEN Date_Demo ELSE  {date & time demo}
    IF G_Sel(10) THEN Country_Demo ELSE  {country info demo}
    IF G_Sel(11) THEN Do_Format('helpdemo') ELSE {help demo}
    IF G_Sel(12) THEN Special_Demo ELSE {special fields demo}
    IF G_Sel(13) THEN Progend:=TRUE;
  UNTIL Progend;{...until G_Sel(13) wouldn't work because we}
END;        {would read it from the last demo format rather}
                  {than from 'menu'}

BEGIN; {of main}
  Select_Format_File('Sample5');  {initializes SCL and loads the format
                                  {file 'Sample5'}
  Lp_Background_Pointer:=@lp_Background_Task; (*invoke this procedure as
                                   background task*)
  Menu;                           {load,display and handle the menu}
  Close_Formats;                  {terminate SCL}
END.  {of main}
