program PDTest;

uses Objects,PDir,Dos;

var
  DP: DirEntryPtr;
  St: DirStream;
  Orig: PathStr;

procedure ProcessDir(D: DirEntryPtr; DirName: PathStr);
  var
    DirPtr : DirEntryPtr;
  begin
  DirPtr := DirEntryPtr(D^.DirEntries.First);
  while DirPtr <> nil do
    begin
    if DirPtr^.IsDirectory then
      ProcessDir(DirPtr,DirName+'\'+DirPtr^.FileName)
      {recursively process subdirectories}
    else
      WriteLn(DirName+'\'+DirPtr^.FileName);
    DirPtr := DirEntryPtr(D^.DirEntries.Next(DirPtr));
    end;
  end;



begin
Orig := CurDir;
WriteLn('Palcic''s File Finder v1.0');

if ParamCount = 0 then { Syntax is incorrect }
  begin
  WriteLn;
  WriteLn('Syntax: PFF filespec');
  WriteLn;
  WriteLn('Directory names can not be passed.');
  WriteLn;
  WriteLn('Example: PFF *.ZIP');
  WriteLn;
  Halt;
  end;

ChDir('C:\');
New(DP,Clear);

WriteLn;
Write('Scanning for ',ParamStr(1),'...');
DP^.FindDirectories(ParamStr(1),Archive);
WriteLn;
WriteLn;

ProcessDir(DP,'C:');

WriteLn;
WriteLn('Back to original directory ',Orig);
ChDir(Orig);

St.Init('PFF.DAT',SCreate);
DP^.Store(St);
St.Done;

Dispose(DP,Done);

end.
