{$F+} { Compiler Directive: Generate far calls: On } { Do Not Change! }

(*****************************************************************************

  Program:  Character demonstration program.

  Purpose:
    This program demonstrates the abilities of the character drawing units.

  Features:
    This program displays the vector character set defined by the Character
    unit.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Program Character_Draw_Program( Input, Output );

  Uses
    Screen,
    Characters;

  Var
   { Used to space out line lines. }
    Count,
   { These two variables define particular coordinates on the screen. }
    YPiece,
    XPiece: Integer;
   { Holds the default video mode. }
    Old_Mode: Byte;

  Begin
    WriteLn( 'Character demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program simply draws a display of all the characters defined' );
    WriteLn( 'in the Draw unit.  Press enter when it''s finished to exit the program.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;

   { First set up the screen. }
    Get_Screen_Mode( Old_Mode );
    Set_Screen_Mode( 15 );

   { Draw all the characters. }
    YPiece := ( GetMaxY div 8 );
    Draw_String( 1, 1, GetMaxX, Pred( YPiece ), #0#1#2#3#4#5#6#7#8#9#10#11#12#13#14#15#16#17#18#19#20#21#22#23#24#25#26#27#28+
                 #29#30#31 );
    Draw_String( 1, Succ( YPiece ), GetMaxX, Pred( YPiece * 2 ), #32#33#34#35#36#37#38#39#40#41#42#43#44#45#46#47#48#49#50#51+
                 #52#53#54#55#56#57#58#59#60#61#62#63 );
    Draw_String( 1, Succ( YPiece * 2 ), GetMaxX, Pred( YPiece * 3 ), #64#65#66#67#68#69#70#71#72#73#74#75#76#77#78#79#80#81#82+
                 #83#84#85#86#87#88#89#90#91#92#93#94#95 );
    Draw_String( 1, Succ( YPiece * 3 ), GetMaxX, Pred( YPiece * 4 ), #96#97#98#99#100#101#102#103#104#105#106#107#108#109#110+
                 #111#112#113#114#115#116#117#118#119#120#121#122#123#124#125#126#127 );
    Draw_String( 1, Succ( YPiece * 4 ), GetMaxX, Pred( YPiece * 5 ), #128#129#130#131#132#133#134#135#136#137#138#139#140#141+
                 #142#143#144#145#146#147#148#149#150#151#152#153#154#155#156#157#158#159 );
    Draw_String( 1, Succ( YPiece * 5 ), GetMaxX, Pred( YPiece * 6 ), #160#161#162#163#164#165#166#167#168#169#170#171#172#173+
                 #174#175#176#177#178#179#180#181#182#183#184#185#186#187#188#189#190#191 );
    Draw_String( 1, Succ( YPiece * 6 ), GetMaxX, Pred( YPiece * 7 ), #192#193#194#195#196#197#198#199#200#201#202#203#204#205+
                 #206#207#208#209#210#211#212#213#214#215#216#217#218#219#220#221#222#223 );
    Draw_String( 1, Succ( YPiece * 7 ), GetMaxX, Pred( YPiece * 8 ), #224#225#226#227#228#229#230#231#232#233#234#235#236#237+
                 #238#239#240#241#242#243#244#245#246#247#248#249#250#251#252#253#254#255 );
    ReadLn;

   { Return to default graphical mode. }
    Set_Screen_Mode( Old_Mode );

  End.
