(*****************************************************************************

  Generate_FileName
    version 1.11

    This unit is designed to simply generate a unique file name for temporary
      working files.

    Purpose:
      To generate a unique file name particularly in the system tempororary
        file directory.

    How it works:
      The program checks the system environment for a temporary file directory
        then attempts to generate a unique file name in that directory.

    Features:
      Will not overwrite a file name that is currently in existance.

    Limitations:
      Does not verify the validity of the enviromental directory name.
      When compiled under version 4.0, the system environment isn't accessed,
        the current directory is used for the result.

    Versions:
      1.0 - First version.
      1.1 - Added code to idenfity the drive in use.
      1.11 - Added code to allow compiling under Speed Pascal/2.

    Copyright 1995, all rights reserved.
      Paul R. Renaud.

    Compilers:
      Turbo Pascal versions 4.0 to 6.0
      Speed Pascal/2 version 1.5

    Systems:
      MS-DOS, MDOS, OS/2

*****************************************************************************)

{$IFNDEF OS2}
Unit Generate_FileName;
{$ELSE}
Unit Generate;
{$ENDIF}

  Interface

    Uses
      DOS;

(***********************************************************

  Unique file drive
    This value identifies the drive in use for the temporary
    file.  0 = No path found, 1 = A, 2 = B, 3 = C, etc.

***********************************************************)

    Var
      Unique_File_Drive: Byte;

(***********************************************************

  Function:  Generate unique filename.

    This function attempts to find a unique file name that
    can be generated in the temporary file directory.

***********************************************************)

    Function Generate_Unique_FileName: String;

{----------------------------------------------------------------------------}

  Implementation

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Zero string.
    This procedure takes a string and replaces all
    the spaces in it with the zero character.

*************************************************)

    Procedure Zero_String( Var Data: String );
      Var
        Count: Byte;
      Begin
        For Count := 1 to Length( Data ) do
          If ( Data[ Count ] = ' ' )
            then
              Data[ Count ] := '0';
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function:  Generate file name.
    This function attempts to find a file name in
    the specified path that does not exist.  It
    returns the null string if it fails.

*************************************************)

    Function Generate_File_Name( Path: String ): String;
      Var
        Done: Boolean;
        Number: Word;
        Search_Record: SearchRec;
        Result: String;
      Begin
        If ( Length( Path ) > 1 )
          then
            If ( Path[ 2 ] = ':' )
              then
                Unique_File_Drive := Succ( Ord( UpCase( Path[ 1 ] ) ) - Ord( 'A' ) )
              else
                Unique_File_Drive := 0;
        Done := False;
        Number := 0;
        Repeat
          Str( Number: 5, Result );
          Zero_String( Result );
          Result := Path + '\Tmp' + Result + '.$$$' ;
          FindFirst( Result, AnyFile, Search_Record );
          Case DosError of
            3: Path := '';
            18: Done := True;
          End; { Case }
          Inc( Number );
         {$IFDEF OS2}
          FindClose( Search_Record );
         {$ENDIF}
        Until Done or ( Number = 32000 );
        If Done
          then
            Generate_File_Name := Result
          else
            Generate_File_Name := '';
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function:  Generate unique file name.
    As previously defined.

*************************************************)

    Function Generate_Unique_FileName: String;
      Var
        Path: String;
      Begin
       {$IFDEF VER40}
        Path := '';
       {$ELSE}
        Path := GetEnv( 'Temp' ); { For MS-DOS }
        If ( Path = '' )
          then
            Path := GetEnv( 'Tmp' ); { For MDOS }
       {$ENDIF}
        Generate_Unique_FileName := Generate_File_Name( Path )
      End;

{----------------------------------------------------------------------------}

  End.

