(*****************************************************************************

  TextLink
    version 1.0

  Purpose:
    To allow a easy and faster link between TextEdit, Extras and Correct.
    This unit is not meant to be used as a stand alone unit.

  Features:
    Procedure to support string displaying.
    Puts status carrier in static memory to increase processing speed.

  Limitations:
    This unit should not be overlaid.

  CopyRight 1994, All rights reserved.
    By Paul Renaud

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit TextLink;

  Interface

    Uses
      CRT,
      Core, KeyBoard,
      TextEdit;

    Var
      { This procedure is called to display the status during block operations. }
      Display_Status: Procedure( Amount: Byte );

(***********************************************************

  Procedure: Substitute.
    This procedure replaces the given character in the given
    string with the replacement.

***********************************************************)

    Procedure Substitute( Var Data: String; Character, Replacement: Char );

(***********************************************************

  Procedure: Process status.
    This procedure is called to display the internal status
    on the screen

***********************************************************)

    Procedure Process_Status( Where, Limit: LongInt; Var Continue: Boolean );

(***********************************************************

  Procedure: Pause for key.
    This procedure is designed to display the message and
    wait for enter to be pressed.

***********************************************************)

    Procedure Pause_For_Key;

(***********************************************************

  Procedure: Display status default.
    This procedure is called to display the internal status
    of the current operation on the screen.

***********************************************************)

    Procedure Display_Status_Default( Amount: Byte );

(***********************************************************

  Function: Get answer.
    This function prompts for an answer on the screen and
    returns it as either Y, N, or E.

***********************************************************)

    Function Get_Answer: Char;

{----------------------------------------------------------------------------}

  Implementation

    Var
      { Holds the previous status value. }
      Previous_What: Byte;

    {$DEFINE Quick} { Select alternate code for faster processing speed. }

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Pause for key.
    As previously defined.

*************************************************)

    Procedure Pause_For_Key;
      Var
        Command: Char;
        Result: Byte;
      Begin
        Cursor_Row := WhereY;
        TextAttr := Message_Normal;
        Write( Screen, 'Press ' );
        TextAttr := Message_HighLight;
        Write( Screen, 'ENTER ' );
        TextAttr := Message_Normal;
        Write( Screen, 'to continue. ' );
        Delay( 200 );
        Repeat
          Get_Command( Command, Result );
        Until ( Result in [ Press_Enter, Pointer_Up, Pointer_Down, Pointer_Left, Pointer_Right ] );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Process status.
    As previously defined.

*************************************************)

    Procedure Process_Status( Where, Limit: LongInt; Var Continue: Boolean );
      Var
        What: Byte;
        Command: Char;
      Begin
        If Data_Ready
          then
            Begin
              Get_Command( Command, What );
              If ( What = Press_Escape )
                then
                  Escape_Operation( Continue );
            End
          else
            Begin
              If ( Where <= Limit )
                then
                  What := ( ( Where * 100 ) div Limit )
                else
                  What := 100;
              If ( What <> Previous_What )
                then
                  Begin
                    Previous_What := What;
                    Display_Status( What );
                  End;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display status default.
    As previously defined.

*************************************************)

    Procedure Display_Status_Default( Amount: Byte );
      Begin
        GotoXY( 1, 2 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Processing: ' );
        TextAttr := Message_Normal;
        Write( Screen, Amount:3, '% ' );
        TextAttr := Message_HighLight;
        Write( Screen, 'complete. ' );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Substitute.
    As previously defined.

*************************************************)

    Procedure Substitute( Var Data: String; Character, Replacement: Char );
      Var
        Where: Byte;
      Begin
        Where := Pos( Character, Data );
        While ( Where <> 0 ) do
          Begin
            Data[ Where ] := Replacement;
            Where := Pos( Character, Data );
          End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get answer.
    As previously defined.

*************************************************)

    Function Get_Answer: Char;
      Var
        Answer: Char;
        Command: Byte;
      Begin
        TextAttr := Message_Normal;
        Write( Screen, '( ' );
        TextAttr := Message_HighLight;
        Write( Screen, 'Y ' );
        TextAttr := Message_Normal;
        Write( Screen, 'or ' );
        TextAttr := Message_HighLight;
        Write( Screen, 'N ' );
        TextAttr := Message_Normal;
        Write( Screen, ') ' );
        Repeat
          Get_Command( Answer, Command );
          Answer := UpCase( Answer );
        Until ( ( Answer in [ 'Y', 'N' ] ) or ( Command = Press_Escape ) );
        If ( Command = Press_Escape )
          then
            Get_Answer := 'E'
          else
            Get_Answer := Answer;
      End;

{---------------------------------------------------------------------------}

  Begin
    Display_Status := Display_Status_Default;
  End.
