{*****************************************************************************}
{*  This program displays characters inside their character box.             *}
{*  It demonstrates how small portion of the character box which is          *}
{*  filled up by the character. It is the percentage of the character        *}
{*  box as regards to the Maximal x coordinates which is used to set the     *}
{*  character size.                                                          *}
{*                                                                           *}
{*  This code is donated to the Public domain.                               *}
{*                                                                           *}
{*  Dov Grobgeld                                                             *}
{*  Department of Chemical Physics                                           *}
{*  The Weizmann Institute of Science                                        *}
{*  Israel                                                                   *}
{*  Email: dov@menora.weizmann.ac.il                                         *}
{*                                                                           *}
{*  8/9/1991                                                                 *}
{*****************************************************************************}
uses Graph, Dos, TPHersh;

var
  gd, gm : integer;
  mem: longint;
  symNum : integer;

begin
  mem:= MaxAvail;
  HersheyLoadGlyphs;
  writeln('Font load size: ', mem - MaxAvail);
  write('Press Enter to continue...'); readln;

  gd:= detect;
  initgraph(gd, gm, getenv('bgidir')); { Set the environment variable bgi dir }
                                       { to the directory where the bgi files reside }
  HersheySetGlyphSize(40,40);
  symNum:=501;
  repeat
    clearviewport;
    HersheyMove(200, 200);
    rectangle(round(HersheyX - 0.40*HersheyMaxX/2),
              round(HersheyY - 0.40*HersheyMaxX/2),
              round(HersheyX + 0.40*HersheyMaxX/2),
              round(HersheyY + 0.40*HersheyMaxX/2));
    HersheyMove(round(200- HersheyGlyphWidth(symNum)/2),200);
    setcolor(white);
    HersheyDisplayGlyph(symNum);
    readln(symNum);
  until symNum=0;
  closegraph;
end.

