#
# Flags for makefile:
#
#     -DOVERLAY      Build an overlayable version
#
#     -DDOS16        Build the 16-bit DPMI version
#
#     -DDOS32        Build the 32-bit DPMI version
#
#     -DDEBUG        full debug info.
#
#     -DGFXDEBUG     use the debugging version of the GFX
#                    library.
#
#     -DTVDEBUG      use the debugging version of the Turbo Vision
#                    library.  This assumes that you have built
#                    the debugging version of the Turbo Vision library
#                    for whichever target you are compiling to.
#
#     -DALIGNMENT=2  Word (=2) or dword (=4) aligned library.
#     -DALIGNMENT=4
#
#     -DEXCEPTIONS   Compile with exception handling code in the
#                    library.  Note that Turbo Vision does NOT throw
#                    any exceptions.
#
#
#   If you installed TVISION somewhere other than directly under
#   BORLANDC or TC, you must invoke MAKE with two defines:
#
#     -DBCROOT=... specifies the path where you installed the compiler
#
#     -DTVDIR=...  specifies the path where you installed TVISION
#
#   Examples:
#
#     for a standard installation:
#
#       make
#
#     for an installation in \COMPILER and TVISION in \AF:
#
#       make -DBCROOT=\COMPILER -DTVDIR=\AF
#
#   Any of these defines can be omitted if the corresponding name
#   is defined in the environment:
#
#       set BCROOT=\COMPILER
#       set TVDIR=\AF
#       make -DOVERLAY
#
#
.autodepend
.swap

SOURCE = GFX
TESTPROG = TSTGFX
BGI =

!if !$d(NODEBUG)
DEBUG =
!endif

!if $d( OVERLAY ) && ( $d( DOS16 ) || $d( DOS32 ) )
!error Overlays cannot be used in protected mode.
!endif

!if !$d(BCROOT)
BCROOT = $(MAKEDIR)\..
!endif

!if !$d(TVDIR)
TVDIR = $(BCROOT)
!endif

!if !$d(SRCDIR)
SRCDIR = $(TVDIR)\SOURCE\TVISION
!endif

!if "$(BCROOT)"=="$(TVDIR)"    # shorten the include/lib paths if TV
LIBPATH = $(BCROOT)\LIB        # is in the same place as the compiler
INCPATH = .;$(BCROOT)\INCLUDE 
!else
LIBPATH = $(TVDIR)\LIB;$(BCROOT)\LIB
INCPATH = .;$(TVDIR)\INCLUDE;$(BCROOT)\INCLUDE
!endif

!ifdef DEBUG                   # set appropriate flags for debugging
ADEBUGFLAG = /zi
CCDEBUGFLAG = -v
LINKDEBUGFLAG = /v
!endif

!ifdef TVDEBUG                 # this suffix is added to Turbo Vision
TVSUFFIX = d                   # library name, ie TV.LIB becomes TVD.LIB
!endif

!ifdef GFXDEBUG                # this suffix is added to GFX
GFXSUFFIX = d                  # library name, ie GFX.LIB becomes GFXD.LIB
!endif

!ifdef OVERLAY                 # set overlay flags
AOVYFLAGS   = /o
CCOVYFLAGS  = -Y -Vs
LINKOVY_ON  = /o+
LINKOVY_OFF = /o-
OVERLAYSUFFIX = o
!endif

!if $d(BGI)                    # set BGI library
BGILIB = graphics.lib
!if $d(DOS16)
BGILIB = bgi16.lib
!endif
!if $d(DOS32)
BGILIB = bgi32.lib
!endif
!endif

#
# default options produce a real mode application
#

DEFAULTCFG = TURBOC.CFG
CC         = bcc
ASM        = tasm
TLINK      = tlink
TLIB       = tlib
STARTUP    = c0l.obj
USERLIBS   = tv$(TVSUFFIX).lib
STDLIBS    = $(BGILIB) + emu.lib + mathl.lib + cl.lib
CCFLAGS    = -ml -R -Vf- -h- -Ff -Ff=5000 -Oc -Ot -Z -Op -Oi $(CCDEBUGFLAG) $(CCOVYFLAGS)
AFLAGS     = /ml /m2 $(ADEBUGFLAG) $(AOVYFLAGS)
LINKFLAGS  = $(LINKDEBUGFLAG)
OBJDIR     = objs$(GFXSUFFIX)$(OVERLAYSUFFIX)
GFXLIB     = $(SOURCE)$(GFXSUFFIX)R$(OVERLAYSUFFIX)
CFGFILE    = $(GFXLIB).CFG
TESTEXE    = $(TESTPROG)$(OVERLAYSUFFIX)

#
# overlayed application options
#

!ifdef OVERLAY
GFXLIB_NOOVL  = $(SOURCE)$(DEBUGSUFFIX)RN$(OVERLAYSUFFIX)
USERLIBS   = tvo$(TVSUFFIX).lib
STDLIBS    = ..\$(GFXLIB_NOOVL).lib + tvno$(TVSUFFIX).lib + $(BGILIB) + overlay.lib + emu.lib + mathl.lib + cl.lib
!endif

#
# 16 bit protected mode application options
#

!ifdef DOS16
CC         = bcc
ASM        = tasm
TLINK      = tlink
STARTUP    = c0x.obj
USERLIBS   = ..\dpmiexcp.lib + ..\pdr16.lib
STDLIBS    = $(BGILIB) + dpmi16.lib + emux.lib + mathwl.lib + tv$(TVSUFFIX).lib + cwl.lib
AFLAGS     = /ml /m2 $(ADEBUGFLAG)
CCFLAGS    = -WX -R -ml -Vf- -h- -Ff -Ff=5000 -Oc -Ot -Z -Op -Oi $(CCDEBUGFLAG)
LINKFLAGS  = /Txe $(LINKDEBUGFLAG)
OBJDIR     = objs16$(GFXSUFFIX)
GFXLIB     = $(SOURCE)$(GFXSUFFIX)16
CFGFILE    = $(GFXLIB).CFG
TESTEXE    = $(TESTPROG)16
DEFFILE    = tvdpmi16.def
!endif

#
# 32 bit protected mode application options
#

!ifdef DOS32
DEFAULTCFG = BCC32.CFG
CC         = bcc32
ASM        = tasm32
TLINK      = tlink32
STARTUP    = c0x32.obj
USERLIBS   = ..\dpmiex32.lib + ..\pdr32.lib + tv32$(TVSUFFIX).lib
STDLIBS    = $(BGILIB) + dpmi32.lib + cw32.lib
AFLAGS     = /ml /m2 $(ADEBUGFLAG) /D__FLAT__
CCFLAGS    = -WX -N- $(CCDEBUGFLAG)
LINKFLAGS  = /Tpe/ax /m /s /S:16384 $(LINKDEBUGFLAG)
OBJDIR     = objs32$(GFXSUFFIX)
GFXLIB     = $(SOURCE)$(GFXSUFFIX)32
CFGFILE    = $(GFXLIB).CFG
TESTEXE    = $(TESTPROG)32
DEFFILE    = tvdpmi32.def
!endif


.path.obj = $(OBJDIR)
.suffixes: .cpp .asm

!if $d(ALIGNMENT)
ALIGNFLAG = -a$(ALIGNMENT)
!else
ALIGNFLAG =
!endif

!if $d(EXCEPTIONS)
EXCEPTFLAG = -x
!else
EXCEPTFLAG = -x-
!endif

CFLAGS = $(CCFLAGS) $(EXCEPTFLAG) $(ALIGNFLAG) -P\
         -I$(INCPATH) -n$(OBJDIR) -w -w-sig

!if $d(NO_STREAMABLE)
CFLAGS = $(CFLAGS) -DNO_STREAMABLE
!endif


!if $d(DEFFILE)
DEFFILE = ..\$(DEFFILE)
!endif

all: $(CFGFILE) dirs $(TESTEXE).exe

dirs:
    if not exist $(OBJDIR)\make0001.@@@ MD $(OBJDIR)

$(CFGFILE): tstgfx.mak
  @copy &&|
$(TARGETFLAG) $(CFLAGS)
-vi
-d
-RT-
-wpre
-wdef
-wnod
-wamb
-wuse
-wstv
-wasm
-wobs
-wbbf
-wpin
-wnak
| $@
   @Copy $@ $(DEFAULTCFG)

*.cpp: $(CFGFILE)


#		*Implicit Rules*
.c.obj:
  $(CC) -c +$(CFGFILE) {$*.c }

.cpp.obj:
  $(CC) -c +$(CFGFILE) {$*.cpp }

.asm.obj:
  $(ASM) $(AFLAGS) /i$(SRCDIR) $&.asm $(OBJDIR)\$&.obj


EXE_dependencies = $(CFGFILE) $(GFXLIB).lib $(TESTPROG).OBJ 


$(TESTEXE).exe: $(EXE_dependencies)
  cd $(OBJDIR)
  $(TLINK) @&&|
$(LINKFLAGS) /L$(LIBPATH) +
$(STARTUP) + $(TESTPROG).OBJ
..\$(TESTEXE)
..\$(TESTEXE)
$(LINKOVY_ON) ..\$(GFXLIB).lib + $(USERLIBS) +    # overlayable libraries
$(LINKOVY_OFF) $(STDLIBS)       # non-overlayable libraries
$(DEFFILE)
|
  cd ..

