;
;				  TRIM
; This program trims the blanks	and tabs (white	space) from the	ends of	lines.
; Standard Input and Output are	used, and the DOS re-direction facility	is
; used to operate on disk files.  Lines	may be up to 255 chars long, counting
; eoln.
;


codeseg		segment
		assume	cs:codeseg, ds:codeseg


		org	100h

trim		proc	far

start:		jmp	Main

in_handle	dw	0		; handle for std input
out_handle	dw	1		; handle for std output
buffer		db	0		; I/O buffer, 255 chars
		db	255 dup	(0)

Main:
		call	get_line	; get a	line from std input
		jc	Exit		; exit on error	(or eof)
		call	trim_line	; trim spaces/tabs from	end
		call	put_line	; send trimmed line to std output
		jc	Exit		; exit on error
		jmp	short Main	; continue until eof or	error

Exit:
		mov	bx,in_handle	; 'close' std input to flush buffers
		mov	ah,3Eh
		int	21h
		int	20h		; terminate program.

trim		endp

;-------------------

;		SUBROUTINE
;		gets line from std input

get_line	proc	near
		mov	si,offset buffer	; point	si to start of buffer
get_1:
		mov	dx,si			; set up dx
		mov	cx,1			; set char count
		mov	bx,in_handle		; handle for std in (0)
		mov	ah,3Fh			; input	cx chars from std in
		int	21h
		jc	get_finish		; error	- return cf set
		cmp	byte ptr [si],0Ah	; no error - chk for eoln
		je	get_finish		;  ret cf 0 if true
		mov	cx,ax			; get char count into cx
		cmp	byte ptr [si],1Ah	; check	for eof
		stc				; set cf for eof true
		jz	get_finish		; ret cf 1 if eof
		jcxz	get_finish		; ret cf 1 if 0	chars read
		inc	si			; move buffer pointer
		cmp	si,offset buffer+255	; check	for buffer overrun
		stc
		je	get_finish		; error	exit if	overrun
		clc
		jmp	short get_1		; get next char
get_finish:	ret

get_line	endp

;-------------------

;		SUBROUTINE
;		this is	the routine that removes trailing blanks/ tabs.

trim_line	proc	near
		sub	si,2			; move si to precede 0D	0A
trim_1:
		cmp	byte ptr [si],20h	; check	for space
		je	trim_ck
		cmp	byte ptr [si],9		; check	for horiz tab
		je	trim_ck
		inc	si			; keep any other char
		jmp	short trim_done
trim_ck:
		cmp	si,offset buffer	; at beginning of buffer?
		je	trim_done		;  if so, no more chars.
		dec	si			; point	to next	char down
		jmp	short trim_1		; repeat checks
trim_done:
		mov	byte ptr [si],0Dh	; place	eoln chars here
		mov	byte ptr [si+1],0Ah
		ret

trim_line	endp

;-------------------

;		SUBROUTINE
;		output line to std output

put_line	proc	near
		mov	si,offset buffer	; point	to start of buffer
		mov	dx,si			; set up dx
		xor	cx,cx			; init char count to 0
put_1:
		inc	cx			; start	counting chars
		lodsb				; mov 1	by 1 into al
		cmp	al,0Ah			; check	for eoln
		jne	put_1			; continue.
		mov	bx,out_handle		; std out handle
		mov	ah,40h
		int	21h			; send to std out
		ret				; cf = 1 if error

put_line	endp

;-------------------

codeseg		ends

		end	start
