GETLINES(1V)               TEXT UTILITIES                GETLINES(1V)

NAME
	getlines - Show specified lines of text file given line number(s)

AUTHOR
	Jason Mathews
	NASA/Goddard Space Flight Center
	Code 633.2
	Greenbelt, Maryland  20771
	<mathews@nssdca.gsfc.nasa.gov>

COPYRIGHT
	Copyright (C) 1994 by Jason Mathews.  Permission is granted to any
	individual or institution to use, copy or modify this software so
	long as it is not sold for profit, provided this copyright notice
	is retained.

AVAILABILITY
	GETLINES is available for MS-DOS, UNIX, and VMS systems with ANSI
	compilers.

SYNOPSIS
	GETLINES [filename] [-ln] [-cn] [-n]

DESCRIPTION
	Given a list of line numbers within a specifed text file,
	GETLINES displays the corresponding lines.  GETLINES can be
	used within a flat-file database system to show entries in
	a database given their relative line numbers.

OPTIONS
	-ln  Display line number n, where n >= 1.  The default is 1.

	-cn  Display n lines.  The default is 1.

	-n   Precede each line by its relative line number in the file.

	If -l and -c are not specified then the line number input is
	accepted from stdin.  If stdin is from the console then the
	user will be prompted for each line.  If line numbers are
	read from stdin then each line must be entered on a new line
	followed by a carriage return.

	If filename is not specified then it is entered from stdin.

EXAMPLES

	Get line numbers 1000-1020 from the file 'testfile.c':

		GETLINES testfile.c -l1000 -c20

	Generate line numbers from a program and pipe the output
	into getlines as the input stream:

		PROGRAM | GETLINES textfile.dat

	Pipe line numbers from file 'numbers.lst' and show
	the line numbers along with corresponding text:

		GETLINES foo.c -n < numbers.lst

        Prompt user for input:

                GETLINES
                Filename to search: bar.c
		Line number to extract: 100

DIAGNOSTICS
        Exit status is 0 if successful, 1 for syntax errors or
        inaccessible file.

	Invalid line <n>: <file> only has <m> lines
		Line number exceeds the number of lines in the file.

	Illegal line number <n>
		Either line number is not an integer or is non-positive.

	Illegal parameter or value: <parameter>
		Either -c and -l parameter values are illegal (zero or
		negative) or an invalid parameter is used.

	Cannot open <filename>: <reason>
		Either filename cannot be read or does not exist.

MS-DOS/UNIX Release 1.0    Last Change: 21 May 1994
