/* VGADRV.H (VGA-level)		SCREEN library
 * Description:
 *      VGA mode 13h defines and macros.
 * Portability: BORLANDC
 * $Header: egadrv.h,v 1.2 91/06/02 16:09:07 erdy Exp $
 *				Copyright (c)   erdy 1992
 */
#ifndef _VGADRV_H_
#       define _VGADRV_H_
/*
 * Keys to grswitch:
 */
#define GRSWITCH_EXIT 0
#define GRSWITCH_SOFF 0x10                   /* Disable refreshing */
#define GRSWITCH_CMODE 0x20                  /* Switch to chained mode */
#define GRSWITCH_UMODE 0x40                  /* Switch to unchained mode */

#define SCMODE_CHAINED    0
#define SCMODE_UNCHAINED  1

extern struct Svideo {
        char     aname[8];              /*                    */
        unsigned int page_seg[4];
        unsigned int vpage;             /*  ࠭    */
        unsigned int opage;             /* ࠭  뢮 */
        union saddress {
		unsigned int w;
		char b[2];
        } saddress[2];
	union saddress top;
        int      oldmode;      /*  ࠡ          */
} Sadapter;

/* MCGA CHAINED/UNCHAINED mode settings:
 * -------------------------------------
 */

#if defined(VGA_DUALMODE) && !defined(VGA_UNCHAINED)
#       define VGA_UNCHAINED
#endif

/* MCGA Common settings: */
#define VGA_RAM ((char far *)0xA0000000)   /* VGA Video RAM address  */
#define VGA_RAMSIZE 0x10000                /* Size of RAM, as mapped to host */
#define VGA_SEG0 0xA000                    /* Segment address of VRAM */
#define PPERBYTE 1                         /* Pixels per byte */
#define BITPLANES 4
#define MAXROWS 200
#define MAXCOLS 320
#define MAXCOLORS 256
#define MAXCOLORCODE 63
#define BPERDCOLOR 3                            /* Byte per direct color code */
#define PALETTESIZE (MAXCOLORS*BPERDCOLOR)
#define ASP_RATIO  0.7
#define ASP_RATIO_NUMERATOR  7
#define ASP_RATIO_DENOMINATOR 10

/* MCGA ChainFourOn (standard) mode settings: */
#define MAXPAGES_CHAINED 1
#define VGA_SEG1_CHAINED 0xAFA0
#define VGA_PSIZE_CHAINED 0xFA00           /* = 64000. Graphic Page length */
#define BPERROW_CHAINED 320                /* Bytes per scanline */
#define BPERSCREEN_CHAINED 320

/* MCGA ChainFourOff mode settings: */
#define MAXPAGES_UNCHAINED  4
#define VGA_SEG1_UNCHAINED 0xA3E8
#define VGA_SEG2_UNCHAINED 0xA7D0
#define VGA_SEG3_UNCHAINED 0xABB8
#define VGA_PSIZE_UNCHAINED 0x3E80          /* =16000. Graphic Page length */
#define BPERROW_UNCHAINED 80                /* Bytes per scanline */
#define BPERSCREEN_UNCHAINED 80

#ifdef VGA_UNCHAINED
#       ifndef BPERROW
#               define BPERROW BPERROW_UNCHAINED
#       else  BPERROW
#               define VGA_BPERROW
#       endif BPERROW
#       define BPERSCREEN BPERSCREEN_UNCHAINED
#       define MAXPAGES MAXPAGES_UNCHAINED
#       define VGA_SEG1 VGA_SEG1_UNCHAINED
#       define VGA_SEG2 VGA_SEG2_UNCHAINED
#       define VGA_SEG3 VGA_SEG3_UNCHAINED
#       define VGA_PSIZE VGA_PSIZE_UNCHAINED
#else  VGA_UNCHAINED
#       ifndef BPERROW
#               undef BPERROW
#               define BPERROW BPERROW_CHAINED
#       endif BPERROW
#       define BPERSCREEN BPERSCREEN_CHAINED
#       define MAXPAGES MAXPAGES_CHAINED
#       define VGA_SEG1 VGA_SEG1_CHAINED
#       define VGA_SEG2 VGA_SEG1_CHAINED
#       define VGA_SEG3 VGA_SEG1_CHAINED
#       define VGA_PSIZE VGA_PSIZE_CHAINED
#endif VGA_UNCHAINED

#define VIDEO_UYTOADDRESS(y) (y*BPERROW)
#define VIDEO_CYTOADDRESS(y) (y*BPERROW_CHAINED)
#define VIDEO_UXTOADDRESS(x) (x>>2)
#define VIDEO_CXTOADDRESS(x) x
#define VIDEO_UADDRESS(x, y) (VIDEO_UXTOADDRESS(x)+VIDEO_UYTOADDRESS(y))
#define VIDEO_CADDRESS(x, y) (VIDEO_CXTOADDRESS(x)+VIDEO_CYTOADDRESS(y))
#ifdef VGA_DUALMODE
#       define VIDEO_ADDRESS(x, y) \
        (Scmode == SCMODE_CHAINED)? VIDEO_CADDRESS(x, y):VIDEO_UADDRESS(x,y)
#elif defined(VGA_UNCHAINED)
#       define VIDEO_ADDRESS(x, y) VIDEO_UADDRESS(x, y)
#else  VGA_UNCHAINED
#       define VIDEO_ADDRESS(x, y) VIDEO_CADDRESS(x, y)
#endif

#define _DefaultRMode READMODE0
#define _DefaultWMode WRITEMODE0
#define _setDefaultRWModes()


/*
 * Hardware macros:
 * ----------------
 */
#define VGA_CRTC_ADR  0x3D4          /* CRT Controller, Address Register */
#define VGA_CRTC_GATE 0x3D5          /* CRT Controller, Index/Data Register */
#       define _CRT_OVERFLOW     7
#       define _CRT_MAXSCANLINE  9
#       define _CRT_CURSOR_START 10
#       define _CRT_CURSOR_STOP  11
#       define _CRT_STARTAD_HIGH 12
#       define _CRT_STARTAD_LOW  13
#       define _CRT_CURPOS_HIGH  14
#       define _CRT_CURPOS_LOW   15
#	define _CRT_LINECOMPARE  0x18
#       define _CURSOR_OFF 0360
#define VGA_ATC  0x3C0       /* Attribute Controller Registers, Addr. reg.  */
#define VGA_GADR 0x3CE       /* Graphic Controller Registers, Addr. reg.    */
#define VGA_GCD  0x3CF       /* Graphic Controller Registers, Data reg.     */
#       define _GCD_SETRES 0 /* 롮 ॣ /⠭ GCD   */
#       define _GCD_ENSET  1 /* 롮 ॣ ࠧ襭 /. GCD*/
#       define _GCD_CCOMPARE 2 /* 롮 ॣ ࠢ 梥⮢  GCD*/
#       define _GCD_ROTATE 3 /* 롮 ॣ 饭      GCD      */
#       define _GCD_MAPSEL 4 /* 롮 롮                     */
#       define _GCD_MODES  5 /* 롮 ॣ ० GCD            */
#       define _GCD_DONTCARE 7 /* 롮 ॣ ࠧ 梥    */
#       define _GCD_BITMASK  8 /* 롮 ॣ ⮢ ᪨ GCD    */
                             /*    ⥭:               */
#              define WRITEMODE0 0
#              define WRITEMODE1 1
#              define WRITEMODE2 2
#              define WRITEMODE3 3
#              define WRITEMODEMASK 3
#              define READMODE0 0
#              define READMODE1 010
#              define READMODEMASK 010
#define AND_LOGIC 010
#define XOR_LOGIC 030
#define OR_LOGIC  020

#define VGA_SER_ADR   0x3C4 /* Sequencer Registers, Addr. reg. */
#define VGA_SER_GATE  0x3C5 /* Sequencer Registers, Data. reg. */
#       define _SER_CM_RESET 0
#       define _SER_CM_REG   1  /* Clocking Mode register */
#       define _SER_MAPMASK  2  /* Map Mask register */
#       define _SER_MM_REG   4  /* Memory Mode register */
#define _SER_CM_SO 0x20      /* 0 - Screen on, 1 - off */
#define _SER_CM_S4 0x10      /* Shift Four */
#define _SER_CM_DC 0x8       /* Dot clock */
#define _SER_CM_SL 0x4       /* Shift Load */
#define _SER_CM_BW 0x2       /* BW */
#define _SER_CM_89 0x1       /* 8/9 */
#define _SER_MM_C4 0x8       /* 1-Planes Chained, 0-Planes are to be selected */
#define VGA_PEL_WA 0x3c8        /* PEL address Write Mode register */
#define VGA_PEL_RA 0x3c7        /* PEL address Read Mode register */
#define VGA_PEL_DATA 0x3c9      /* PEL address Data register */
#define VGA_PEL_STA 0x3c7       /* DAC state */
#define VGA_PEL_MASK 0x3c6      /* PEL Mask register */

#define VGA_IS1  0x3DA /* Read: Input status # 1 */
#define VGA_STA  0x3DA /* Write: Feature Control 0  1 */

#define VGA_RETRACE  1 /*  ਧ⠫  ⨪ retrace */
#define VGA_HRETRACE 1 /*  ਧ⠫ retrace */
#define VGA_VRETRACE 8 /*  ⨪ retrace */


#ifdef __TURBOC__

#define _chain4Off() asm {\
        mov dx, VGA_SER_ADR;\
        mov ax, 0x0604;\
        out dx, ax;\
        mov dx, VGA_CRTC_ADR;\
        mov ax, 0x0014;\
        out dx, ax;\
        mov ax, 0xE317;\
        out dx, ax;}

#define _chain4On() asm {\
        mov dx, VGA_SER_ADR;\
	mov ax, 0x0E04;                /* SER/MM/[C4] 0xE on */\
	out dx, ax;\
	mov dx, VGA_CRTC_ADR;\
	mov ax, 0x4014;                /* CRTC/UL/[DW] 0x40 on */\
	out dx, ax;\
	mov ax, 0xA317;                /* CRTC/MC/[W/B] off */\
        out dx, ax;}

#define _screenOff() \
        {asm mov dx, VGA_SER_ADR;asm mov al,_SER_CM_REG;asm out dx, al;\
        asm inc dx;asm in al, dx;\
        asm or al,_SER_CM_SO;asm out dx, al;}

#define _screenOn() \
        {asm mov dx, VGA_SER_ADR;asm mov al,_SER_CM_REG;asm out dx, al;\
        asm inc dx;asm in al, dx;\
        asm and al,NOT _SER_CM_SO;asm out dx, al;}

#define _setRotate(val) \
        {asm mov dx, VGA_GADR; asm mov al, _GCD_ROTATE; asm out dx, al;\
        asm inc dx; _AL = val; asm out dx, al;}

#define _setColorCompare(val) \
        {asm mov dx, VGA_GADR; asm mov al, _GCD_CCOMPARE; asm out dx, al;\
        asm inc dx; _AL = val; asm out dx, al;}

#define _setColorDontCare(val) \
        {asm mov dx, VGA_GADR; asm mov al, _GCD_DONTCARE; asm out dx, al;\
        asm inc dx; _AL = val; asm out dx, al;}

#define _selectMap(val) \
        {asm mov dx, VGA_GADR; _AH=val;_AL=_GCD_MAPSEL;asm out dx, ax;}
/*#define _selectMap(val) \
{asm mov dx, VGA_GADR; asm mov al, _GCD_MAPSEL; asm out dx, al;\
asm inc dx; _AL = val; asm out dx, al;}*/
#define _A_selectMap() {asm mov dx, VGA_GADR; asm mov al, _GCD_MAPSEL;asm out dx, al;}
#define _D_selectMap(val) {asm mov dx, VGA_GCD; _AL=val; asm out dx, al;}

#define _enableSetRes(val) \
        {asm mov dx, VGA_GADR;\
        _AH = val;\
        asm mov al, _GCD_ENSET;\
        asm out dx, ax;}

#define _SetRes(val) \
        {asm mov dx, VGA_GADR;\
        _AH = val;\
        asm mov al, _GCD_SETRES;\
        asm out dx, ax;}

#define _setMapMask(mask) \
        {asm mov dx, VGA_SER_ADR;\
        _AH = mask;\
        asm mov al, _SER_MAPMASK;\
        asm out dx, ax;}
#define _A_setMapMask() {asm mov dx, VGA_SER_ADR; asm mov al, _SER_MAPMASK; asm out dx, al;}
#define _D_setMapMask(mask) {asm mov dx, VGA_SER_GATE; _AL=mask; asm out dx, al;}

#define _setBitMask(mask) \
        {asm mov dx, VGA_GADR;\
        _AH = mask;\
        asm mov al, _GCD_BITMASK;\
        asm out dx, ax;}

#define _A_setBitMask() {asm mov dx, VGA_GADR; asm mov al, _GCD_BITMASK; asm out dx, al;}
#define _D_setBitMask(mask) sk) {asm mov dx, VGA_GCD; _AL=mask; asm out dx, al;}

#define _setWriteMode(mode) \
        {asm mov dx, VGA_GADR;asm mov al, _GCD_MODES;asm out dx, al;\
        asm inc dx;asm in al, dx;\
        asm and al, 0xFC;asm or al, WRITEMODE##mode;asm out dx, al;}

#define _setReadMode(mode) \
        {asm mov dx, VGA_GADR;asm mov al, _GCD_MODES;asm out dx, al;\
        asm inc dx;asm in al, dx;\
        asm and al, 0xF7;asm or al, READMODE##mode;asm out dx, al;}

/*#define _setWriteMode(mode) \
        {asm mov dx, VGA_GADR;\
        asm mov ax, _GCD_MODES OR ((WRITEMODE##mode OR _DefaultRMode) SHL 8);\
        asm out dx, ax;}
#define _setReadMode(mode) \
        {asm mov dx, VGA_GADR;\
        asm mov ax, _GCD_MODES OR ((READMODE##mode OR _DefaultWMode) SHL 8);\
        asm out dx, ax;}*/

#define _setRWModes(rmode,wmode) \
        {asm mov dx, VGA_GADR;\
        asm mov ax, _GCD_MODES OR ((READMODE##rmode OR WRITEMODE##wmode) SHL 8);\
        asm out dx, ax;}

#define _waitRetrace() \
        {asm mov dx, VGA_IS1;do {asm in al, dx; } while ((_AL & VGA_RETRACE) == 0);}
#define _waitStartVRetrace() \
        {asm mov dx, VGA_IS1;do {asm in al, dx; } while ((_AL & VGA_VRETRACE) == 0);}
#define _waitEndVRetrace() \
        {asm mov dx, VGA_IS1;do {asm in al, dx; } while (_AL & VGA_VRETRACE);}

#if defined(VGA_DUALMODE) || defined(VGA_UNCHAINED)
#       define _setPage(pseg) {\
        Sadapter.vpage=(pseg==VGA_SEG0)?0:((pseg==VGA_SEG1_UNCHAINED)?\
        1:((pseg==VGA_SEG2_UNCHAINED)?2:3));\
        Scshow_seg = pseg;\
        _BX = (pseg - VGA_SEG0)<<4;\
        _waitEndVRetrace();\
        asm pushf;asm cli;\
        _waitStartVRetrace();\
        asm mov dx, VGA_CRTC_ADR; \
        asm mov al, _CRT_STARTAD_LOW; asm mov ah, bl;asm out dx, ax;\
        asm mov al, _CRT_STARTAD_HIGH;asm mov ah, bh;asm out dx, ax;\
        asm popf;}
#else
#       define _setPage(pseg)
#endif

#define _outPage(pseg) \
        Scdraw_seg=pseg;\
        Sadapter.vpage=(pseg==VGA_SEG0)?0:\
        ((pseg==VGA_SEG1_UNCHAINED)?1:((pseg==VGA_SEG2_UNCHAINED)?2:3));

#else  __TURBOC__
#endif __TURBOC__

extern unsigned int Scdraw_seg, Scshow_seg, Scsec_seg, Scsave_seg;
extern int Scsignal;
extern int Scmode;

#define SCSIGNAL Scsignal--
#define SCWAIT   ++Scsignal
#define SClocked() (Scsignal != 0)
/* GLOCK 뢠   ६ 砥 ஥ 祭 */
#define SCLOCK(n) {\
asm mov ax, 1;\
asm xchg ax, Scsignal;\
n = _AX;\
if (_AX != 0) {\
        Scsignal = _AX;\
        Scsignal++;\
}}

#endif _VGADRV_H_