/*
From: george@moocow.UUCP (George Tirebiter)
Newsgroups: alt.bbs.waffle
Subject: Listing utility (privlist.c)
Date: Thu, 24 Jan 91 23:03:36 EST
Organization: Brown Cow Software

  Attached to this message is a copy of privlist.c, a utility that will
  run through a Waffle BBS password file and list all users that match
  a specified privilege.  For example,

privlist /waffle/admin/password 9

  ..will search for all Sysops.  The point of this utility is system
  security.  As far as I know, Mr. Dell has not changed the wiring and
  this utility should work fine with all versions of Waffle and password
  files through 1.64.  Please consider privlist public domain, but of course
  I would be curious about any changes made. :-)

  privlist.c will compile under MSDOS with Turbo-C 2.0 and has not been
  tested with Microsoft C or under Unix.  Anybody who wishes to modify it
  and re-post a more compatible version of the source is more than welcome
  to do so.  Problems, comments, requests, or complaints should be mailed
  to "george@moocow.uucp" or "uunet!nstar!syscon!moocow!george".

  More utilities to come.  Stay tuned.  Kudos to Dr. Math.

..George Tirebiter, American.
*/

/* - - - - - - - - - - cut here or don't cut here - - - - - - - - - - */

/*
 *  P R I V  L I S T			(privlist.c)
 *
 *  Displays all users with the specified privilege.
 *  Replies to uunet!nstar!syscon!moocow!george (G. Tirebiter)
 *
 */

#include <stdio.h>

#define FIELDS		24
#define LENGTH		256L
#define SIZE		80

main (int argc, char *argv[])
  {
  FILE *fp;
  int i;
  char buf [BUFSIZ], username [SIZE];
  long num;

  if (argc != 3)
    {
    printf ("Usage: privlist <password-file> <priv>\n\n");
    printf ("PRIVLIST will generate a list of all accounts with the "
            "specified priv.\nexample: privlist password 9  shows all "
	    "users with Sysop privileges.");
    exit (1);
    }

  if (( fp = fopen (argv[1], "r")) == NULL)
    {
    printf ("privlist: Can't open %s\n", argv[1]);
    exit (2);
    }

  for (num = 1 ;; num++)
    {
    fseek (fp, num * LENGTH, 0);	/* seek to user number * offset */

    if (fgets (username, SIZE, fp))
      {
      for (i = 0; i <= FIELDS; i++)
	{
	if (fgets (buf, BUFSIZ, fp))
	  {
	  if (i == 10 && atoi(buf) == atoi(argv[2]))
	    printf ("(%d) %s", atoi(argv[2]), username);

	  /* field 10 in /waffle/admin/password is the priv field */
	  }
	}
      }
    else
      break;
    }
  fclose (fp);
  }
