/*===========================================================================
SOLAR v0.95.3 solar :: Module ..\solar\extern.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This source code has been placed into the public domain.
===========================================================================*/

#include <stdio.h>
#include <dir.h>
#include <string.h>
#include <process.h>
#include "extern.h"

/*
 * Function: int extern_halt()
 * Purpose : Write extern file with blank command. This is used to exit
 *           Solar when it is used from within Waffle.
 * Return  : Zero on success, non-zero on error.
*/

int extern_halt()
{
  char extern_name[MAXPATH];
  FILE *extern_file = NULL;

  strcpy(extern_name, extern_path);
  strcat(extern_name, "\\");
  strcat(extern_name, EXTERN_NAME);

  if ((extern_file = fopen(extern_name,"wt")) == NULL)
  {
    sprintf(_slrerr,"extern_halt(): Cannot initialize %s",extern_name);
    goto ErrorExit;
  }

  fprintf(extern_file,"/command=\"\"\n");
  fclose(extern_file);

  if (verbose == YES)
    RPrintf("Extern file \"%s\" set to /command=\"\"\n",EXTERN_NAME);

GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int extern_solar()
 * Purpose : Write extern file to restart Solar.
 * Return  : Zero on success, non-zero on error.
*/

int extern_solar()
{
  char extern_name[MAXPATH];
  FILE *extern_file = NULL;

  strcpy(extern_name, extern_path);
  strcat(extern_name, "\\");
  strcat(extern_name, EXTERN_NAME);

  if ((extern_file = fopen(extern_name,"wt")) == NULL)
  {
    sprintf(_slrerr,"extern_halt(): Cannot initialize %s",extern_name);
    goto ErrorExit;
  }

  fprintf(extern_file,"/command=\"\" /then=%s\n",extern_root);
  fclose(extern_file);

  if (verbose == YES)
    RPrintf("Extern file \"%s\" set to /command=\"\" /then=%s\n",EXTERN_NAME,extern_root);

GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int extern_clear()
 * Purpose : Remove extern file.
 * Return  : Zero on success, non-zero on error.
*/

int extern_clear()
{
  char extern_name[MAXPATH];

  strcpy(extern_name, extern_path);
  strcat(extern_name, "\\");
  strcat(extern_name, EXTERN_NAME);

  return unlink(extern_name);
}

/*
 * Function: int extern_slrxfer(char *username, const char *argument)
 * Purpose : Write non-FOSSIL extern file for slrxfer.
 * Return  : 0 on success, non-zero on error.
*/

int extern_slrxfer(char *username, const char *argument)
{
  char extern_name[MAXPATH];
  char command_line[128];
  FILE *extern_file = NULL;

  strcpy(extern_name, extern_path);
  strcat(extern_name, "\\");
  strcat(extern_name, EXTERN_NAME);

  sprintf(command_line,"%s\\slrxfer -u %s %s",solar_path,username,argument);
  if (use_fossil == YES)
    strcat(command_line," -f");
	if (verbose == YES)
    strcat(command_line," -v");

  if ((extern_file = fopen(extern_name,"wt")) == NULL)
  {
    sprintf(_slrerr,"extern_slrxfer(): Cannot initialize extern file.");
    goto ErrorExit;
  }

  if (stricmp(argument,"-s") == 0)
  {
    fprintf(extern_file,"/local /command=\"%s\" /reset /then=%s\n",command_line,extern_root);
  }
  else
  {
    fprintf(extern_file,"/local /command=\"%s\" /reset /then=slrreply\n",command_line);
  }
  fclose(extern_file);

GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int call_solar(char *username, const char program)
 * Purpose : Call Solar program.
 * Return  : 0 on success, 1 on usage, 2 on fatal.
*/

int call_solar(char *username, const char *program, const char *specarg)
{
	char program_path[MAXPATH];
  char program_name[MAXPATH];
	char arguments[128];

	strcpy(program_name, program);

	strcpy(program_path, solar_path);
	strcat(program_path, "\\");
	strcat(program_path, program);

  strcpy(arguments,"-u ");
  strcat(arguments,username);

  if (use_fossil == YES)
		strcat(arguments," -f");
	if (verbose == YES)
		strcat(arguments," -v");
  strcat(arguments," ");
  strcat(arguments,specarg);

	if (verbose == YES)
    RPrintf("Calling %s %s...\n",program_path,arguments);

  if (diskswap == YES)
  {
    if (verbose == YES)
      RPrintf("Initializing swap to %s\n",swap_path);
    init_SPAWNO(swap_path,SWAP_DISK);
  }

  return(spawnl(P_WAIT,program_path,program_name,arguments,NULL));
}

