@ECHO OFF
rem First, test to see if logged onto drive/subdirectory where files are.
if not exist WPBKLT25.EXE goto Baddir
if not exist ANSWER.COM goto Baddir

rem -------- D E F A U L T   S E T T I N G S  A R E A ----------

rem To change the initial default settings for this installation 
rem procedure edit the lines below.  For example, to change the 
rem subdirectory holding your WordPerfect program, edit the line 
rem below which begins "SET WPDIR=".  You would change ONLY the 
rem information to the right of the "=" character.  DO NOT PLACE 
rem A "\" AT THE END OF ANY OF THESE ENTRIES!!!

rem Feel free to use WordPerfect to make these changes but make 
rem certain you save the altered file as DOS TEXT.  To do so press 
rem Ctrl-F5 (Text In/Out), "T" or "1" for DOS Text, "S" or "1" for 
rem Save.

rem Where the files are now
SET NOW=A:

rem Hard Drive (for WordPerfect)
SET WPDRive=C:

rem WordPerfect Subdirectory
SET WPDIR=\WP51

rem Name of Executable WordPerfect File
SET WPName=WP

rem Hard Drive (for your WordPerfect macros)
SET WPMDrive=C:

rem Subdirectory holding WordPerfect macros
SET WPMacDir=\WP51\MACROS

rem Let me take a moment here to thank Francis L. Schweiger for 
rem allowing me to use his program ANSWER.COM in this project.  
rem He has granted special permission to me for use in this 
rem project.

rem  \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
rem   There should be NO need to edit ANYTHING below this line!!!
rem  \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

:TOP
SET VerA=2.5
SET VerB=25
SET Eovl=xxxxxxxxxxxxxxxxxxxxxxxxx
CLS
echo 
echo Automated installation for the WP Booklet System %VerA%.
echo.
echo The WP Booklet System is copyright 1992-94 by:
echo    Alex D. Ogden
echo    601 North 18th Street
echo    Blytheville, AR  72315
echo.
echo This file will install WP Booklet in its own subdirectory
echo (\WPBKLT%VerB%), then execute WordPerfect and run the macro
echo SETPATH which is designed to tell WP Booklet where its files 
echo are located.  The following parameters will be used throughout 
echo this installation process unless you choose the custom 
echo installation option below:
echo.
echo         Where the files are now: %NOW%
echo Path to your WordPerfect macros: %WPMDrive%%WPMacDir%
echo     Path & name for WordPerfect: %WPDRive%%WPDIR%\%WPName%
echo.
echo If any of this information is not correct, answer YES to 
echo perform a Custom Installation.
echo 
echo.
answer Do you need to perform a Custom Installation (Y or N)? 
if errorlevel 8 goto EnvCorr
if errorlevel 2 goto NoSpace
if errorlevel 1 goto InvDOS
if errorlevel 0 goto Succ

:EnvCorr
echo.
echo Environment Area Corrupted!
echo.
goto end

:NoSpace
echo.
Echo Insufficient Space in Environment!
echo.
echo To be able to use this installation process you must make 
echo additional space available in your environment or install
echo the files manually following the instructions in READ.ME.
echo.
goto end

:InvDOS
echo.
Echo Invalid DOS version (2.00)
echo.

:Succ
set Eovl=
if %ANSWER%! == Y! goto Cust
if %ANSWER%! == YES! goto Cust
if %ANSWER%! == N! goto Doit
if %ANSWER%! == NO! goto Doit
echo.
echo You must answer either YES or NO to the question!
echo.
pause
goto Top

:Cust
cls
echo Answer the questions below to perform a custom installation.  Press 
echo ENTER to accept the default setting for a particular parameter.  Use 
echo the default setting as a guide when entering your information.  DO NOT
echo PLACE A "\" AT THE END OF ANY OF THESE ENTRIES!!!

:Q1
echo.
answer Where are the un-installed files now (%NOW%)? 
if %ANSWER%!==! goto Q1b
SET NOW=%ANSWER%
echo     Parameter changed to "%NOW%"
goto Q2
:Q1b
echo     Default accepted.

:Q2
echo.
answer Drive where WordPerfect is located (%WPDRive%)? 
if %ANSWER%!==! goto Q2b
SET WPDRive=%ANSWER%
echo     Parameter changed to "%WPDRive%"
goto Q3
:Q2b
echo     Default accepted.

:Q3
echo.
answer Subdirectory where WordPerfect is located (%WPDIR%)? 
if %ANSWER%!==! goto Q3b
SET WPDIR=%ANSWER%
echo     Parameter changed to "%WPDIR%"
goto Q4
:Q3b
echo     Default accepted.

:Q4
echo.
answer Name of your executable WordPerfect file (%WPName%)? 
if %ANSWER%!==! goto Q4b
SET WPName=%ANSWER%
echo     Parameter changed to "%WPName%"
goto Q5
:Q4b
echo     Default accepted.

:Q5
echo.
answer Drive for your WordPerfect macros (%WPMDrive%)? 
if %ANSWER%!==! goto Q5b
SET WPMDrive=%ANSWER%
echo     Parameter changed to "%WPMDrive%"
goto Q6
:Q5b
echo     Default accepted.

:Q6
echo.
answer Subdirectory for your WordPerfect macros (%WPMacDir%)? 
if %ANSWER%!==! goto Q6b
SET WPMacDir=%ANSWER%
echo     Parameter changed to "%WPMacDir%"
goto Confirm
:Q6b
echo     Default accepted.

:Confirm
echo.
ANSWER Do you need to start over (Y or N)? 
if %ANSWER%! == Y! goto Cust
if %ANSWER%! == YES! goto Cust
if %ANSWER%! == N! goto Doit
if %ANSWER%! == NO! goto Doit

:Doit
cls
echo 
echo Copying files from %NOW% to %WPMDrive%%WPMacDir%\WPBKLT%VerB%...
echo.
echo These are the macros and other files making up the WP Booklet
echo System.  They absolutely MUST NOT be deleted for WP Booklet to
echo operate.
echo 
%WPMDrive%
cd %WPMDrive%%WPMacDir%
md WPBKLT%VerB% >NUL
%NOW%\wpbklt%VerB% -o %WPMDrive%%WPMacDir%\WPBKLT%VerB%
echo 
pause
cls
echo 
echo The following are general information files.
echo.
echo They may be deleted if necessary without affecting the operation
echo of WP Booklet.
echo 
echo.
echo VENDOR.DOC
copy %NOW%\VENDOR.DOC %WPMDrive%%WPMacDir%\WPBKLT%VerB%
echo.
echo PRODUCTS.DOC
copy %NOW%\PRODUCTS.DOC %WPMDrive%%WPMacDir%\WPBKLT%VerB%
echo.
echo VENDINFO.DIZ
copy %NOW%\VENDINFO.DIZ %WPMDrive%%WPMacDir%\WPBKLT%VerB%
echo.
echo READ_ME.BAT
copy %NOW%\READ_ME.BAT %WPMDrive%%WPMacDir%\WPBKLT%VerB%
echo.
echo WHATS.NEW
copy %NOW%\WHATS.NEW %WPMDrive%%WPMacDir%\WPBKLT%VerB%
echo.

rem Now go and run WordPerfect with SETPATH macro
rem
rem First set path to WP macros in environment variable
SET ALEX=%WPMDrive%%WPMacDir%\
cd\
%WPDRive%
%WPDRive%%WPDIR%\%WPName%/m-%ALEX%WPBKLT%VerB%\setpath
cd\
cls

echo 
echo    This concludes installation for the WP Booklet System %VerA%
echo 
echo.
goto END

:Baddir
cls
ECHO For the installation procedure for the WP Booklet System to work
ECHO properly, you must start this batch file by logging on to the drive
ECHO and directory where the files are currently located.

:END
REM Clear all variables used...
SET NOW=
SET WPDRive=
SET WPDIR=
SET WPName=
SET WPMDrive=
SET WPMacDir=
SET ALEX=
SET VerA=
SET VerB=
SET ANSWER=
SET Eovl=