DISPLAY OFF
# Ŀ
#       Welcome to the XA Command Interpreter Demo Program V.3.2     
#    Copyright 19911996 by Bruce Christensen. All Rights Reserved.  
# 

# W A R N I N G:
# ========================================
# Please don't alter this file. 

DECLARE var key_input
dos cls
DISPLAY ON









#   Ŀ
#          XA is copyrighted 1991-1996 by Bruce Christensen       
#          and AutoMagic Technologies. All Rights Reserved.       
#   







#          Ŀ
#    Press F1 for Color monitors, or
#          
#          Ŀ
#    Press F2 for Black & White or monochrome monitors...
#          

DISPLAY OFF
# INKEYW will wait for the user to press a key
key_input = inkeyw
if (key_input == F2KEY)
  define HIGHLIGHT WHITE BLACK
  define TEXT LIGHTGRAY BLACK
  define EXAMPLE WHITE BLACK
else
  define HIGHLIGHT WHITE BLUE
  define TEXT LIGHTGRAY BLUE
  define EXAMPLE YELLOW BLUE
endif




dos cls
DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON












#                        Welcome to the XA demo!
#                        
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# This quick tour will highlight many of the features of XA.  To get
# the most power from XA, please read the User's Guide (XA_320.TXT). 

DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Features of XA Version 3.2
# 
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#   * Sends DIRECT (immediate) and EVENT (scheduled) X10 commands via 
#       DOS prompt, batch file, or command file.
#   * User configurable - Works with any COM port (interrupt or polled mode).
#   * Automatic and complete CP-290 schedule maintenance.
#   * Sunrise and Sunset calculations, automatic DST adjustments.
#   * Supports (3) undocumented CP-290 commands, including BRIGHTEN
#       which can used to create an artificial sunrise effect.
#   * Synchronization of the CP-290 or PC onboard clocks.
#   * Program an event to occur on any DATE in the future.
#   * Repeat events every 'n' days (great for sprinkler systems).
#   * PowerFail Recovery, restores modules to programmed state.
#   * Interface to external conditions via Joystick or LPT ports.
#   * Monitoring and logging CP-290 activity.
#   * Powerful programming language (IF/ELSE, variables, logic operations,
#       GOTO, GOSUB/RETURN, INPORT/OUTPORT)
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause

DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON









# What is XA?
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# XA is a command interpreter for the CP-290, X10's Computer Interface.
# The XA interpreter translates English-like sentences into commands that
# are understood by the CP-290.  XA parses commands from a variety of inputs.
# XA can read commands from the DOS prompt.  The following example turns
# on an X10 module whose address is set at House A Unit 9:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#       C:\> XA "A9 ON"
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

#  You can embed X10 commands within batch files too:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON

#       PHONE.BAT:
#            XA "A9 ON"
#            CALL PRODIGY
#            XA "A9 OFF"
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

#  X10 commands entered from the DOS prompt or batch file must be enclosed in
#  "quotation marks".  Multiple X10 commands may be entered, they must be
#  separated by "quotations" too.

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#       C:\> XA "A9 ON" "A10 OFF" "C3 DIM 50"
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause











DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Command Files
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# Another input for X10 statements is the command file (*.CMD).  This file
# can hold an unlimited number of commands that are executed sequentially
# by XA.  For instance, you can create a "script" of X10 commands to control
# Christmas lights.  You tell XA which file to read as follows:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#       C:\> XA F=XMAS.CMD
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# 
# where XMAS.CMD contains the following commands:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#            A1 DIM 
DISPLAY OFF DELAY 0:0:1 DISPLAY ON
#            A2 BRIGHT 
DISPLAY OFF DELAY 0:0:1 DISPLAY ON
#            A3 OFF
DISPLAY OFF DELAY 0:0:1 DISPLAY ON
#            A4 ON
DISPLAY OFF DELAY 0:0:1 DISPLAY ON
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# XA offers many special commands that allow you to create very sophisticated
# script files.  Some of these commands include:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#            IF/ELSE/ENDIF, GOTO, GOSUB/RETURN, 
#                  PAUSE, DELAY secs, TIMER secs,  ...plus many others. 

DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# See the User's Manual for complete details.
pause





DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Event Scheduling
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON



# While XA is great for sending immediate commands to your CP-290, XA really
# excels at scheduling and maintaining events. Events are X10 commands stored
# in the CP-290's memory and activated at some future time.  As with direct
# commands, events may be programmed from the DOS prompt:


DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#     C:\> XA "A9 ON 8:00 PM WEEKDAYS"
DISPLAY OFF VIDEO8 TEXT DISPLAY ON


# Event statements are usually stored in command files.  A command file may 
# contain your entire X10 event schedule.  You can have XA download your 
# complete schedule for you automatically.  If you control your personal
# computer with an X10 Appliance Module, then you can have XA perform 
# automatic event downloads on a weekly basis.  See the section entitled
# "POWERUP Utility" in the User's Guide for complete details.


pause












#The following is an example of an X10 event file called XA.CMD:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#       C:\> XA F=XA.CMD

#               :
#           PORCH_LIGHTS ON SUNSET EVERYDAY
#           PORCH_LIGHTS OFF SUNRISE EVERYDAY
#           DECK_LIGHTS ON DUSK DATE 5/1 THRU 9/30 WEEKDAYS
#               :

DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# Notice how more descriptive names may be substituted for module 
# house and unit codes.  PORCH_LIGHTS have been "DEFINED" (or substituted) 
# for the module address House A Unit 9.  
  
# XA supports dynamic instances such as sunrise and sunset.  These times 
# are calculated based on your latitude and longitude.  
  
# XA is also capable of evaluating dates and storing an event when the 
# statement meets the proper criteria. XA allows you to program an event 
# weeks, months, or years into the future.


pause










DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Configurable Communications
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON


# XA supports COM1 through COM4 using either interrupt-driven (preferred mode)
# or polled communications.  A utility program called FINDX10 is included which
# will analyze your installed COM ports and search for the CP-290.  


# IMPORTANT NOTE:  FINDX10 only works in a true DOS environment. 
#                  FINDX10 may not be able to locate the CP-290 if you are
#                  currently running WINDOWS. 








# 
# To run FINDX10...
pause





DOS FINDX10 !
#
# If the last message reads: 
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#         "Found CP-290 at COMx. Use IO xxx IRQ xxx" 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
#    then you're in luck. XA should work on your PC without any problems.
#    Note: You will be instructed to run FINDX10 later to setup XA's
#          initialization file (XA.INI).
#
# If the last message reads: 
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#           "Can not locate the CP-290..." 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
#    you may have problems running XA. Later on, try connecting the CP-290
#    to a different COM port and then run FINDX10 again. If you are running
#    Windows, you will need to exit Windows (press ALT-F4), then run 
#    FINDX10 again.
pause
DISPLAY OFF VIDEO8 TEXT DISPLAY ON











DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Initialization File (XA.INI)
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# In addition to using command files, XA also reads a file called XA.INI. This
# is an initialization file where you store XA statements that describe the 
# setup of your machine. For instance, the IO and IRQ tokens that FINDX10 
# suggested to you should be placed in this file. Here is a sample of other
# XA tokens that would normally appear in XA.INI:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#       DEFINE PORCH_LIGHTS A9 
#       DEFINE DECK_LIGHTS  A1

#       LATITUDE  4135'                   # Coordinates of
#       LONGITUDE 8120'                   # Mentor, Ohio
#       TIMEZONE 5 DST                     # used for Sunrise/sunset calcs

#       COM3                               # For "standard" COM configurations
#       IO 3E8H                            # For "special"...
#       IRQ 5                              # ... COM configurations

DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# A sample XA.INI is included with this software. You can modify it to suit 
# your configuration. Also, the User's Guide contains complete information
# about "tokens" and the initialization file. Please read it!
pause






DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Powerfail Recovery
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# XA can be used to restore all CP-290 controlled modules back to their 
# programmed state in the event of a power failure, or other circumstance. 
# The proper state is determined by examining the CP-290's event schedule. 


DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#   C:\> XA -p
 
DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON

#      Powerfail Recovery. Checking status...
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#      Restoring: PORCH_LIGHTS ON
#      Restoring: DECK_LIGHTS OFF
#      Ignoring : DEHUMIDIFIER
#      Forcing  : HALL_LIGHTS ON
DISPLAY OFF VIDEO8 TEXT DISPLAY ON


# XA allows selected modules (DEHUMIDIFIER) to be excluded from recovery,
# others (HALL_LIGHTS) can forced to a particular state no matter what XA 
# determines. 

pause






DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Special DATE handling
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# Events can be programmed to occur on specific dates or between a range of 
# dates. Events can also be excluded from occuring on specific (or range of) 
# dates. The following examples show how you can control lighting during 
# specific dates. 
  
# Turn on flagpole light on July 4:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#     FLAGPOLE ON SUNSET 7/4
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# Turn on flagpole on multiple holidays:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#     FLAGPOLE ON SUNSET 5/31 7/4 9/6
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# Turn on porch lights only during the winter season:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#     PORCH_LIGHTS ON 5:30 PM 11/1/95 THRU 3/31/96 WEEKDAYS
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# Turn on porch lights EXCEPT during certain holidays:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#     PORCH_LIGHTS ON SUNSET EXCEPT 5/31 7/4 9/6 WEEKDAYS
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# Turn on deck lights during summer EXCEPT during vacation:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#     DECK_LIGHTS ON SUNSET 4/1 THRU 9/30 EXCEPT 7/1 THRU 7/14
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause






DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Report Generation - Style #1
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# XA can produce report files (XA.RPT) of your X10 schedule in (2) special 
# formats. The first style lists events sorted by day and time:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
# Wednesday - January 01, 1997     Sunrise:  7:52:05      Sunset:  5:05:09           

#    Time      Cmd    Mode         Module Address/Description           Event 
#  --------    ---  --------       ----------------------------------   ------
#  12:30 am    OFF                 (A8) LIVING_ROOM_LAMP                ( 41) 
#  12:30 am    OFF                 (A4) FAMILY_ROOM_LAMP                ( 43) 
#   1:30 am    OFF                 (A3) BEDROOM_LIGHT                   ( 54) 
#   6:00 am    ON                  (B2) DEHUMIDIFIER                    ( 56)*
#   7:22 am    OFF                 (H1) STAIRS                          ( 63)*
#   7:22 am    OFF                 (H2) HALLWAY                         ( 63)*
#  12:00 pm    OFF                 (B2) DEHUMIDIFIER                    ( 57)*
#   4:05 pm    ON                  (A4) FAMILY_ROOM_LAMP                ( 51) 
#   4:56 pm    ON                  (B2) DEHUMIDIFIER                    ( 58)*
#   5:05 pm    DIM                 (A6) OUTSIDE_PORCH_LIGHTS            ( 48) 
#   5:06 pm    DIM                 (H1) STAIRS                          ( 61)*
#   5:06 pm    DIM                 (H2) HALLWAY                         ( 60)*
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause

DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Report Generation - Style #2
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# The second style lists events sorted by day, module, and time:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
# Wednesday - January 01, 1997     Sunrise:  7:52:05      Sunset:  5:05:09           

#  Module       Time  Function  Mode                                    Event 
#  ---------------------------------------------------------------------------

#  (A3) BEDROOM_LIGHT
#             1:30 am     OFF                                           ( 54) 
#            10:34 pm     ON                                            ( 53) 

#  (A4) FAMILY_ROOM_LAMP
#            12:30 am     OFF                                           ( 43) 
#             4:05 pm     ON                                            ( 51) 

#  (A6) OUTSIDE_PORCH_LIGHTS
#             5:05 pm     DIM                                           ( 48) 
#             5:22 pm     DIM                                           ( 70) 
#            10:40 pm     OFF                                           ( 55) 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause



DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Report Generation - Style #3
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# The third style lists events sorted by event number:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
# Wed - January 01, 1996              Sunrise:  7:52:05      Sunset:  5:04:47           
# Thu - January 02, 1996              Sunrise:  7:52:12      Sunset:  5:05:37           
#  :       :         :                   :                      :
# Mon - January 06, 1996              Sunrise:  7:52:18      Sunset:  5:09:11           
# Tue - January 07, 1996              Sunrise:  7:52:14      Sunset:  5:10:09           
#
# Event   Time   Cmd  Days     Mode   Module Address                          
# ----- -------- --- ------- -------- ----------------------------------------
#    0   4:04 pm ON   M               A 1             8                  15   
#    1   4:05 pm ON    T              A 1 2           8
#    2   4:06 pm ON     W             A 1 2 3 4 5 6 7 8
#    3   4:07 pm ON      T            A               8 9 10
#    4   4:08 pm ON       F           B     3
#    5   4:09 pm ON        S          B     3
#    6   4:10 pm ON  S                A 1             8                  15   
#    7  11:30 pm OFF SMTWT            C 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16
#    8  12:30 am OFF S     S          A               8                  15   
pause




DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Clock Synchronization
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# XA can keep the internal clocks of your PC and CP-290 accurate to within 
# 1 second of each other. You can set either clock based on the time 
# maintained by the other clock. 

# If your PC does not have on-board clock, you can set its time based on the
# time maintained by the CP-290. Simply put the following statement in your
# AUTOEXEC.BAT file:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#      XA "SYNCHRONIZE PC"        
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# To get both clocks accurate to within 1 second:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON

#      XA "SYNCHRONIZE PC EXACT"        
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

#  You can also set the CP-290 based on your PC's internal clock. 

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#      XA "SYNCHRONIZE X10"        
#      XA "SYNCHRONIZE X10 EXACT"        
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

pause









DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Monitoring and Logging CP-290 Activity
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON


# XA can monitor all activity reported by the CP-290. For instance, when
# the CP-290 triggers an scheduled event, or when one of the buttons on 
# the CP-290 console is pressed, XA captures the action and displays the
# activity on your screen.  XA can also log this information in a file
# if requested:


DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#  C:\> XA "MONITOR"

#  Monitor events. Press <ESC> when finished...

#     Sun Jan 01  2:16:02 1994 (D1...D16) ALL UNITS OFF
#     Sun Jan 01  3:00:02 1994 (C1) COMPUTER ON 
#     Sun Jan 01 16:02:02 1994 (A4) FAMILY_ROOM_LAMP ON
#     Sun Jan 01 16:02:05 1994 (A8) LIVING_ROOM_LAMP ON
#     Sun Jan 01 17:16:02 1994 (A9) PORCH ON
#     Sun Jan 01 18:00:02 1994 (C8) KATHRYNS_PC OFF
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

pause











DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Function Key Menus
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# XA can read Function Key (F1..F12, including extended functions) and
# invoke user-defined actions such as downloading an event file, monitoring
# CP-290 activity, controlling special lighting sequences, or executing
# DOS commands, or do just about anything else.

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#
#     Ŀ                            Ŀ
#      F1  Porch Lights On             F2  Porch Lights Off
#                                 
#     Ŀ                            Ŀ
#      F3  Security Lights On          F4  Security Lights Off
#                                 
#     Ŀ                            Ŀ
#      F5  Download XA.CMD             F6  CP-290 Diagnostics
#                                 
#     Ŀ                            Ŀ
#      F7  Monitor CP-290 Activity     F8  Powerfail Recovery
#                                 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

pause










DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Powerup Utility
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# A utility program called POWERUP.EXE is supplied with XA which assists 
# you in performing unattended, automatic, event downloads to the CP-290.
# As long as your PC is controlled by an Appliance Module, you can have
# the CP-290 boot your computer at some predetermined time (for instance,
# Sunday mornings @ 3:00 am). Your AUTOEXEC.BAT file can call POWERUP which
# determines if its the proper time to perform a schedule update.


# Here are the statements required in AUTOEXEC.BAT to perform automatic 
# schedule updates:


DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#        :
#   POWERUP d=SUN s=2:55 e=3:05 
#   if not errorlevel 1 goto skip
#   XA f=XA.CMD
#   XA "PC OFF"
#   :skip
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

pause




















DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON

# IF / ELSE / ENDIF 
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# These constructs allow you to alter the flow of execution within your 
# event command file or script file based on conditions you program.
# In addition, XA allows you to customize the color of the conditional 
# statements so you can easily tell how the statement was evaluated. 

# For instance, assuming today is Sunday, you can have XA test the CDAY 
# variable and if it's the WEEKEND have XA parse a special WEEKEND 
# event file. Note that the IF test is TRUE so it is hightlighted,
# the ELSE portion is FALSE, so it is displayed normally:


DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#      IF ((CDAY == SAT) OR (CDAY == SUN))
DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
#        XACMD WEEKEND.CMD
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
#      ELSE
#        XACMD WEEKDAY.CMD
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#      ENDIF

DISPLAY OFF VIDEO8 TEXT DISPLAY ON


pause  










DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON

# Input and Output from a Port
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# XA allows you to use your joystick port, LPT port, or any other port
# as a general purpose Input/Output port.  Connect switches and/or
# relays to these ports and program XA to react to real-world events.
# The following code appears in the included file JOYSTICK.CMD:
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON

#  :LOOP                                   # This is the beginning of the loop
#     GAME = INPORT 201H                   # Read the joystick port
#     IF !(GAME & 20H)                     # Check Button A
#       IF (MODULE == OFF)                 # If module is currently Off...
#         c2 on fast                       # ...Turn module C2 On
#         MODULE = ON                      # ...update status of module to On
#       ENDIF
#     ENDIF
#     IF !(GAME & 10H)                     # Check Button B
#       IF (MODULE == ON)                  # If module is currently On...
#         c2 off fast                      # ...Turn module C2 Off
#         MODULE = OFF                     # ...update its status too
#       ENDIF
#     ENDIF
#  GOTO LOOP                               # Loop until <ESC> pressed.
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause  






DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Other Features
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON


# Determine the programmed state of an individual X10 address.  Then take 
# appropriate action based on the status.


DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#      MODULE = A1 STATUS
#      IF (MODULE == ON)
#        A1 OFF
#      ELSE
#        A1 ON
#      ENDIF
DISPLAY OFF VIDEO8 TEXT DISPLAY ON


# Easily program a device (irrigation system) that needs to be controlled 
# every 'n' days.
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON

#      SPRINKLER ON SUNRISE EVERY 4 DAYS 6/1 THRU 9/30
#      SPRINKLER OFF SUNRISE + 30 EVERY 4 DAYS 6/1 THRU 9/30

DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause




DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Create an Artificial Sunrise
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON


#   The BRIGHTEN command invokes an undocmented feature of the CP-290.
#   With this command, you can brighten a LAMP MODULE module in very 
#   small steps without having the CP-290 ramp the module to 100% full
#   brightness as it normally does with the DIM command.
#
#   The ## value is an increment, not an absolute level.  If you issue
#   a "BRIGHTEN 1" command, the selected module will increase it brightness
#   level by 1 step.  A "BRIGHTEN 5" will brighten the module by 5 steps.
#
#
#   This effect is useful for creating an artificial sunrise.  During the
#   Winter months you can program a light in your bedroom to brighten
#   gradually in 16 steps over a period of time.  See next page...



pause


DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Create an Artificial Sunrise (contd)
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON



#  You can make use of XA's advanced programming constructs, such
#  as using a loop to program repeated events.  We'll use the DECLARE
#  token to create TIME variable that can be incrmented in the loop:


DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#       DECLARE TIME WAKEUP = 5:14       # Initialize variable to 5:14 am
#       :LOOP                             
#       B1 BRIGHTEN 1 WAKEUP WEEKDAYS    # Send event to CP-290
#       WAKEUP = WAKEUP + 1              # Increment time by 1 minute
#       IF (WAKEUP <= 5:30)              # Have we issued all events?
#         GOTO :LOOP                     #  - No, repeat the loop
#       ENDIF

DISPLAY OFF VIDEO8 TEXT DISPLAY ON
        

pause










  

DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# Please Register!
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON



# This is just a sample of what XA can do with your CP-290.  Please take
# the time to read the accompanying User's Guide to learn all of XA's
# capabilities.  



# XA is SHAREWARE. If you continue to use XA beyond the 45 trial period, 
# you need to register this package with the author. When you register 
# your copy of XA, you will be sent a floppy disk with the latest registered 
# version of XA along with an 82 page User's Guide. 



# All "nag" screens and registration reminders will be removed.



DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause














DISPLAY OFF VIDEO8 HIGHLIGHT DISPLAY ON
# More about Registration
# 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON

# You can order a registered copy RIGHT NOW with your 
DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
#       Discover, Visa, MasterCard, or American Express 
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
# credit card by calling Public software Library (PsL) toll-free.
# Refer to the enclosed file "REGISTER.TXT" for complete details.

# If you belong to CompuServe, you can order XA online through CServe's 
# shareware registration service (GO SWREG).  Refer to the enclosed file 
# "REGISTER.TXT" for complete details.

# Of course, you can also order with a personal check (or Money Order - 
# U.S. funds).  Fill out the enclosed order form (REGISTER.TXT) and mail
# it to the address listed in it.  

# Thank you for trying XA!  Send any correspondence to:

DISPLAY OFF VIDEO8 EXAMPLE DISPLAY ON
# Bruce Christensen         CompuServe    : 73201,1531
# 6594 Hudson Ave.          America OnLine: AuggieBen
# Mentor, OH. 44060-4545    Internet      : automagict@aol.com
#                           World Wide Web: http://members.aol.com/automagict/
DISPLAY OFF VIDEO8 TEXT DISPLAY ON
pause
