'RIFS.BAS
'Visual Basic 3.0 code written by
'Brian H. Marston
'webguy@fatdays.com
'http://www.fatdays.com/

Option Explicit

'Module-level variables
Dim Transforms() As Single
Dim mstrColoring As String

Sub PlotPoints (frmForm As Form)

   Dim Iterations As Long
   Dim iUpdateInterval As Integer
   Dim iShowElapsedTime As Integer
   Dim i As Long
   Dim RandNum As Integer
   Dim X, Y As Single
   Dim NewX, NewY As Single
   Dim Start, Final As Long
   Dim DialogMsg, DialogTitle As String

   'Fixed point of the first transformation
   X = (-Transforms(1, 5) * (Transforms(1, 4) - 1) + Transforms(1, 2) * Transforms(1, 6)) / ((Transforms(1, 1) - 1) * (Transforms(1, 4) - 1) - Transforms(1, 2) * Transforms(1, 3))
   Y = (-Transforms(1, 6) * (Transforms(1, 1) - 1) + Transforms(1, 3) * Transforms(1, 5)) / ((Transforms(1, 1) - 1) * (Transforms(1, 4) - 1) - Transforms(1, 2) * Transforms(1, 3))

   Iterations = CLng(iniGetString("Settings", "Iterations", "10000"))
   iUpdateInterval = iniGetInt("Settings", "UpdateInterval", 500)
   iShowElapsedTime = iniGetInt("Settings", "ShowElapsedTime", 1)

   Randomize

   Start = Timer

   For i = 1 To Iterations
      'Generate random number between 1 and number of transformations
      RandNum = Int(UBound(Transforms) * Rnd + 1)

      NewX = Transforms(RandNum, 1) * X + Transforms(RandNum, 2) * Y + Transforms(RandNum, 5)
      NewY = Transforms(RandNum, 3) * X + Transforms(RandNum, 4) * Y + Transforms(RandNum, 6)
         
      'Draw point
      If mstrColoring = "Black and White" Then
         frmForm.PSet (NewX, NewY), RGB(0, 0, 0)
      ElseIf mstrColoring = "By Transform" Then
         Select Case RandNum
         Case 1
            frmForm.PSet (NewX, NewY), RGB(255, 0, 0)
         Case 2
            frmForm.PSet (NewX, NewY), RGB(0, 255, 0)
         Case 3
            frmForm.PSet (NewX, NewY), RGB(0, 0, 255)
         Case 4
            frmForm.PSet (NewX, NewY), RGB(255, 255, 0)
         Case 5
            frmForm.PSet (NewX, NewY), RGB(255, 0, 255)
         Case Else
            'Remember to add more colors here if I use an IFS that has more than 5 transforms
            MsgBox "Add more colors in Sub PlotPoints"
         End Select
      ElseIf mstrColoring = "Blend" Then
         frmForm.PSet (NewX, NewY), RGB(Cos(NewX * PI / 2) * 255, 0, Sin(NewX * PI / 2) * 255)
      ElseIf mstrColoring = "Random" Then
         frmForm.PSet (NewX, NewY), RGB(Int(256 * Rnd), Int(256 * Rnd), Int(256 * Rnd))
      Else
         MsgBox "Unsupported Coloring Method"
      End If
      
      X = NewX
      Y = NewY

      'Refresh the form every <iUpdateInterval> iterations
      If i Mod iUpdateInterval = 0 Then
         frmForm.Refresh
      End If

   Next i

   Final = Timer

   Beep

   If (iShowElapsedTime = 1) And (Iterations <> 0) Then
      DialogMsg = "Drawing time = " & Format(Final - Start, "Standard") & " seconds"
      DialogTitle = "Elapsed Time"
      MsgBox DialogMsg, 0, DialogTitle
   End If

End Sub

Sub SetColoring (ColoringMethod As String)

   mstrColoring = ColoringMethod

End Sub

Sub SetTransforms (Attractor As String)

   Erase Transforms

   Select Case Attractor
      Case "Gasket"
         ReDim Transforms(1 To 3, 1 To 6)
         Transforms(1, 1) = .5
         Transforms(1, 2) = 0
         Transforms(1, 3) = 0
         Transforms(1, 4) = .5
         Transforms(1, 5) = 0
         Transforms(1, 6) = 0
            
         Transforms(2, 1) = .5
         Transforms(2, 2) = 0
         Transforms(2, 3) = 0
         Transforms(2, 4) = .5
         Transforms(2, 5) = .5
         Transforms(2, 6) = 0
            
         Transforms(3, 1) = .5
         Transforms(3, 2) = 0
         Transforms(3, 3) = 0
         Transforms(3, 4) = .5
         Transforms(3, 5) = .25
         Transforms(3, 6) = Sqr(3) / 4
      Case "Leaf"
         ReDim Transforms(1 To 2, 1 To 6)
         Transforms(1, 1) = .44
         Transforms(1, 2) = -.3733
         Transforms(1, 3) = .06
         Transforms(1, 4) = .61
         Transforms(1, 5) = .3533
         Transforms(1, 6) = -.01
            
         Transforms(2, 1) = -.82
         Transforms(2, 2) = -.1867
         Transforms(2, 3) = .1371
         Transforms(2, 4) = .81
         Transforms(2, 5) = 1.1
         Transforms(2, 6) = .11
      Case "Fern"
         ReDim Transforms(1 To 4, 1 To 6)
         Transforms(1, 1) = .849
         Transforms(1, 2) = .037
         Transforms(1, 3) = -.037
         Transforms(1, 4) = .849
         Transforms(1, 5) = .075
         Transforms(1, 6) = .183
            
         Transforms(2, 1) = .197
         Transforms(2, 2) = -.226
         Transforms(2, 3) = .226
         Transforms(2, 4) = .197
         Transforms(2, 5) = .4
         Transforms(2, 6) = .049
            
         Transforms(3, 1) = -.15
         Transforms(3, 2) = .283
         Transforms(3, 3) = .26
         Transforms(3, 4) = .237
         Transforms(3, 5) = .575
         Transforms(3, 6) = -.084

         Transforms(4, 1) = 0
         Transforms(4, 2) = 0
         Transforms(4, 3) = 0
         Transforms(4, 4) = .16
         Transforms(4, 5) = .5
         Transforms(4, 6) = 0
      Case "Crystal"
         ReDim Transforms(1 To 5, 1 To 6)
         Transforms(1, 1) = .382
         Transforms(1, 2) = 0
         Transforms(1, 3) = 0
         Transforms(1, 4) = .382
         Transforms(1, 5) = .3072
         Transforms(1, 6) = .619
            
         Transforms(2, 1) = .382
         Transforms(2, 2) = 0
         Transforms(2, 3) = 0
         Transforms(2, 4) = .382
         Transforms(2, 5) = .6033
         Transforms(2, 6) = .4044
            
         Transforms(3, 1) = .382
         Transforms(3, 2) = 0
         Transforms(3, 3) = 0
         Transforms(3, 4) = .382
         Transforms(3, 5) = .0139
         Transforms(3, 6) = .4044

         Transforms(4, 1) = .382
         Transforms(4, 2) = 0
         Transforms(4, 3) = 0
         Transforms(4, 4) = .382
         Transforms(4, 5) = .1253
         Transforms(4, 6) = .0595
         
         Transforms(5, 1) = .382
         Transforms(5, 2) = 0
         Transforms(5, 3) = 0
         Transforms(5, 4) = .382
         Transforms(5, 5) = .492
         Transforms(5, 6) = .0595
         
   End Select

End Sub

