/***********************************************************************

                       CSA Library, Free Evaluation Version 2.0.5 
                                       Release: January 22th 1997 

       A wrapper class to hide file name uglyness.

                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSFILE_H
#define __CSFILE_H

#include "stdio.h"
#include "csstr.h"


#ifdef _CP_030
   // Unix
   #include "sys/stat.h"
   #include "dirent.h"
#endif

#ifdef _CP_004
   #include "sys\types.h"
   #include "sys\stat.h"
   #include "direct.h"
   #include "dos.h"
#endif



#ifdef _CP_030
// Unix
  #define DIRSLASH '/'
#else
// Dos, OS2
  #define DIRSLASH '\\'
#endif


////////////////// Bit masks for pFnsplit /////////////////////////////


#define CS_WILDCARDS 0x01
#define CS_EXTENSION 0x02
#define CS_FILENAME  0x04
#define CS_DIRECTORY 0x08
#define CS_DRIVE     0x10


/////////////////////// Portability stuff //////////////////////////////

#ifdef _CP_001
#include "dir.h"
#include "dos.h"
#endif

#if (defined(_CP_002a) || defined(_CP_002c))
#include "direct.h"
#include "dos.h"
#endif

#ifdef _CP_002b
#include "direct.h"
#include "io.h"
#endif


#ifdef _CP_003
#include "limits.h"
#include "unistd.h"
#endif


#ifdef _CP_030
/////////////////////// UNIX ///////////////////////////////////////////

#ifdef NAME_MAX
#define MAXFILE NAME_MAX
#else
#define MAXFILE  256
#endif

#ifdef PATH_MAX
#define MAXPATH PATH_MAX
#else
#define MAXPATH  1024
#endif

#ifndef MAXEXT
#define MAXEXT MAXFILE
#endif

#define MAXDIR  (MAXPATH-MAXFILE-1)

#endif



#if (defined( _CP_010) || defined(_CP_021))
///////////////////// DOS & Win16 ///////////////////////////////////

#ifndef MAXPATH
#define MAXPATH   80
#endif
#ifndef MAXDIR
#define MAXDIR    66
#endif
#ifndef MAXFILE
#define MAXFILE   9
#endif

#endif





#ifdef _CP_022
/////////////////////// Win32 /////////////////////////////////////////

#ifndef MAXFILE
#ifdef  NAME_MAX
#define MAXFILE NAME_MAX
#else
#define MAXFILE  256
#endif
#endif

#ifndef MAXPATH
#ifdef PATH_MAX
#define MAXPATH PATH_MAX
#else
#define MAXPATH MAXFILE
#endif
#endif

#ifndef MAXEXT
#define MAXEXT  MAXFILE
#endif

#ifndef MAXDIR
#define MAXDIR  MAXPATH
#endif

#endif







#ifdef _CP_040
/////////////////////// OS2 ///////////////////////////////////////////

#ifndef MAXFILE
#ifdef NAME_MAX
#define MAXFILE NAME_MAX
#else
#define MAXFILE  256
#endif
#endif

#ifndef MAXPATH
#ifdef PATH_MAX
#define MAXPATH PATH_MAX
#else
#define MAXPATH  MAXFILE
#endif
#endif

#ifndef MAXEXT
#define MAXEXT MAXFILE
#endif

#ifndef MAXDIR
#define MAXDIR  MAXPATH
#endif

#endif



//////////////////// Extension & Drive /////////////////////////////

#ifndef MAXEXT
#define MAXEXT    5
#endif

#ifndef MAXDRIVE
#define MAXDRIVE  3
#endif


////////////////////////////////////////////////////////////////////////
//////////////////////// Class FILE_NAME ///////////////////////////////
////////////////////////////////////////////////////////////////////////

class FILE_NAME
{

private:
  csSTR fn;      // user input UNCHANGED
  csSTR direc;   // default path  ( including DRIVE, if any)
  csSTR exten;

protected:
  void combine(void);

////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////


public:

  void set_dir(csCHAR *s);
  csCHAR *ori_dir(void)       { return ((csCHAR *)direc); }
  void set_name_only(csCHAR *s)  { fn=s;  }
  void set_name(csCHAR *s);
  int  exist(void)            { return file_exist(name_dpfe()); }
  int  file_delete(void)      { return remove(name_dpfe()); }
  csCHAR *name(void)          { return ((csCHAR *)fn); }


///////////////////////////////////////////////////////////////////////
// Everything after the last dot in the file name is considered
// to be the extension.
//
// The extension keeps the leading dot attached.
// The Path keeps the leading and trailing slash.
// The drive designator keeps the trailing colon.

/* Example:  c:\subdir\dir\filename.ext
           drive    :  c:
           path     :  \subdir\dir\
           filename :  filename
           ext      :  .ext

*/
  void set_ext(csCHAR *s);
  void set_dir_cur(void);     // Current directory on the current drive.
  void del_ext(void);
  csCHAR *extension(void)     { return exten; }

  void force_ext(csCHAR *s);

  csCHAR *name_dpfe(csCHAR *n);
  csCHAR *name_dp(csCHAR *n);
  csCHAR *name_dpf(csCHAR *n);
  csCHAR *name_pfe(csCHAR *n);
  csCHAR *name_pf(csCHAR *n);
  csCHAR *name_fe(csCHAR *n);
  csCHAR *name_f(csCHAR *n);
  csCHAR *name_e(csCHAR *n);
  csCHAR *name_p(csCHAR *n);
  csCHAR *name_d(csCHAR *n);

  csCHAR *name_dpfe(void);
  csCHAR *name_dp(void);
  csCHAR *name_dpf(void);
  csCHAR *name_pfe(void);
  csCHAR *name_pf(void);
  csCHAR *name_fe(void);
  csCHAR *name_f(void);
  csCHAR *name_e(void);
  csCHAR *name_p(void);
  csCHAR *name_d(void);


  int operator==(FILE_NAME& fn);

  FILE_NAME(void);
  virtual ~FILE_NAME(void) {}



};


#endif
