//------------------------------------------------------------------------------
//	DIBCLASS.H --  Adam King, 2000
//
// Class to store and manage Device-Independent Bitmap (DIB) information
//------------------------------------------------------------------------------
#ifndef DIBCLASS_H
#define DIBCLASS_H

#include <windows.h>

//------------------------------------------------------------------------------
//	The DIB class definition
//------------------------------------------------------------------------------
class _export DIB
{
	LPBITMAPINFO	lpDib;	// Pointer to the Bitmap Information

public:
	DIB();
	~DIB() { Clear(); }

	// Clear all information from the DIB class, freeing any alocated memory
	void Clear();

	// Utility function to extract the Header Size from the DIB memory block
	DWORD GetDibInfoHeaderSize(void);

	// Utility function to extract the Width of the DIB
	DWORD GetDibWidth(void);

	// Utility function to extract the Height of the DIB
	DWORD GetDibHeight(void);

	// Utility function to provide external access to the Bitmap Information
	LPBITMAPINFO GetDib() { return lpDib; }

	// Read a DIB from a file into memory
	LPBITMAPINFO ReadDib(LPCSTR szFileName);
};

#endif

