//==============================================================================
// TEST.CPP --  2000 Adam King
//==============================================================================
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdio.h>
#include <string.h>

#include "test.h"
#include "testdefs.h"
#include "client.h"
#include "dibdll.h"

// Function declarations
BOOL Register(HINSTANCE);
HWND Create(HINSTANCE, int);
BOOL Frame_OnCreate(HWND, CREATESTRUCT FAR*);
void Frame_OnDestroy(HWND);
void Frame_OnClose(HWND);
void Frame_OnCommand(HWND, int, HWND, UINT);
void InitMenus();
void KillMenus(HWND);
HWND Frame_NewWindow();

char			szAppName[] = "DIBDLL Sample: MDI with tiled background";
char 			szFrameClass[] = "Test";
char 			szMDIChildClass[] = "MDIChild";
HINSTANCE 	hInstance;
HWND 			hWndFrame;
HWND 			hWndClient;
HWND			CurrentWindow;
HMENU			hMainMenu = NULL;
FARPROC		pNewClientProc;
WNDPROC		OldClientProc;

char			szModuleDir[260];						// Program Directory


//==============================================================================
//
//	ENGLISH 1.0 Program Entry Point
//
//==============================================================================
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	MSG 		msg;

	msg.wParam = FALSE;

	// Prevent multiple instances of the program
	if(hPrevInstance)
	{
		HWND hWnd, hWnd1;

		// Find top-level window of prev. inst.
		hWnd = FindWindow(NULL, szAppName);
		if(hWnd)
		{
			// Find any open dialogs or msg boxes
			hWnd1 = GetLastActivePopup(hWnd);
			if(hWnd1)
				hWnd = hWnd1;

			// Make it visible
			BringWindowToTop(hWnd);

			// restore prev. inst. if necess.
			if(IsIconic(hWnd))
				ShowWindow(hWnd, SW_RESTORE);
		}
		// end this 2nd inst.
		goto quitapp;
	}

	// Register all program window classes
	if(!Register(hInst))
		goto quitapp;

	// Create the main program window
	hWndFrame = Create(hInst, nCmdShow);
	if(!hWndFrame)
		goto quitapp;

	// Main message loop
	while(GetMessage(&msg, NULL, 0, 0))
	{
		if(CurrentWindow == NULL || !IsDialogMessage(CurrentWindow, &msg))
		{
			if(!TranslateMDISysAccel(hWndClient, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}

quitapp:

	return msg.wParam;
}

// DefProc for the frame window
LRESULT Frame_DefProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return(DefFrameProc(hwnd, hWndClient, uMsg, wParam, lParam));
}

// Register classes with the OS

BOOL Register(HINSTANCE hInst)
{
	WNDCLASS 	wndclass;

	hInstance = hInst;

	// Register the frame window class
	wndclass.style				= CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc		= FrameWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= sizeof(DIBVIEW *);
	wndclass.hInstance		= hInst;
	wndclass.hIcon				= LoadIcon(hInst, "ICO_AppEnglish");
	wndclass.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground 	= (HBRUSH)(COLOR_APPWORKSPACE + 1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szFrameClass;
	if(!RegisterClass(&wndclass))
		return FALSE;

	// Register the child window class
	wndclass.style				= CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc		= DefMDIChildProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= NULL;
	wndclass.hInstance		= hInst;
	wndclass.hIcon				= LoadIcon(hInst, IDI_APPLICATION);
	wndclass.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground 	= (HBRUSH)(COLOR_WINDOW + 1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szMDIChildClass;
	if(!RegisterClass(&wndclass))
		return FALSE;

	return TRUE;
}

// Create the main window
#pragma argsused
HWND Create(HINSTANCE hInst, int nCmdShow)
{
	hInstance = hInst;

	hMainMenu = LoadMenu(hInstance, "PrivMenu");

	HWND hwnd = CreateWindow(szFrameClass, szAppName,
						WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_VISIBLE,
						CW_USEDEFAULT, CW_USEDEFAULT,
						CW_USEDEFAULT, CW_USEDEFAULT,
						NULL, hMainMenu, hInstance, NULL);

	return hwnd;
}

LRESULT CALLBACK FrameWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
//	case WM_CREATE:
//		return Frame_OnCreate(hwnd, (CREATESTRUCT FAR*)lParam);

		HANDLE_MSG(hwnd, WM_CREATE, Frame_OnCreate);
		HANDLE_MSG(hwnd, WM_DESTROY, Frame_OnDestroy);
		HANDLE_MSG(hwnd, WM_CLOSE, Frame_OnClose);
		HANDLE_MSG(hwnd, WM_COMMAND, Frame_OnCommand);
	}
	return DefFrameProc(hwnd, hWndClient, message, wParam, lParam);
}

// Handle WM_CREATE:  Create the client window & setup program data
#pragma argsused
BOOL Frame_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
	CLIENTCREATESTRUCT 	clientcreate;
	DIBVIEW *		ClientDib;
	char *			pStr;
	char				szDib[500];

	hWndFrame = hwnd;

	GetModuleFileName(hInstance, szModuleDir, sizeof(szModuleDir));
	pStr = strrchr(szModuleDir, '\\');
	*pStr = '\0';

	// Create the Client window
	clientcreate.hWindowMenu = GetSubMenu(hMainMenu, 0);
	clientcreate.idFirstChild = 20000;
	hWndClient = CreateWindow("MDICLIENT", NULL,
				WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN |
				MDIS_ALLCHILDSTYLES,
				0, 0, 0, 0, hwnd, HMENU(1), hInstance, (LPSTR)&clientcreate);
	if(hWndClient == NULL)
		return FALSE;

	// Subclass the Client window
	pNewClientProc = MakeProcInstance(FARPROC(NewClientProc), hInstance);
	OldClientProc = (WNDPROC)SetWindowLong(hWndClient, GWL_WNDPROC, LONG(pNewClientProc));
	if(!OldClientProc)
		return FALSE;

	// Create the background bitmap
	ClientDib = new DIBVIEW;
	SetWindowLong(hwnd, 0, LONG(ClientDib));
	if(ClientDib)
	{
		sprintf(szDib, "%s\\BGTILES\\Aztec-s.bmp", szModuleDir);
		ClientDib->SetDisplayType(DIB_TILE);
		ClientDib->LoadDIB(szDib);
	}

	return TRUE;
}

// Handle WM_DESTROY
#pragma argsused
void Frame_OnDestroy(HWND hwnd)
{
	DIBVIEW *	ClientDib = (DIBVIEW *)GetWindowLong(hwnd, 0);
	if(ClientDib)
		delete ClientDib;

	if(pNewClientProc)
	{
		SetWindowLong(hWndClient, GWL_WNDPROC, LONG(OldClientProc));
		FreeProcInstance(pNewClientProc);
	}

	PostQuitMessage(0);
}

// Handle WM_CLOSE
#pragma argsused
void Frame_OnClose(HWND hwnd)
{
	DestroyWindow(hwnd);
}

// Handle WM_COMMAND
#pragma argsused
void Frame_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
	// Do default processing for any system commands (SC_*)
	if((unsigned)id >= 0xF000u) goto DWP;

	switch(id)
	{
	case CM_FILENEW_WINDOW:
		Frame_NewWindow();
		break;

	case CM_FILEEXIT:
		PostMessage(hwnd, WM_CLOSE, 0, 0);
		break;

	default:
		// Pass to active child

		// ...

		// and then to Frame_DefProc
		break;
	}
	DWP:
		FORWARD_WM_COMMAND(hwnd, id, hwndCtl, codeNotify, Frame_DefProc);
}

HWND Frame_NewWindow()
{
	MDICREATESTRUCT MCS;

	// Create the window...
	MCS.szClass		= szMDIChildClass;
	MCS.szTitle		= "MDI Child Window";
	MCS.hOwner		= hInstance;
	MCS.x				= CW_USEDEFAULT;
	MCS.y				= CW_USEDEFAULT;
	MCS.cx			= CW_USEDEFAULT;
	MCS.cy			= CW_USEDEFAULT;
	MCS.style		= WS_OVERLAPPEDWINDOW | WS_VISIBLE;
	MCS.lParam		= 0;
	return FORWARD_WM_MDICREATE(hWndClient, &MCS, SendMessage);
}

