#define WIN32_LEAN_AND_MEAN
#define STRICT 
#include <windows.h>
#pragma hdrstop


#define SHOW( X )	OutputDebugString(X ##"\r")


// Define the calltypes to the original MessageBox and SetProcAddress
typedef int	(*MESSAGEBOX)(HWND,LPCTSTR,LPCTSTR,UINT);
typedef FARPROC  (*SETPROCADDRESS)(HMODULE , PSTR, FARPROC);

// Global variables
HMODULE		hMod	= NULL;
HMODULE		hDLL	= NULL;
HMODULE		hUser	= NULL;
MESSAGEBOX	pfnMessageBox = NULL;
SETPROCADDRESS pfnSetProcAddress = NULL;
char		buf[256];

//---------------------------------------------------------------------------
// MyMessageBox	- Replaces the system MessageBox function
//---------------------------------------------------------------------------
int	WINAPI MyMessageBox(HWND hWnd,LPCTSTR lpText,LPCTSTR lpCaption,UINT uType)
{
	SHOW("----- Hey! We are in my replacement Function! -----");
	return pfnMessageBox(hWnd,lpText,"Hey! This is my substituted caption!" ,uType);
	
}

//---------------------------------------------------------------------------
// DLLEntry
//---------------------------------------------------------------------------
BOOL WINAPI DLLEntry(HMODULE hmodDLL, DWORD fwdReason, LPVOID lpvReserved)
{
	switch(fwdReason)
		{
		case DLL_PROCESS_ATTACH:

			hMod = hmodDLL;

			// ----------------------------------------------------
			// Attemp to load NEWAPI32.DLL
			// ----------------------------------------------------

			hDLL = LoadLibrary("..\\newapi32.dll");
			if (! hDLL)
			{
				SHOW("Failed to load NEWAPI32.DLL");
				return FALSE;
			}

			// ----------------------------------------------------
			// Attemp to get the address of 'SetProcAddress'
			// ----------------------------------------------------

			pfnSetProcAddress = (SETPROCADDRESS)GetProcAddress(hDLL, "SetProcAddress");
			if(! pfnSetProcAddress)
			{
				SHOW("Failed to get address of 'SetProcAddress'");
				return FALSE;
			}
			
			// ----------------------------------------------------
			// Attempt to load 'user32.dll'
			// ----------------------------------------------------

			hUser = LoadLibrary("user32.dll");
			if(! hUser)
			{
				SHOW("Failed to load user32.dll");
				return FALSE;
			}

			// ----------------------------------------------------
			// Now replace the 'MessageBoxA' API function with my own
			// ----------------------------------------------------
			
			pfnMessageBox=(MESSAGEBOX)(pfnSetProcAddress)(hUser, "MessageBoxA",(FARPROC)MyMessageBox);
			if(!pfnMessageBox)
			{
				SHOW("Failed in call to SetProcAddress");
				return FALSE;
			}
			
			break;
		case DLL_PROCESS_DETACH:

			// ----------------------------------------------------
			// Restore the 'MessageBoxA' API.
			// ----------------------------------------------------

			pfnMessageBox=(MESSAGEBOX)(pfnSetProcAddress)(hUser, "MessageBoxA",(FARPROC)pfnMessageBox);
			if(!pfnMessageBox)
			{
				SHOW("Failed to restore the 'MessageBoxA' API");
			}

			// Free the library			
			FreeLibrary(hDLL);
			break;
	  default:
			break;
	}
	return TRUE;
}

