{TELND import unit for Borland Pascal}


unit usetelnd;
INTERFACE

uses wintypes;

const
   {wparam sent with wm_teld message}
  TDEV_CONNECT             =1;     {on connection}
  TDEV_DISCONNECT          =2;
  TDEV_RCVDATA             =0;      {data received}
  TDEV_CTRLCHAR            =100;    {ctrlchar received}

  {user message modes}
  MM_LINE       = 1;
  MM_CTRL       =2;
  MM_SEND       =4;

  {echo modes}
  EM_ENABLED  = 1;  
  EM_HIDDEN   =2;
  EM_CRTOCRLF  =4;



  procedure TelnetInit(password: Pchar;  hParent: hWnd); far;
  procedure TelnetAsync(hwindow: hWnd; wMsg: word; mode:integer); far;
  procedure TelnetRelease; far;
  procedure TelnetDisconnect; far;

  {I/O}
  function TelnetInputChar(c :Pchar): bool; far;
  function TelnetInputLine(line :Pchar): bool; far;
  procedure TelnetSendString(ss: Pchar); far;
  procedure TelnetSendLine(ss: Pchar); far;

    {synchronous mode}
   function TelnetWaitLine(line :Pchar): bool; far;
   function TelnetWaitChar(ch :Pchar): bool; far;
   function TelnetWaitConnect: bool;  far;
   function TelnetBlocking: bool;  far;
   procedure TelnetUnblock;    far;


      {status}
  function  TelnetConnected: bool; far;
  function  TelnetCTS: bool; far;
  procedure TelnetRemoteIP(addr: Pchar);  far;
  procedure TelnetRemoteHost(hname: Pchar);  far;
  function TelnetPendingInput: integer; far;

  procedure TelnetSetEcho(echomode: integer); far;

  {VT100 terminal commands}
 procedure TelnetVTClearScreen; far;
 procedure TelnetVTHome; far;
 procedure TelnetVTEraseLine; far;
 procedure TelnetVTSaveCursor; far;
 procedure TelnetVTRestoreCursor; far;
 procedure TelnetVTLocate(row,col:integer); far;



IMPLEMENTATION


  procedure TelnetInit;             external 'TELND';
  procedure TelnetRelease;            external 'TELND';
  procedure TelnetAsync;            external 'TELND';

  procedure TelnetDisconnect;       external 'TELND';

  function TelnetPendingInput;      external 'TELND';
  function TelnetInputChar;             external 'TELND';
  function TelnetInputLine;             external 'TELND';

    {synchronous mode}
   function TelnetWaitChar;        external 'TELND';
   function TelnetWaitLine;        external 'TELND';
   function TelnetWaitConnect;      external 'TELND';
   function TelnetBlocking;         external 'TELND';
   procedure TelnetUnblock;         external 'TELND';

  function  TelnetCTS;              external 'TELND';
  function  TelnetConnected;        external 'TELND';

  procedure TelnetRemoteIP;          external 'TELND';
  procedure TelnetRemoteHost;          external 'TELND';

  procedure TelnetSetEcho;        external 'TELND';



  procedure TelnetSendLine;         external 'TELND';
  procedure TelnetSendString;       external 'TELND';


  {vt100 commands}
 procedure TelnetVTClearScreen;             external 'TELND';
 procedure TelnetVTHome;                    external 'TELND';
 procedure TelnetVTEraseLine;               external 'TELND';
 procedure TelnetVTSaveCursor;              external 'TELND';
 procedure TelnetVTRestoreCursor;           external 'TELND';
 procedure TelnetVTLocate;                  external 'TELND';


end.
