/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Replace
extends Task {
    private File src = null;
    private File dest = null;
    private String token = null;
    private String value = "";

    public void execute() throws BuildException {
        this.project.log("Replacing " + this.token + " --> " + this.value);
        if (this.src == null || this.token == null) {
            this.project.log("File and token must not be null");
            return;
        }
        if (this.dest == null) {
            throw new BuildException("Error creating temp file.");
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.src));
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.dest));
            while ((line = br.readLine()) != null) {
                if (line.length() != 0) {
                    bw.write(this.replace(line));
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
            br.close();
            this.src.delete();
            this.dest.renameTo(this.src);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String replace(String orig) {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int end = 0;
        while ((end = orig.indexOf(this.token, start)) > -1) {
            buffer.append(orig.substring(start, end));
            buffer.append(this.value);
            start = end + this.token.length();
        }
        buffer.append(orig.substring(start));
        return buffer.toString();
    }

    public void setFile(String file) {
        this.src = this.project.resolveFile(file);
        this.dest = this.project.resolveFile(String.valueOf(file) + ".temp");
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

