/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.tomcat.catalina.Manager;
import org.apache.tomcat.catalina.Session;
import org.apache.tomcat.session.ManagerBase;
import org.apache.tomcat.session.StandardSessionContext;
import org.apache.tomcat.util.StringManager;

final class StandardSession
implements HttpSession,
Session {
    private Hashtable attributes = new Hashtable();
    private long creationTime = 0L;
    private String id = null;
    private static final String info = "StandardSession/1.0";
    private long lastAccessedTime = this.creationTime;
    private Manager manager = null;
    private int maxInactiveInterval = -1;
    private boolean isNew = true;
    private boolean isValid = false;
    private StringManager sm = StringManager.getManager("org.apache.tomcat.session");
    private static HttpSessionContext sessionContext = null;
    private long thisAccessedTime = this.creationTime;

    public StandardSession(Manager manager) {
        this.manager = manager;
    }

    public void access() {
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
        this.isNew = false;
    }

    public void expire() {
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).remove(this);
        }
        Vector<String> results = new Vector<String>();
        Enumeration attrs = this.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr = (String)attrs.nextElement();
            results.addElement(attr);
        }
        Enumeration names = results.elements();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.removeAttribute(name);
        }
        this.setValid(false);
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.getAttribute.ise"));
        }
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.getAttributeNames.ise"));
        }
        return this.attributes.keys();
    }

    public long getCreationTime() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.getCreationTime.ise"));
        }
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public String getInfo() {
        return info;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Manager getManager() {
        return this.manager;
    }

    public int getMaxInactiveInterval() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.getMaxInactiveInterval.ise"));
        }
        return this.maxInactiveInterval;
    }

    public HttpSession getSession() {
        return this;
    }

    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.getValueNames.ise"));
        }
        Vector<String> results = new Vector<String>();
        Enumeration attrs = this.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr = (String)attrs.nextElement();
            results.addElement(attr);
        }
        String[] names = new String[results.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = (String)results.elementAt(i);
            ++i;
        }
        return names;
    }

    public void invalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.invalidate.ise"));
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.isNew.ise"));
        }
        return this.isNew;
    }

    boolean isValid() {
        return this.isValid;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.creationTime = (Long)stream.readObject();
        this.id = (String)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        int n = (Integer)stream.readObject();
        int i = 0;
        while (i < n) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            this.attributes.put(name, value);
            ++i;
        }
    }

    public void recycle() {
        this.attributes.clear();
        this.creationTime = 0L;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.manager = null;
        this.maxInactiveInterval = -1;
        this.isNew = true;
        this.isValid = false;
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).recycle(this);
        }
    }

    public void removeAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.removeAttribute.ise"));
        }
        Hashtable hashtable = this.attributes;
        synchronized (hashtable) {
            Object object = this.attributes.get(name);
            if (object == null) {
                Object var3_4 = null;
                return;
            }
            this.attributes.remove(name);
            if (object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (!this.isValid()) {
            throw new IllegalStateException(this.sm.getString("standardSession.setAttribute.ise"));
        }
        if (this.manager != null && this.manager.getDistributable() && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(this.sm.getString("standardSession.setAttribute.iae"));
        }
        Hashtable hashtable = this.attributes;
        synchronized (hashtable) {
            this.removeAttribute(name);
            this.attributes.put(name, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
    }

    public void setId(String id) {
        if (this.id != null && this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).remove(this);
        }
        this.id = id;
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).add(this);
        }
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(new Long(this.creationTime));
        stream.writeObject(this.id);
        stream.writeObject(new Long(this.lastAccessedTime));
        stream.writeObject(new Integer(this.maxInactiveInterval));
        stream.writeObject(new Boolean(this.isNew));
        stream.writeObject(new Boolean(this.isValid));
        Vector<String> results = new Vector<String>();
        Enumeration attrs = this.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr = (String)attrs.nextElement();
            Object value = this.attributes.get(attr);
            if (!(value instanceof Serializable)) continue;
            results.addElement(attr);
        }
        stream.writeObject(new Integer(results.size()));
        Enumeration names = results.elements();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            stream.writeObject(name);
            stream.writeObject(this.attributes.get(name));
        }
    }
}

