/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.StringManager;

public class LoadOnStartupInterceptor
extends BaseInterceptor {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.context");

    public void contextInit(Context ctx) {
        Hashtable loadableServlets = new Hashtable();
        this.init(ctx, loadableServlets);
        Vector<Integer> orderedKeys = new Vector<Integer>();
        Enumeration e = loadableServlets.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            int slot = -1;
            int i = 0;
            while (i < orderedKeys.size()) {
                if (key < (Integer)orderedKeys.elementAt(i)) {
                    slot = i;
                    break;
                }
                ++i;
            }
            if (slot > -1) {
                orderedKeys.insertElementAt(key, slot);
                continue;
            }
            orderedKeys.addElement(key);
        }
        int i = 0;
        while (i < orderedKeys.size()) {
            Integer key = (Integer)orderedKeys.elementAt(i);
            Enumeration sOnLevel = ((Vector)loadableServlets.get(key)).elements();
            while (sOnLevel.hasMoreElements()) {
                String servletName = (String)sOnLevel.nextElement();
                ServletWrapper result = ctx.getServletByName(servletName);
                if (ctx.getDebug() > 0) {
                    ctx.log("Loading " + key + " " + servletName);
                }
                if (result == null) {
                    System.out.println("Warning: we try to load an undefined servlet " + servletName);
                    continue;
                }
                try {
                    if (result.getPath() != null) {
                        this.loadJsp(ctx, result);
                        continue;
                    }
                    result.loadServlet();
                }
                catch (Exception exception) {
                    String msg = sm.getString("context.loadServlet.e", servletName);
                    System.out.println(msg);
                }
            }
            ++i;
        }
    }

    void init(Context ctx, Hashtable loadableServlets) {
        Enumeration enumeration = ctx.getServletNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            ServletWrapper sw = ctx.getServletByName(name);
            int i = sw.getLoadOnStartUp();
            Integer level = new Integer(i);
            if (i == 0) continue;
            Vector v = loadableServlets.get(level) != null ? (Vector)loadableServlets.get(level) : new Vector();
            v.addElement(name);
            loadableServlets.put(level, v);
        }
    }

    void loadJsp(Context context, ServletWrapper result) throws Exception {
        System.out.println("Initializing JSP with JspWrapper");
        String path = result.getPath();
        RequestImpl request = new RequestImpl();
        ResponseImpl response = new ResponseImpl();
        request.setContextManager(context.getContextManager());
        request.recycle();
        response.recycle();
        request.setResponse(response);
        response.setRequest(request);
        String requestURI = String.valueOf(path) + "?jsp_precompile=true";
        request.setRequestURI(String.valueOf(context.getPath()) + path);
        request.setQueryString("jsp_precompile=true");
        request.setContext(context);
        request.getSession(true);
        RequestDispatcher rd = context.getRequestDispatcher(requestURI);
        try {
            rd.forward((ServletRequest)request.getFacade(), (ServletResponse)response.getFacade());
        }
        catch (ServletException servletException) {
        }
        catch (IOException iOException) {}
    }
}

