/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.net.Socket;
import java.util.Vector;
import org.apache.tomcat.service.PoolTcpEndpoint;
import org.apache.tomcat.service.TcpConnection;

class TcpWorkerThread
implements Runnable {
    PoolTcpEndpoint endpoint;
    Vector connectionCache;

    public TcpWorkerThread(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connectionCache = new Vector(endpoint.getMaxThreads());
        int i = 0;
        while (i < endpoint.getMaxThreads() / 2) {
            this.connectionCache.addElement(new TcpConnection());
            ++i;
        }
    }

    public void run() {
        while (this.endpoint.running) {
            Socket s = this.endpoint.acceptSocket();
            if (s == null) continue;
            this.endpoint.tp.runIt(this);
            TcpConnection con = null;
            try {
                try {
                    con = (TcpConnection)this.connectionCache.lastElement();
                    this.connectionCache.removeElementAt(this.connectionCache.size() - 1);
                }
                catch (Throwable throwable) {
                    con = new TcpConnection();
                }
                con.setEndpoint(this.endpoint);
                con.setSocket(s);
                this.endpoint.getConnectionHandler().processConnection(con, null);
                break;
            }
            finally {
                Object var4_3 = null;
                con.recycle();
                this.connectionCache.addElement(con);
            }
        }
    }
}

