/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.File;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.TcpEndpointConnector;
import org.apache.tomcat.service.connector.Ajp12ConnectionHandler;
import org.apache.tomcat.task.ApacheConfig;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.xml.XmlMapper;

public class Tomcat {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.startup");
    String configFile = null;
    static final String DEFAULT_CONFIG = "conf/server.xml";
    boolean doStop = false;

    static {
        String warPackage = "org.apache.tomcat.protocol";
        String protocolKey = "java.protocol.handler.pkgs";
        String protocolHandlers = System.getProperties().getProperty(protocolKey);
        ((Hashtable)System.getProperties()).put(protocolKey, protocolHandlers == null ? warPackage : String.valueOf(protocolHandlers) + "|" + warPackage);
    }

    Tomcat() {
    }

    public void execute(String[] args) throws Exception {
        if (!this.processArgs(args)) {
            System.out.println(sm.getString("tomcat.wrongargs"));
            Tomcat.printUsage();
            return;
        }
        if (this.doStop) {
            System.out.println(sm.getString("tomcat.stop"));
            this.stopTomcat();
            return;
        }
        XmlMapper xh = new XmlMapper();
        xh.setDebug(0);
        ContextManager cm = new ContextManager();
        this.setHelper(xh);
        this.setConnectorHelper(xh);
        this.setLogHelper(xh);
        File f = this.getConfigFile(cm);
        try {
            xh.readXml(f, cm);
        }
        catch (Exception ex) {
            System.out.println(sm.getString("tomcat.fatalconfigerror"));
            ex.printStackTrace();
            System.exit(1);
        }
        ApacheConfig apacheConfig = new ApacheConfig();
        apacheConfig.execute(cm);
        System.out.println(sm.getString("tomcat.start"));
        cm.init();
        cm.start();
    }

    File getConfigFile(ContextManager cm) {
        if (this.configFile != null) {
            return new File(this.configFile);
        }
        String tchome = System.getProperty("tomcat.home");
        if (tchome == null) {
            System.out.println(sm.getString("tomcat.nohome"));
            tchome = ".";
        }
        cm.setTomcatHome(tchome);
        return new File(tchome, DEFAULT_CONFIG);
    }

    public static void main(String[] args) {
        try {
            Tomcat tomcat = new Tomcat();
            tomcat.execute(args);
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(sm.getString("tomcat.fatal")) + ex);
            ex.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println(sm.getString("tomcat.usage"));
    }

    public boolean processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("help")) {
                Tomcat.printUsage();
                return false;
            }
            if (arg.equals("-stop")) {
                this.doStop = true;
            } else if (arg.equals("-f") || arg.equals("-config")) {
                if (++i < args.length) {
                    this.configFile = args[i];
                }
            } else if ((arg.equals("-h") || arg.equals("-home")) && ++i < args.length) {
                ((Hashtable)System.getProperties()).put("tomcat.home", args[i]);
            }
            ++i;
        }
        return true;
    }

    void setConnectorHelper(XmlMapper xh) {
        xh.addRule("ContextManager/Connector", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/Connector", xh.setParent("setContextManager"));
        xh.addRule("ContextManager/Connector", xh.addChild("addServerConnector", "org.apache.tomcat.core.ServerConnector"));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodSetter("setProperty", 2));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodParam(0, "name"));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodParam(1, "value"));
    }

    void setHelper(XmlMapper xh) {
        xh.addRule("ContextManager", xh.setProperties());
        xh.addRule("ContextManager/ContextInterceptor", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/ContextInterceptor", xh.setProperties());
        xh.addRule("ContextManager/ContextInterceptor", xh.setParent("setContextManager"));
        xh.addRule("ContextManager/ContextInterceptor", xh.addChild("addContextInterceptor", "org.apache.tomcat.core.ContextInterceptor"));
        xh.addRule("ContextManager/RequestInterceptor", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/RequestInterceptor", xh.setProperties());
        xh.addRule("ContextManager/RequestInterceptor", xh.setParent("setContextManager"));
        xh.addRule("ContextManager/RequestInterceptor", xh.addChild("addRequestInterceptor", "org.apache.tomcat.core.RequestInterceptor"));
        xh.addRule("ContextManager/Context", xh.objectCreate("org.apache.tomcat.core.Context"));
        xh.addRule("ContextManager/Context", xh.setParent("setContextManager"));
        xh.addRule("ContextManager/Context", xh.setProperties());
        xh.addRule("ContextManager/Context", xh.addChild("addContext", null));
    }

    void setLogHelper(XmlMapper xh) {
        xh.addRule("Server/Logger", xh.objectCreate("org.apache.tomcat.logging.TomcatLogger"));
        xh.addRule("Server/Logger", xh.setProperties());
        xh.addRule("Server/Logger", xh.addChild("addLogger", "org.apache.tomcat.logging.Logger"));
    }

    void stopTomcat() {
        XmlMapper xh = new XmlMapper();
        xh.setDebug(0);
        ContextManager cm = new ContextManager();
        this.setConnectorHelper(xh);
        File f = this.getConfigFile(cm);
        try {
            xh.readXml(f, cm);
        }
        catch (Exception ex) {
            System.out.println(sm.getString("tomcat.fatalconfigerror"));
            ex.printStackTrace();
            System.exit(1);
        }
        int portInt = 8007;
        Enumeration enumeration = cm.getConnectors();
        while (enumeration.hasMoreElements()) {
            TcpEndpointConnector tcpCon;
            Object con = enumeration.nextElement();
            if (!(con instanceof TcpEndpointConnector) || !((tcpCon = (TcpEndpointConnector)con).getTcpConnectionHandler() instanceof Ajp12ConnectionHandler)) continue;
            portInt = tcpCon.getPort();
        }
        try {
            Socket socket = new Socket("localhost", portInt);
            OutputStream os = socket.getOutputStream();
            byte[] stopMessage = new byte[]{-2, 15};
            os.write(stopMessage);
            socket.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

