/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.runtime.JspLoader;
import org.apache.jasper.runtime.ServletEngine;
import org.apache.tomcat.logging.Logger;

public class JspServlet
extends HttpServlet {
    ServletContext context = null;
    Hashtable jsps = new Hashtable();
    Hashtable loadedJSPs = new Hashtable();
    ServletConfig config;
    JspLoader loader;
    Options options;
    ClassLoader parentClassLoader;
    ServletEngine engine;
    String serverInfo;
    static boolean firstTime = true;

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        Enumeration servlets = this.jsps.elements();
        while (servlets.hasMoreElements()) {
            ((JspServletWrapper)servlets.nextElement()).destroy();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        this.options = new EmbededServletOptions(config, this.context);
        this.parentClassLoader = (ClassLoader)this.context.getAttribute("org.apache.tomcat.classloader");
        if (this.parentClassLoader == null) {
            this.parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()}, 4);
        } else {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{"<none>"}, 4);
        }
        this.loader = new JspLoader(this.parentClassLoader, this.options);
        if (firstTime) {
            firstTime = false;
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()}, 3);
            Constants.message("jsp.message.dont.modify.servlets", 3);
        }
        JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
    }

    public boolean loadJSP(String name, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        Compiler compiler;
        boolean outDated;
        JspEngineContext ctxt;
        Class<?> jspClass;
        block12: {
            jspClass = (Class<?>)this.loadedJSPs.get(name);
            boolean firstTime = jspClass == null;
            ctxt = new JspEngineContext(this.loader, classpath, this.context, name, isErrorPage, this.options, req, res);
            outDated = false;
            compiler = ctxt.createCompiler();
            try {
                outDated = compiler.compile();
                if (jspClass != null && !compiler.isOutDated()) break block12;
                JspServlet jspServlet = this;
                synchronized (jspServlet) {
                    if (jspClass == null || compiler.isOutDated()) {
                        outDated = compiler.compile();
                    }
                }
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString("jsp.error.unable.compile"), ex);
            }
        }
        if (jspClass == null || outDated) {
            try {
                if (ctxt.getServletClassName() == null) {
                    compiler.computeServletClassName();
                }
                jspClass = this.loader.loadClass(ctxt.getFullClassName());
            }
            catch (ClassNotFoundException cex) {
                throw new JasperException(Constants.getString("jsp.error.unable.load"), cex);
            }
            this.loadedJSPs.put(name, jspClass);
        }
        return outDated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean preCompile(HttpServletRequest request) throws ServletException {
        boolean precompile = false;
        String precom = request.getParameter("jsp_precompile");
        String qString = request.getQueryString();
        if (precom != null) {
            if (precom.equals("true")) {
                return true;
            }
            if (!precom.equals("false")) throw new ServletException("Can't have request parameter  jsp_precomile set to " + precom);
            return false;
        }
        if (qString == null) return precompile;
        if (qString.startsWith("jsp_precompile")) return true;
        if (qString.indexOf("&jsp_precompile") == -1) return precompile;
        return true;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String includeUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            String jspUri = includeUri == null ? request.getServletPath() : includeUri;
            boolean precompile = this.preCompile(request);
            Logger jasperLog = Constants.jasperLog;
            if (jasperLog != null && jasperLog.matchVerbosityLevel(3)) {
                jasperLog.log("JspEngine --> " + jspUri);
                jasperLog.log("\t     ServletPath: " + request.getServletPath());
                jasperLog.log("\t        PathInfo: " + request.getPathInfo());
                jasperLog.log("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(jspUri));
                jasperLog.log("\t      RequestURI: " + request.getRequestURI());
                jasperLog.log("\t     QueryString: " + request.getQueryString());
                jasperLog.log("\t  Request Params: ");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    jasperLog.log("\t\t " + name + " = " + request.getParameter(name));
                }
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        catch (Throwable t) {
            this.unknownException(response, t);
        }
    }

    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        boolean isErrorPage = exception != null;
        JspServletWrapper wrapper = (JspServletWrapper)this.jsps.get(jspUri);
        if (wrapper == null) {
            wrapper = new JspServletWrapper(jspUri, isErrorPage);
            this.jsps.put(jspUri, wrapper);
        }
        wrapper.service(request, response, precompile);
    }

    final void unknownException(HttpServletResponse response, Throwable t) {
        block10: {
            PrintWriter writer = new PrintWriter(System.err, true);
            if (this.options.getSendErrorToClient()) {
                try {
                    response.setContentType("text/html");
                    writer = response.getWriter();
                }
                catch (IOException iOException) {
                    writer = new PrintWriter(System.err, true);
                }
            }
            writer.println(Constants.getString("jsp.error.unknownException"));
            if (this.options.getSendErrorToClient()) {
                writer.println("<pre>");
            }
            if (t instanceof JasperException) {
                Throwable x = ((JasperException)((Object)t)).getRootCause();
                (x != null ? x : t).printStackTrace(writer);
            } else {
                t.printStackTrace(writer);
            }
            if (this.options.getSendErrorToClient()) {
                writer.println("</pre>");
            }
            if (this.options.getSendErrorToClient()) break block10;
            try {
                String message = t.getMessage();
                if (message == null) {
                    message = "No detailed message";
                }
                response.sendError(500, message);
            }
            catch (IOException iOException) {}
        }
    }

    class JspServletWrapper {
        Servlet theServlet;
        String jspUri;
        boolean isErrorPage;

        JspServletWrapper(String jspUri, boolean isErrorPage) {
            this.jspUri = jspUri;
            this.isErrorPage = isErrorPage;
            this.theServlet = null;
        }

        public void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
        }

        private void load() throws JasperException, ServletException {
            try {
                Class servletClass = (Class)JspServlet.this.loadedJSPs.get(this.jspUri);
                this.destroy();
                this.theServlet = (Servlet)servletClass.newInstance();
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
            this.theServlet.init(JspServlet.this.config);
            if (this.theServlet instanceof HttpJspBase) {
                HttpJspBase h = (HttpJspBase)this.theServlet;
                h.setClassLoader(JspServlet.this.parentClassLoader);
            }
        }

        private void loadIfNecessary(HttpServletRequest req, HttpServletResponse res) throws JasperException, ServletException, FileNotFoundException {
            String accordingto;
            String cp = (String)JspServlet.this.context.getAttribute("org.apache.tomcat.jsp_classpath");
            if (cp == null || cp.equals("")) {
                accordingto = "according to the init parameter";
                cp = JspServlet.this.options.getClassPath();
            } else {
                accordingto = "according to the Servlet Engine";
            }
            Constants.message("jsp.message.cp_is", new Object[]{accordingto, cp == null ? "" : cp}, 3);
            if (JspServlet.this.loadJSP(this.jspUri, cp, this.isErrorPage, req, res) || this.theServlet == null) {
                this.load();
            }
        }

        public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
            block7: {
                try {
                    this.loadIfNecessary(request, response);
                    if (precompile) {
                        return;
                    }
                    if (this.theServlet instanceof SingleThreadModel) {
                        JspServletWrapper jspServletWrapper = this;
                        synchronized (jspServletWrapper) {
                            this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                            break block7;
                        }
                    }
                    this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                }
                catch (FileNotFoundException ex) {
                    response.sendError(404, Constants.getString("jsp.error.file.not.found", new Object[]{ex.getMessage()}));
                    return;
                }
            }
        }
    }
}

