/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class Property
extends Task {
    String name;
    String value;
    String file;
    String resource;
    boolean userProperty = false;

    private void addProperties(Properties props) {
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            String v = ProjectHelper.replaceProperties(value, this.project.getProperties());
            if (this.userProperty) {
                this.project.setUserProperty(name, v);
                continue;
            }
            this.project.setProperty(name, v);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void init() throws BuildException {
        try {
            if (this.name != null && this.value != null) {
                String v = ProjectHelper.replaceProperties(this.value, this.project.getProperties());
                if (this.userProperty) {
                    this.project.setUserProperty(this.name, v);
                } else {
                    this.project.setProperty(this.name, v);
                }
            }
            if (this.file != null) {
                this.loadFile(this.file);
            }
            if (this.resource != null) {
                this.loadResource(this.resource);
            }
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private void loadFile(String name) {
        Properties props = new Properties();
        this.project.log("Loading " + name, 3);
        try {
            if (new File(name).exists()) {
                props.load(new FileInputStream(name));
                this.addProperties(props);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadResource(String name) {
        Properties props = new Properties();
        this.project.log("Resource Loading " + name, 3);
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                props.load(is);
                this.addProperties(props);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setUserProperty(boolean userP) {
        this.userProperty = userP;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

