<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
  <xsl:template match="/">



<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[


function loadPO(LINK,PO) {

  var features = "scrollbars=yes,resizable=yes";
  var newlink = LINK + "?disValue=807&PONumber=" + PO; 
  var newLayer = open(newlink,"PO",features);
}

]]>
</xsl:comment>
</SCRIPT>


<HTML>
<HEAD>
     <TITLE>Product Page for <xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_NAME"/></TITLE>
</HEAD>

<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY>
<xsl:attribute name="BGCOLOR"><xsl:value-of select="MSI/LAYOUT/BGCOLOR"/></xsl:attribute>
<xsl:attribute name="TEXT"><xsl:value-of select="MSI/LAYOUT/TEXT"/></xsl:attribute>
<xsl:attribute name="LINK"><xsl:value-of select="MSI/LAYOUT/LINK"/></xsl:attribute>
<xsl:attribute name="ALINK"><xsl:value-of select="MSI/LAYOUT/ALINK"/></xsl:attribute>
<xsl:attribute name="VLINK"><xsl:value-of select="MSI/LAYOUT/VLINK"/></xsl:attribute>
<xsl:attribute name="BACKGROUND"><xsl:value-of select="MSI/LAYOUT/BACKGROUND"/></xsl:attribute>

<!-- End of Include section -->



<!-- Page Specific Data -->
<!-- ***************************************************************************************** -->

<CENTER><FONT FACE="Times New Roman" SIZE="4"><B>Enter Commissions</B></FONT></CENTER>
<P></P>

<xsl:choose>
<xsl:when test="MSI/ERROR[.='1']">
<FONT COLOR="#FF0000" SIZE="5"><B>Could not find a PO matching the one entered!</B></FONT>
<P></P>
</xsl:when>
</xsl:choose>

<xsl:choose>
<xsl:when test="MSI/ERROR[.='2']">
<FONT COLOR="#FF0000" SIZE="5"><B>Need to select a REP or enter a PO!</B></FONT>
<P></P>
</xsl:when>
</xsl:choose>


<FONT FACE="Times New Roman" SIZE="4"><TABLE>
<TR><TD>Total Check Value </TD><TD><FONT SIZE="5"><B><xsl:eval>formatNumber(Total(this), "$#,##0.00")</xsl:eval></B></FONT></TD></TR>
<TR><TD>Check # </TD><TD><xsl:value-of select="MSI/CHECKNUM"/></TD></TR>
<TR><TD>Supplier </TD><TD><xsl:value-of select="MSI/SUPPLIER"/></TD></TR>
<TR><TD>Date Received </TD><TD><xsl:value-of select="MSI/DATERECV"/></TD></TR>

</TABLE>
</FONT>

<FORM METHOD="POST">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<INPUT type="hidden" name="disValue" value="802"></INPUT>


<TABLE>
<TR><TD>PO Number</TD><TD><INPUT NAME="POIDNUM" SIZE="10"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d3"/></xsl:attribute></INPUT></TD></TR>
<TR><TD>Invoice Number</TD><TD><INPUT NAME="INVOICENUM" SIZE="10"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d4"/></xsl:attribute></INPUT></TD></TR>
<TR><TD>Amount Received</TD><TD><INPUT NAME="AMOUNTRECV" SIZE="10"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d5"/></xsl:attribute></INPUT></TD></TR>

<xsl:choose>
<xsl:when test="MSI/REPLIST/REP/REPNAME[.!='']">

<TR><TD>Associated Rep</TD><TD><SELECT NAME="REP">

<OPTION> 
	<xsl:attribute name="VALUE"></xsl:attribute>Choose Rep
</OPTION>

<xsl:for-each select="MSI/REPLIST/REP" order-by="REPNAME">
<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="REPID"/></xsl:attribute><xsl:value-of select="REPNAME"/>
</OPTION>
</xsl:for-each>

</SELECT></TD>
<TD>This is only needed when PO does not exist or to override PO</TD>
</TR>
</xsl:when>
</xsl:choose>



<TR><TD>Notes</TD><TD><INPUT NAME="NOTES" SIZE="20"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/DATA/d10"/></xsl:attribute></INPUT></TD></TR>
</TABLE>
<INPUT TYPE="SUBMIT" NAME="ENTER" VALUE="Enter"></INPUT>
</FORM>

<FORM METHOD="POST">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<TABLE BORDER="1">
	
		<TR>
			<TD><b></b></TD>
			<TD><b>PO Number</b></TD>
			<TD><b>Invoice Number</b></TD>
			<TD><b>Amount Received</b></TD>
			<TD><b>Rep ID</b></TD>		
			<TD><b>Notes</b></TD>
		</TR>
		<xsl:for-each select="MSI/COMINFO/POComTable">
			<TR>
				<TD><INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i3"/></xsl:attribute>
				     </INPUT></TD>
				<TD><xsl:value-of select="i3"/></TD>
				<TD><xsl:value-of select="i4"/></TD>
				<TD>$<xsl:value-of select="i5"/></TD>
				<TD><xsl:value-of select="i9"/></TD>
				<TD><xsl:value-of select="i10"/></TD>
				
				<xsl:choose>
				<xsl:when test="i8[.='1']">
				<TD>
				<BUTTON>
				<xsl:attribute name="ONCLICK">loadPO(&quot;<xsl:value-of select="/MSI/LAYOUT/SERVLET"/>&quot;,&quot;<xsl:value-of select="i3"/>&quot;);</xsl:attribute>
				Reconcile PO		
				</BUTTON>
				</TD>
				</xsl:when>
				</xsl:choose>


			
			</TR>
		</xsl:for-each>
</TABLE>



<INPUT type="hidden" name="disValue" value="803"></INPUT>
<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/COMINFO/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT TYPE="SUBMIT" NAME="DELETE" VALUE="Delete Entries"></INPUT>
</FORM><P></P>




</BODY></HTML>
</xsl:template>



<xsl:script>
<![CDATA[ 
    function Total(invoice)
    {
      items = invoice.selectNodes("MSI/COMINFO/POComTable");
      var sum2 = 0;
      
      var item = items.nextNode();		
      while (item)
      {
        var price = item.selectSingleNode("i5").nodeTypedValue;
        sum2 += price*1;
	item = items.nextNode();
      }
      
      return sum2;
    }

   ]]> 
 
</xsl:script> 

</xsl:stylesheet>
