VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Chess Clock"
   ClientHeight    =   2415
   ClientLeft      =   915
   ClientTop       =   990
   ClientWidth     =   5295
   ControlBox      =   0   'False
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2415
   ScaleWidth      =   5295
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraClock 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2535
      Left            =   0
      TabIndex        =   0
      Top             =   -120
      Width           =   5295
      Begin VB.Timer tmrListen 
         Interval        =   100
         Left            =   2400
         Top             =   840
      End
      Begin VB.Timer tmrBlack 
         Enabled         =   0   'False
         Interval        =   100
         Left            =   4440
         Top             =   360
      End
      Begin VB.Timer tmrWhite 
         Enabled         =   0   'False
         Interval        =   100
         Left            =   480
         Top             =   360
      End
      Begin VB.CommandButton cmdTurnBlack 
         Caption         =   "OK"
         Height          =   375
         Left            =   3000
         TabIndex        =   9
         Top             =   360
         Visible         =   0   'False
         Width           =   495
      End
      Begin VB.CommandButton cmdTurnWhite 
         Caption         =   "OK"
         Height          =   375
         Left            =   1800
         TabIndex        =   8
         Top             =   360
         Visible         =   0   'False
         Width           =   495
      End
      Begin VB.CommandButton cmdEndGame 
         Caption         =   "End Game"
         Height          =   375
         Left            =   3600
         TabIndex        =   7
         Top             =   2040
         Width           =   1455
      End
      Begin VB.CommandButton cmdStartGame 
         Caption         =   "Start Game"
         Height          =   375
         Left            =   240
         TabIndex        =   6
         Top             =   2040
         Width           =   1455
      End
      Begin VB.CommandButton cmdOptions 
         Caption         =   "Options"
         Height          =   375
         Left            =   1920
         TabIndex        =   5
         Top             =   2040
         Width           =   1455
      End
      Begin VB.Label Label8 
         BorderStyle     =   1  'Fixed Single
         Caption         =   " Hotkey"
         Height          =   255
         Left            =   2880
         TabIndex        =   47
         Top             =   1680
         Width           =   855
      End
      Begin VB.Label Label7 
         BorderStyle     =   1  'Fixed Single
         Caption         =   " Hotkey"
         Height          =   255
         Left            =   240
         TabIndex        =   46
         Top             =   1680
         Width           =   855
      End
      Begin VB.Label Label2 
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   " Moves"
         Height          =   255
         Left            =   2880
         TabIndex        =   37
         Top             =   1440
         Width           =   855
      End
      Begin VB.Label Label1 
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   " Moves"
         Height          =   255
         Left            =   240
         TabIndex        =   36
         Top             =   1440
         Width           =   855
      End
      Begin VB.Label lblMovesBlack 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   255
         Left            =   3720
         TabIndex        =   35
         Top             =   1440
         Width           =   1335
      End
      Begin VB.Label lblMovesWhite 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         Height          =   255
         Left            =   1080
         TabIndex        =   34
         Top             =   1440
         Width           =   1335
      End
      Begin VB.Label lblMilliBlack 
         BackStyle       =   0  'Transparent
         Caption         =   ".0"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   14.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   4560
         TabIndex        =   33
         Top             =   840
         Width           =   375
      End
      Begin VB.Label lblMilliWhite 
         BackStyle       =   0  'Transparent
         Caption         =   ".0"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   14.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   1920
         TabIndex        =   32
         Top             =   840
         Width           =   375
      End
      Begin VB.Label lblHotkeyBlack 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-->"
         Height          =   255
         Left            =   3720
         TabIndex        =   13
         Top             =   1680
         Width           =   1335
      End
      Begin VB.Label lblHotkeyWhite 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "<--"
         Height          =   255
         Left            =   1080
         TabIndex        =   12
         Top             =   1680
         Width           =   1335
      End
      Begin VB.Label lblClockBlack 
         Alignment       =   1  'Right Justify
         BackStyle       =   0  'Transparent
         Caption         =   "00:00"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   20.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   3120
         TabIndex        =   4
         Top             =   720
         Width           =   1335
      End
      Begin VB.Label lblClockWhite 
         Alignment       =   1  'Right Justify
         BackStyle       =   0  'Transparent
         Caption         =   "00:00"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   20.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   480
         TabIndex        =   3
         Top             =   720
         Width           =   1335
      End
      Begin VB.Label lblPlayerBlack 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "BLACK"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   3000
         TabIndex        =   2
         Top             =   360
         Width           =   1935
      End
      Begin VB.Label lblPlayerWhite 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         Caption         =   "WHITE"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   360
         TabIndex        =   1
         Top             =   360
         Width           =   1935
      End
      Begin VB.Shape shpHighlightWhite 
         BorderWidth     =   2
         FillColor       =   &H00C0C0C0&
         FillStyle       =   0  'Solid
         Height          =   1095
         Left            =   240
         Top             =   240
         Width           =   2175
      End
      Begin VB.Shape shpHighlightBlack 
         BorderWidth     =   2
         FillColor       =   &H00C0C0C0&
         FillStyle       =   0  'Solid
         Height          =   1095
         Left            =   2880
         Top             =   240
         Width           =   2175
      End
   End
   Begin VB.Frame fraOptions 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2535
      Left            =   0
      TabIndex        =   10
      Top             =   -120
      Width           =   5295
      Begin VB.CommandButton cmdExit 
         Caption         =   "Exit"
         Height          =   375
         Left            =   4200
         TabIndex        =   48
         Top             =   2040
         Width           =   975
      End
      Begin VB.Frame fraHotkeys 
         Caption         =   "Hotkeys"
         Height          =   975
         Left            =   3480
         TabIndex        =   41
         Top             =   240
         Width           =   1695
         Begin VB.ComboBox cboHotkeyBlack 
            Height          =   315
            Left            =   720
            Style           =   2  'Dropdown List
            TabIndex        =   43
            Top             =   600
            Width           =   735
         End
         Begin VB.ComboBox cboHotkeyWhite 
            Height          =   315
            Left            =   720
            Style           =   2  'Dropdown List
            TabIndex        =   42
            Top             =   240
            Width           =   735
         End
         Begin VB.Label Label5 
            Caption         =   "Black"
            Height          =   255
            Left            =   240
            TabIndex        =   45
            Top             =   600
            Width           =   495
         End
         Begin VB.Label Label4 
            Caption         =   "White"
            Height          =   255
            Left            =   240
            TabIndex        =   44
            Top             =   240
            Width           =   495
         End
      End
      Begin VB.Frame fraPlayers 
         Caption         =   "Players"
         Height          =   975
         Left            =   120
         TabIndex        =   16
         Top             =   240
         Width           =   3255
         Begin VB.TextBox txtNameBlack 
            Height          =   285
            Left            =   720
            MaxLength       =   15
            TabIndex        =   20
            Text            =   "BLACK"
            Top             =   600
            Width           =   2295
         End
         Begin VB.TextBox txtNameWhite 
            Height          =   285
            Left            =   720
            MaxLength       =   15
            TabIndex        =   19
            Text            =   "WHITE"
            Top             =   240
            Width           =   2295
         End
         Begin VB.Label lblNameBlack 
            Caption         =   "Black"
            Height          =   255
            Left            =   240
            TabIndex        =   18
            Top             =   600
            Width           =   495
         End
         Begin VB.Label lblNameWhite 
            Caption         =   "White"
            Height          =   255
            Left            =   240
            TabIndex        =   17
            Top             =   240
            Width           =   495
         End
      End
      Begin VB.CommandButton cmdOptionsOK 
         Caption         =   "Clock"
         Height          =   495
         Left            =   4200
         TabIndex        =   11
         Top             =   1440
         Width           =   975
      End
      Begin VB.Frame fraTimeControls 
         Caption         =   "Time Controls"
         Height          =   1095
         Left            =   120
         TabIndex        =   14
         Top             =   1320
         Width           =   3975
         Begin VB.OptionButton optStandard 
            Caption         =   "Standard"
            Height          =   255
            Left            =   240
            TabIndex        =   26
            Top             =   720
            Width           =   1095
         End
         Begin VB.OptionButton optBlitz 
            Caption         =   "Blitz /"
            Height          =   255
            Left            =   240
            TabIndex        =   15
            Top             =   240
            Value           =   -1  'True
            Width           =   855
         End
         Begin VB.Frame fraStandard 
            BorderStyle     =   0  'None
            Height          =   855
            Left            =   1320
            TabIndex        =   27
            Top             =   120
            Width           =   2535
            Begin VB.TextBox txtStandardSD 
               Alignment       =   1  'Right Justify
               Height          =   285
               Left            =   1560
               MaxLength       =   2
               TabIndex        =   38
               Text            =   "30"
               Top             =   480
               Width           =   495
            End
            Begin VB.TextBox txtStandardMins 
               Alignment       =   1  'Right Justify
               Height          =   285
               Left            =   1440
               MaxLength       =   3
               TabIndex        =   29
               Text            =   "90"
               Top             =   120
               Width           =   495
            End
            Begin VB.TextBox txtStandardMoves 
               Alignment       =   1  'Right Justify
               Height          =   285
               Left            =   120
               MaxLength       =   2
               TabIndex        =   28
               Text            =   "30"
               Top             =   120
               Width           =   495
            End
            Begin VB.Label Label6 
               Caption         =   "remaining moves in"
               Height          =   255
               Left            =   120
               TabIndex        =   40
               Top             =   480
               Width           =   1455
            End
            Begin VB.Label Label3 
               Caption         =   "mins"
               Height          =   255
               Left            =   2160
               TabIndex        =   39
               Top             =   480
               Width           =   375
            End
            Begin VB.Label lblStandardMins 
               Caption         =   "mins"
               Height          =   255
               Left            =   2040
               TabIndex        =   31
               Top             =   120
               Width           =   375
            End
            Begin VB.Label lblStandardMoves 
               Caption         =   "moves in"
               Height          =   255
               Left            =   720
               TabIndex        =   30
               Top             =   120
               Width           =   735
            End
         End
         Begin VB.Frame fraBlitz 
            BorderStyle     =   0  'None
            Height          =   855
            Left            =   1320
            TabIndex        =   21
            Top             =   120
            Width           =   2535
            Begin VB.TextBox txtBlitzSecs 
               Alignment       =   1  'Right Justify
               Height          =   285
               Left            =   120
               MaxLength       =   2
               TabIndex        =   24
               Text            =   "0"
               Top             =   480
               Width           =   495
            End
            Begin VB.TextBox txtBlitzMins 
               Alignment       =   1  'Right Justify
               Height          =   285
               Left            =   120
               MaxLength       =   2
               TabIndex        =   22
               Text            =   "5"
               Top             =   120
               Width           =   495
            End
            Begin VB.Label lblIncrementSecs 
               Caption         =   "secs increment"
               Height          =   255
               Left            =   720
               TabIndex        =   25
               Top             =   480
               Width           =   1455
            End
            Begin VB.Label lblIncrementMins 
               Caption         =   "mins"
               Height          =   255
               Left            =   720
               TabIndex        =   23
               Top             =   120
               Width           =   375
            End
         End
         Begin VB.Label Label9 
            Caption         =   "Increment"
            Height          =   255
            Left            =   480
            TabIndex        =   49
            Top             =   480
            Width           =   975
         End
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim minsWhite As Integer, secsWhite As Integer, milliWhite As Integer
Dim minsBlack As Integer, secsBlack As Integer, milliBlack As Integer
Dim SecsIncrement As Integer
Dim NumberOfMoves As Integer, MinsRemaining As Integer
Dim MovesWhite As Integer, MovesBlack As Integer
Dim GameOn As Boolean

Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer) As Integer

Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Integer) As Integer
Dim VK_WHITE As Integer
Dim VK_BLACK As Integer
Dim VirtualKey(5) As Integer
Dim KeyLabel(5) As String

Private Sub cboHotkeyBlack_Click()
    VK_BLACK = VirtualKey(cboHotkeyBlack.ListIndex)
    lblHotkeyBlack.Caption = KeyLabel(cboHotkeyBlack.ListIndex)
End Sub

Private Sub cboHotkeyWhite_Click()
    VK_WHITE = VirtualKey(cboHotkeyWhite.ListIndex)
    lblHotkeyWhite.Caption = KeyLabel(cboHotkeyWhite.ListIndex)
End Sub

Private Sub cmdEndGame_Click()
    Dim whitesTurn As Boolean
    If tmrWhite.Enabled = True Then
        tmrWhite.Enabled = False
        whitesTurn = True
    Else 'If tmrBlack.Enabled = True Then
        tmrBlack.Enabled = False
        whitesTurn = False
    End If
    Dim response As Integer
    response = MsgBox("Are you sure?", vbQuestion + vbYesNo, "End Game")
    If response = vbYes Then
        cmdEndGame.Enabled = False
        tmrWhite.Enabled = False
        tmrBlack.Enabled = False
        GameOn = False
        cmdStartGame.Enabled = True
        cmdStartGame.Caption = "New Game"
        Call UnHighlightWhite
        Call UnHighlightBlack
    ElseIf GameOn = True Then 'If response = vbNo Then
        If whitesTurn = True Then
            tmrWhite.Enabled = True
        Else
            tmrBlack.Enabled = True
        End If
    End If
End Sub

Private Sub cmdExit_Click()
    Unload Me
    End
End Sub

Private Sub cmdOptionsOK_Click()
    lblPlayerWhite.Caption = txtNameWhite.Text
    lblPlayerBlack.Caption = txtNameBlack.Text
    If optBlitz.Value = True Then
        If CInt(txtBlitzMins.Text) > 0 And cboHotkeyWhite.ListIndex <> cboHotkeyBlack.ListIndex Then
                minsWhite = CInt(txtBlitzMins.Text)
                minsBlack = minsWhite
                SecsIncrement = CInt(txtBlitzSecs.Text)
                fraClock.Visible = True
                fraOptions.Visible = False
                Call PrintClockWhite(minsWhite, secsWhite)
                Call PrintClockBlack(minsBlack, secsBlack)
                Me.Caption = "Chess Clock" & " - " & minsWhite & " " & SecsIncrement
        Else
            MsgBox "Invalid time settings or players using the same hotkey", vbCritical + vbOKOnly, "Error"
        End If
    Else 'If optStandard.Value = True Then
        If CInt(txtStandardMoves.Text) > 0 And CInt(txtStandardMins.Text) > 0 And CInt(txtStandardSD.Text) > 0 And cboHotkeyWhite.ListIndex <> cboHotkeyBlack.ListIndex Then
                minsWhite = CInt(txtStandardMins.Text)
                minsBlack = minsWhite
                NumberOfMoves = CInt(txtStandardMoves.Text)
                MinsRemaining = CInt(txtStandardSD.Text)
                fraClock.Visible = True
                fraOptions.Visible = False
                Call PrintClockWhite(minsWhite, secsWhite)
                Call PrintClockBlack(minsBlack, secsBlack)
                Me.Caption = "Chess Clock" & " - " & NumberOfMoves & "/" & minsWhite & " , " & "SD/" & MinsRemaining
        Else
            MsgBox "Invalid time settings or players using the same hotkey", vbCritical + vbOKOnly, "Error"
        End If
    End If
End Sub

Private Sub cmdOptions_Click()
    fraClock.Visible = False
    fraOptions.Visible = True
    Me.Caption = "Chess Clock"
End Sub

Private Sub cmdStartGame_Click()
    If cmdStartGame.Caption = "Start Game" Then
        cmdStartGame.Enabled = False
        cmdOptions.Enabled = False
        cmdEndGame.Enabled = True
        tmrWhite.Enabled = True
        GameOn = True
        Call HighlightWhite
    Else 'if cmdStartGame.Caption = "New Game" Then
        cmdStartGame.Caption = "Start Game"
        lblClockWhite.Alignment = 1
        lblClockBlack.Alignment = 1
        lblMilliWhite.Visible = True
        lblMilliBlack.Visible = True
        Call Form_Activate
    End If
End Sub

Private Sub cmdBlackPress_Click()
    PlayWaveRes "SWITCH"
    MovesBlack = MovesBlack + 1
    Call PrintMovesBlack(MovesBlack)
    If optBlitz.Value = True Then
        If (secsBlack + SecsIncrement) > 59 Then
            secsBlack = (secsBlack + SecsIncrement) - 60
            minsBlack = minsBlack + 1
        Else
            secsBlack = secsBlack + SecsIncrement
        End If
    Else 'If optStandard.Value = True Then
        If MovesBlack = NumberOfMoves Then
            minsBlack = minsBlack + MinsRemaining
        End If
    End If
    Call PrintClockBlack(minsBlack, secsBlack)
    tmrWhite.Enabled = True
    tmrBlack.Enabled = False
    Call HighlightWhite
    Call UnHighlightBlack
End Sub

Private Sub cmdWhitePress_Click()
    PlayWaveRes "SWITCH"
    MovesWhite = MovesWhite + 1
    Call PrintMovesWhite(MovesWhite)
    If optBlitz.Value = True Then
        If (secsWhite + SecsIncrement) > 59 Then
            secsWhite = (secsWhite + SecsIncrement) - 60
            minsWhite = minsWhite + 1
        Else
            secsWhite = secsWhite + SecsIncrement
        End If
    Else 'If optStandard.Value = True Then
        If MovesWhite = NumberOfMoves Then
            minsWhite = minsWhite + MinsRemaining
        End If
    End If
    Call PrintClockWhite(minsWhite, secsWhite)
    tmrWhite.Enabled = False
    tmrBlack.Enabled = True
    Call HighlightBlack
    Call UnHighlightWhite
End Sub

Private Sub Form_Activate()
    milliWhite = 0
    milliBlack = milliWhite
    Call PrintMilliWhite(milliWhite)
    Call PrintMilliBlack(milliBlack)
    If optBlitz.Value = True Then
        fraBlitz.Visible = True
        fraStandard.Visible = False
        minsWhite = CInt(txtBlitzMins.Text)
    Else 'If optStandard.Value = True Then
        fraBlitz.Visible = False
        fraStandard.Visible = True
        minsWhite = CInt(txtStandardMins.Text)
    End If
    secsWhite = 0
    minsBlack = minsWhite
    secsBlack = secsWhite
    Call PrintClockWhite(minsWhite, secsWhite)
    Call PrintClockBlack(minsBlack, secsBlack)
    MovesWhite = 0
    MovesBlack = 0
    Call PrintMovesWhite(MovesWhite)
    Call PrintMovesBlack(MovesBlack)
    tmrWhite.Enabled = False
    tmrBlack.Enabled = False
    Call UnHighlightWhite
    Call UnHighlightBlack
    cmdOptions.Enabled = True
    SecsIncrement = CInt(txtBlitzSecs.Text)
    cmdEndGame.Enabled = False
End Sub

Private Sub Form_Load()
    If App.PrevInstance Then End
    SetWindowPos frmMain.hWnd, -1, 0, 0, 0, 0, 2 Or 1
    
    VirtualKey(0) = &H25
    VirtualKey(1) = &H27
    VirtualKey(2) = &H11
    VirtualKey(3) = &H10
    VirtualKey(4) = &H5A
    VirtualKey(5) = &H4D
    
    KeyLabel(0) = "<--"
    KeyLabel(1) = "-->"
    KeyLabel(2) = "Ctrl"
    KeyLabel(3) = "Shift"
    KeyLabel(4) = "Z"
    KeyLabel(5) = "M"
    
    Dim i As Integer
    For i = 0 To 5
        cboHotkeyWhite.AddItem KeyLabel(i)
        cboHotkeyBlack.AddItem KeyLabel(i)
    Next i
    cboHotkeyWhite.ListIndex = 0
    cboHotkeyBlack.ListIndex = 1
    VK_WHITE = VirtualKey(cboHotkeyWhite.ListIndex)
    VK_BLACK = VirtualKey(cboHotkeyBlack.ListIndex)
    fraClock.Visible = False
    fraOptions.Visible = True
    GameOn = False
End Sub

Private Sub optBlitz_Click()
    fraBlitz.Visible = True
    fraStandard.Visible = False
End Sub

Private Sub optStandard_Click()
    fraBlitz.Visible = False
    fraStandard.Visible = True
End Sub

Private Sub tmrBlack_Timer()
    If milliBlack > 0 Then
        milliBlack = milliBlack - 1
        Call PrintMilliBlack(milliBlack)
    Else
        milliBlack = 10
        If secsBlack > 0 Then
            secsBlack = secsBlack - 1
        Else
            minsBlack = minsBlack - 1
            secsBlack = 59
        End If
        Call PrintClockBlack(minsBlack, secsBlack)
    End If
End Sub

Private Sub tmrListen_Timer()
    If GetAsyncKeyState(VK_BLACK) Then
        If tmrBlack.Enabled = True Then
            Call cmdBlackPress_Click
        End If
    ElseIf GetAsyncKeyState(VK_WHITE) Then
        If tmrWhite.Enabled = True Then
            Call cmdWhitePress_Click
        End If
    End If
End Sub

Private Sub tmrWhite_Timer()
    If milliWhite > 0 Then
        milliWhite = milliWhite - 1
        Call PrintMilliWhite(milliWhite)
    Else
        milliWhite = 10
        If secsWhite > 0 Then
            secsWhite = secsWhite - 1
        Else
            minsWhite = minsWhite - 1
            secsWhite = 59
        End If
        Call PrintClockWhite(minsWhite, secsWhite)
    End If
End Sub

Private Sub PrintClockWhite(minsWhite As Integer, secsWhite As Integer)
    If minsWhite = -1 And secsWhite = 59 Then
        lblClockWhite.Alignment = 2
        lblClockBlack.Alignment = 2
        lblClockWhite.Caption = "   0"
        lblClockBlack.Caption = "   1"
        lblMilliWhite.Visible = False
        lblMilliBlack.Visible = False
        tmrWhite.Enabled = False
        GameOn = False
        PlayWaveRes "END"
    Else
        lblClockWhite.Caption = Format(minsWhite, "00") & ":" & Format(secsWhite, "00")
    End If
End Sub

Private Sub PrintClockBlack(minsBlack As Integer, secsBlack As Integer)
    If minsBlack = -1 And secsBlack = 59 Then
        lblClockWhite.Alignment = 2
        lblClockBlack.Alignment = 2
        lblClockWhite.Caption = "   1"
        lblClockBlack.Caption = "   0"
        lblMilliWhite.Visible = False
        lblMilliBlack.Visible = False
        tmrBlack.Enabled = False
        GameOn = False
        PlayWaveRes "END"
    Else
        lblClockBlack.Caption = Format(minsBlack, "00") & ":" & Format(secsBlack, "00")
    End If
End Sub

Private Sub UnHighlightWhite()
    shpHighlightWhite.FillColor = vbWhite
    lblPlayerWhite.ForeColor = vbBlack
    lblClockWhite.ForeColor = vbBlack
    lblMilliWhite.ForeColor = vbBlack
End Sub

Private Sub UnHighlightBlack()
    shpHighlightBlack.FillColor = vbWhite
    lblPlayerBlack.ForeColor = vbBlack
    lblClockBlack.ForeColor = vbBlack
    lblMilliBlack.ForeColor = vbBlack
End Sub
Private Sub HighlightWhite()
    shpHighlightWhite.FillColor = vbBlack
    lblPlayerWhite.ForeColor = vbWhite
    lblClockWhite.ForeColor = vbWhite
    lblMilliWhite.ForeColor = vbWhite
End Sub
Private Sub HighlightBlack()
    shpHighlightBlack.FillColor = vbBlack
    lblPlayerBlack.ForeColor = vbWhite
    lblClockBlack.ForeColor = vbWhite
    lblMilliBlack.ForeColor = vbWhite
End Sub

Private Sub PrintMilliWhite(milliWhite As Integer)
    lblMilliWhite.Caption = "." & CStr(milliWhite)
End Sub

Private Sub PrintMilliBlack(milliBlack As Integer)
    lblMilliBlack.Caption = "." & CStr(milliBlack)
End Sub

Private Sub PrintMovesWhite(MovesWhite As Integer)
    lblMovesWhite.Caption = CStr(MovesWhite)
End Sub

Private Sub PrintMovesBlack(MovesBlack As Integer)
    lblMovesBlack.Caption = CStr(MovesBlack)
End Sub

Private Sub txtBlitzMins_GotFocus()
    Call AutoSelect(Me.ActiveControl)
End Sub

Private Sub txtBlitzMins_KeyPress(KeyAscii As Integer)
    Call NumericTextbox(KeyAscii)
End Sub

Private Sub txtBlitzSecs_GotFocus()
    Call AutoSelect(Me.ActiveControl)
End Sub

Private Sub txtBlitzSecs_KeyPress(KeyAscii As Integer)
    Call NumericTextbox(KeyAscii)
End Sub

Private Sub txtNameBlack_GotFocus()
    Call AutoSelect(Me.ActiveControl)
End Sub

Private Sub txtNameWhite_GotFocus()
    Call AutoSelect(Me.ActiveControl)
End Sub

Private Sub txtStandardMins_GotFocus()
    Call AutoSelect(Me.ActiveControl)
End Sub

Private Sub txtStandardMins_KeyPress(KeyAscii As Integer)
    Call NumericTextbox(KeyAscii)
End Sub

Private Sub txtStandardMoves_GotFocus()
    Call AutoSelect(Me.ActiveControl)
End Sub

Private Sub txtStandardMoves_KeyPress(KeyAscii As Integer)
    Call NumericTextbox(KeyAscii)
End Sub

Private Sub txtStandardSD_GotFocus()
    Call AutoSelect(Me.ActiveControl)
End Sub

Private Sub txtStandardSD_KeyPress(KeyAscii As Integer)
    Call NumericTextbox(KeyAscii)
End Sub

Private Sub NumericTextbox(KeyAscii)
    Select Case KeyAscii
        Case 48 To 57, 8
        Case Else
            KeyAscii = 0
    End Select
End Sub

Private Sub AutoSelect(This As TextBox)
    This.SelStart = 0
    This.SelLength = Len(This.Text)
End Sub
