// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997  
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Program used to test the file locking primitives.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "gxdbase.h"
#include "gxdstats.h"

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void ClearInputStream(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void Menu()
{
  cout << endl;
  cout << "(c, C)   Clear the file lock header" << endl;
  cout << "(h, H)   Help (prints this menu)" << endl;
  cout << "(p)      Toggle the file lock protect" << endl;
  cout << "(P)      Reset the file lock protect" << endl;   
  cout << "(q, Q)   Quit this program" << endl;
  cout << "(r)      Read lock the file" << endl;
  cout << "(R)      Relase the read lock" << endl;
  cout << "(s, S)   Display the file stats" << endl;
  cout << "(w)      Write lock the file" << endl;
  cout << "(W)      Relase the write lock" << endl;
  cout << endl;
}

void DisplayLockValues(gxFileLockHeader &flh)
{
  cout << "File Lock Protect:     " << (int)flh.file_lock_protect << endl;
  cout << "File Read Lock Value:  " << (int)flh.file_read_lock << endl;
  cout << "File Write Lock Value: " << (int)flh.file_write_lock << endl; 
}

int main()
{
  gxDatabase *f = new gxDatabase; 
  cout << "Creating new file..." << endl;
  const char *fname = "testfile.gxd";

  if(!gxDatabase::Exists(fname)) {
    cout << "Creating new file..." << endl;
    f->Create(fname);
    if(CheckError(f) != 0) return 1;
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(fname);
    if(CheckError(f) != 0) return 1;
  }
  
  char key;
  Menu();
  int rv = 1;
  gxFileLockHeader lh;
  gxUINT32 lock_protect;

  while(rv) {
    if (!cin) { 
      ClearInputStream(cin); 
      if (!cin) {  
	cout << "Input stream error" << endl;
	return 0;
      }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue;
    switch(key) {
      case '?' : Menu(); break;
      case 'c' : case 'C' : f->ResetFileLock(); break;
      case 'h' : case 'H' : Menu(); break;
      case 'q' : case 'Q' : rv = 0; break;
      case 's' : case 'S' : DatabaseStats(f); break;
      case 'p' : 
	lock_protect = 1;
	f->Write(&lock_protect, sizeof(gxUINT32), sizeof(gxFileHeader));
	CheckError(f);
	f->ReadFileLockHdr(lh);
	DisplayLockValues(lh);
	break;
      case 'P' : 
	lock_protect = (gxUINT32)0;
	f->Write(&lock_protect, sizeof(gxUINT32), sizeof(gxFileHeader));
	CheckError(f);
	f->ReadFileLockHdr(lh);
	DisplayLockValues(lh);
	break;
      case 'r' : 
	f->LockFile(gxDBASE_READLOCK);
	CheckError(f);
	f->ReadFileLockHdr(lh);
	DisplayLockValues(lh);
	break;
      case 'R' : 
	f->UnlockFile(gxDBASE_READLOCK);
	CheckError(f);
	f->ReadFileLockHdr(lh);
	DisplayLockValues(lh);
	break;
      case 'w' : 
	f->LockFile(gxDBASE_WRITELOCK);
	CheckError(f);
	f->ReadFileLockHdr(lh);
	DisplayLockValues(lh);
	break;
      case 'W' : 
	f->UnlockFile(gxDBASE_WRITELOCK);
	CheckError(f);
	f->ReadFileLockHdr(lh);
	DisplayLockValues(lh);
	break;
      default:
        cout << "Unrecognized command" << endl;
	break;
    }
  }

  cout << "Exiting..." << endl;
  f->Close();
  if(CheckError(f) != 0) return 1;
  delete f;
  
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
