// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: gxdfp64.h 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxDatabase 64-bit file helpers are a collection of classes 
and standalone functions used to support large files on multiple
target platforms. NOTE: None of the data structures and 
functions defined are intended to be used directly. They are
used by the gxDatabase class to call the correct native 
64-bit file API function for each supported platform. 

NOTE: Currently 64-bit support is limited in the DataReel library to
Windows NT, RedHat 6.2, HPUX 11.0 and Solaris 2.8 platforms, with
HPUX 11.0 supporting a maximum single file size of 128 GB. As
large file support and 64-bit operating systems become more
prevalent support will be included for all the platforms supported
by the 32-bit database engine. 

The 64-bit UNIX API is based on the non-POSIX standard UNIX API
interfaces to support large files:

::fopen64()
::fseeko64()
::ftello64()
::stat64()

NOTE: Since these functions are not part of the POSIX standard
they may be removed in future compiler versions.
*/
// ----------------------------------------------------------- //  
#ifndef __GX_DATABASE_FILE_POINTER_64_HPP__
#define __GX_DATABASE_FILE_POINTER_64_HPP__

#if defined (__64_BIT_DATABASE_ENGINE__)

// Non-platform specific include files
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "gxdtypes.h"
#include "gxheader.h"

// Platform specific include files
#if defined (__WIN32__)
#include <io.h>
#elif defined (__UNIX__)
// NOTE: Place specific UNIX variants above this directive.
#include <unistd.h> // UNIX standard function definitions
#else
#error You must define a target platform: __WIN32__ or __UNIX__
#endif

// Platform specific file pointer type
struct gxdFPTR64 {
#if defined (__WIN32__) && defined (__MSVC__)
  // NOTE: Large files cannot be created on Windows 95/98 platforms.
  // Executables produced by MSVC 4.2 and higher have been tested
  // under Windows NT 4.0
  int fptr;
#elif defined (__WIN32__) && defined (__BCC32__)
  // NOTE: BCC32 5.5 does not support large files.
#error GXD large file support for BCC32 is not implemented
#elif defined (__UNIX__) && defined (__LINUX__)
  // NOTE: Large file support for Linux is supported by RedHat
  // Linux 6.2 and higher.
  FILE *fptr;
#elif defined (__UNIX__) && defined (__HPUX__)
  FILE *fptr;
#elif defined (__UNIX__) && defined (__SOLARIS__)
  FILE *fptr;
#else
#error You must define a target platform and/or compiler
#endif
};

// NOTE: Any underlying 64-bit file system used must provide the basic
// functionallity defined here.
gxdFPTR64 *gxdFPTR64Create(const char *fname);
gxdFPTR64 *gxdFPTR64Open(const char *fname, gxDatabaseAccessMode mode);
int gxdFPTR64Close(gxdFPTR64 *stream);
int gxdFPTR64Flush(gxdFPTR64 *stream);
int gxdFPTR64Read(gxdFPTR64 *stream, void *buf, __UWORD__ bytes);
int gxdFPTR64Write(gxdFPTR64 *stream, const void *buf, __UWORD__ bytes);
__LLWORD__ gxdFPTR64Seek(gxdFPTR64 *stream, __LLWORD__,
			 gxDatabaseSeekMode mode);
__LLWORD__ gxdFPTR64Tell(gxdFPTR64 *stream);
int gxdFPTR64Exists(const char *fname);
__LLWORD__ gxdFPTR64FileSize(const char *fname);

#endif // __64_BIT_DATABASE_ENGINE__

#endif // __GX_DATABASE_FILE_POINTER_64_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
