// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: strutil.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 12/16/1997 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The string utilities are a collection of data structures and 
standalone functions used to manipulate and parse null terminated 
character strings.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <ctype.h>
#include "strutil.h"

char *StringCat(const char *s1, const char *s2, const char *s3)
{
  int len = strlen(s1) + strlen(s2) + strlen(s3);
  char *comp = new char[len+1];
  comp[len] = '\0';
  strcpy(comp, s1);
  strcat(comp, s2);
  strcat(comp, s3);
  return comp;
}

char *StringCat(char *s1, char *s2, char *s3)
{
  int len = strlen(s1) + strlen(s2) + strlen(s3);
  char *comp = new char[len+1];
  comp[len] = '\0';
  strcpy(comp, s1);
  strcat(comp, s2);
  strcat(comp, s3);
  return comp;
}

int parse(char *string, char words[MAXWORDS][MAXWORDLENGTH],
	  int *numwords, char sepchar)
// General purpose string parser
{
  int i = 0;
  char newword[MAXWORDLENGTH];
  *numwords = 0;

  // First skip over leading blanks. Stop if an ASCII NULL is seen
  while (1) {
    if (*string == '\0') return 0;
    if (*string != ' ') break;
    string++;
  }
  
  while(1) {
    // Check to see if there is room for another word in the array
    if(*numwords == MAXWORDS) return 1;

    i = 0;
    while (i < MAXWORDLENGTH) {
      if(*string == 0 || *string == sepchar) break;
      newword[i] = *string;
      string++;
      i++;
    }
    newword[i] = 0;   // Ensure an ASCII null at end of newword. 
    strcpy (words[*numwords], newword);  // Install into array 
    (*numwords)++;
    
    // If stopped by an ASCII NULL above, exit loop
    if(*string == 0) break;
    
    string++;
    if(*string == 0) break;
  }
  return 0;
}

int CaseICmp(const char *s1, const char *s2)
// Compare two strings without regard to the case of the letters
{
#if defined (__DOS__) || defined (__WIN32__)
  // Case-insensitive compare for most DOS/Windows Compilers
  return stricmp(s1, s2);
#elif defined(__VISUALC__) || ( defined(__MWERKS__) && defined(__INTEL__) )
  return stricmp(s1, s2);
#elif defined(__SC__)
  return stricmp(s1, s2);
#elif defined(__SALFORDC__)
  return stricmp(s1, s2);
#elif defined(__BORLANDC__)
  return stricmp(s1, s2);
#elif defined(__WATCOMC__)
  return stricmp(s1, s2);
#elif defined (__UNIX__) || defined(__GNUWIN32__)
  // Case-insensitive compare for most UNIX Compilers
  return strcasecmp(s1, s2);
#else
    register char c1, c2;
    do {
      c1 = tolower(*s1++);
      c2 = tolower(*s2++);
    } while ( c1 && (c1 == c2) );

    return c1 - c2;
#endif 
}

int CaseICmp(char *s1, char *s2)
// Compare two strings without regard to the case of the letters
{
#if defined (__DOS__) || defined (__WIN32__)
  // Case-insensitive compare for most DOS/Windows Compilers
  return stricmp(s1, s2);
#elif defined(__VISUALC__) || ( defined(__MWERKS__) && defined(__INTEL__) )
  return stricmp(s1, s2);
#elif defined(__SC__)
  return stricmp(s1, s2);
#elif defined(__SALFORDC__)
  return stricmp(s1, s2);
#elif defined(__BORLANDC__)
  return stricmp(s1, s2);
#elif defined(__WATCOMC__)
  return stricmp(s1, s2);
#elif defined (__UNIX__) || defined(__GNUWIN32__)
  // Case-insensitive compare for most UNIX Compilers
  return strcasecmp(s1, s2);
#else
    register char c1, c2;
    do {
      c1 = tolower(*s1++);
      c2 = tolower(*s2++);
    } while ( c1 && (c1 == c2) );

    return c1 - c2;
#endif 
}

unsigned FindMatch(const char *str, const char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset.
// Returns index of first occurrence of matching pattern or -1
// if no match is found.
{
  char *Start = (char *)str + offset; // Start of string data
  char *Next = Start;                 // Next string element
  char *Pattern = (char *)p;          // Next pattern element
  unsigned i = offset;                // Next string element index
  unsigned Len = strlen(str);
  
  while(i < Len && *Pattern) {
    if (*Next == *Pattern) {
      Pattern++;
      if(*Pattern == 0) return i; // Pattern was found
      Next++;
    }
    else {
      i++;
      Start++;
      Next = Start;
      Pattern = (char *)p;
    }
  }
  return -1; // No match was found
}

unsigned FindMatch(char *str, char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset.
// Returns index of first occurrence of matching pattern or -1
// if no match is found.
{
  return FindMatch((const char *)str, (const char *)p, offset);
}

unsigned IFindMatch(const char *str, const char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset
// using a case insensitive compare. Returns index of first 
// occurrence of matching pattern or -1 if no match is found.
{
  char *Start = (char *)str + offset; // Start of string data
  char *Next = Start;                 // Next string element
  char *Pattern = (char *)p;          // Next pattern element
  unsigned i = offset;                // Next string element index
  unsigned Len = strlen(str);
  
  while(i < Len && *Pattern) {
    if (tolower(*Next) == tolower(*Pattern)) {
      Pattern++;
      if(*Pattern == 0) return i; // Pattern was found
      Next++;
    }
    else {
      i++;
      Start++;
      Next = Start;
      Pattern = (char *)p;
    }
  }
  return -1; // No match was found
}

unsigned IFindMatch(char *str, char *p, unsigned offset)
// Finds pattern "p" in string "s" starting at specified offset
// using a case insensitive compare. Returns index of first 
// occurrence of matching pattern or -1 if no match is found.
{
  return IFindMatch((const char *)str, (const char *)p, offset);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
