// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/19/1996
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the gxConfig class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdio.h>
#include "gxconfig.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

// Data structure use to store program gxConfiguration values
struct ProgramgxConfig
{
  ProgramgxConfig() { // Set the default values
    s_val1 = "YES";
    s_val2 = "NO";
    s_val3 = "TRUE";
    s_val4 = "FALSE";
    i_val = 32768;
    l_val = 2147483647;
    d_val = 1.12345;
  }
  ProgramgxConfig(const ProgramgxConfig &ob) {
    s_val1 = ob.s_val1;
    s_val2 = ob.s_val2;
    s_val3 = ob.s_val3;
    s_val4 = ob.s_val4;
    i_val = ob.i_val; l_val = ob.l_val; d_val = ob.d_val;
  }

  gxString s_val1;
  gxString s_val2;
  gxString s_val3;
  gxString s_val4;
  int i_val;
  long l_val;
  double d_val; 
};

void pause()
{
  cin.get();
  cout << "Press enter to continue..." << endl;
  cout << endl;
}

void DisplayConfig(gxConfig *CfgData, ProgramgxConfig *cfg)
// Display the program gxConfiguration and load gxConfig values
{
  char *s1 = CfgData->GetStrValue("String1");
  if(!s1) {
    cout << "String1 section missing from gxConfig file" << endl;
  }
  else {
    cout << "String1 section of gxConfig file = " << s1 << endl;
    cfg->s_val1 = s1;
  }

  char *s2 = CfgData->GetStrValue("String2");
  if(!s2) {
    cout << "String2 section missing from gxConfig file" << endl;
  }
  else {
    cout << "String2 section of gxConfig file = " << s2 << endl;
    cfg->s_val2 = s2;
  }

  char *s3 = CfgData->GetStrValue("String3");
  if(!s3) {
    cout << "String3 section missing from gxConfig file" << endl;
  }
  else {
    cout << "String3 section of gxConfig file = " << s3 << endl;
    cfg->s_val3 = s3;
  }

  char *s4 = CfgData->GetStrValue("String4");
  if(!s4) {
    cout << "String4 section missing from gxConfig file" << endl;
  }
  else {
    cout << "String4 section of gxConfig file = " << s4 << endl;
    cfg->s_val4 = s4;
  }

  int i1 = CfgData->GetIntValue("Int");
  if(!i1) {
    cout << "Int section missing from gxConfig file" << endl;
  }
  else {
    cout << "Integer section of gxConfig file = " << i1 << endl;
    cfg->i_val = i1;
  }

  double d1 = CfgData->GetFloatValue("Float");
  if(!d1) {
    cout << "Float section missing from gxConfig file" << endl;
  }
  else {
    cout << "Floating Point number section of gxConfig file = "
	 << d1 << endl;
    cfg->d_val = d1;
  }
  
  long l1 = CfgData->GetLongValue("Long");
  if(!l1) {
    cout << "Long int section missing from gxConfig file" << endl;
  }
  else {
    cout << "Long int section of gxConfig file = " << l1 << endl;
    cfg->l_val = l1;
  }

  cout << endl;
}

void MultipleRead(gxConfig *CfgData)
{
  char *ServerName = CfgData->GetStrValue("ServerName");
  if(!ServerName) {
    cout << "ServerName value is not set in the gxConfig file" << endl;
    return;
  }
  else
    cout << "Server name = " << ServerName << endl;
  
  char *FullPathName = CfgData->GetStrValue("FullPathName0");
  if(!FullPathName) {
    cout << "No path names are set in the gxConfig file" << endl;
    return;
  }

  char cfgValue[255];
  long file_num = -1;
  
  while(1) {
    file_num++;
    sprintf(cfgValue, "FullPathName%d", file_num);
    char *buf = CfgData->GetStrValue(cfgValue);
    if(!buf) break;

    gxString sbuf(buf);
    unsigned offset = 0;
    unsigned index = 0;
    while(1) {
    offset = sbuf.Find("/", offset);
    if(offset != -1) index = offset;
    if(offset == -1) break;
    offset++;
    }
    if(index > 0) sbuf.DeleteAt(0, ++index);

    if(sbuf.length() == 0) {
      cout << "Invalid file name for " << cfgValue << endl;
      return;
    }
    
    cout << "Reading: " << buf << endl;
    cout << "Copying to: " << sbuf << endl;

    buf = 0;
    for(int i = 0; i < 255; i++) cfgValue[i] = 0;
  }
  cout << endl;
}

void NewParmID(gxConfig *CfgData)
{
  CfgData->UnLoad();
  CfgData->SetParmID("://");
  gxString parmName("http");
  CfgData->ReadComments();
  CfgData->ReLoad();
  
  gxConfigListNode *ptr = (gxConfigListNode *)CfgData->GetHead();
  while(ptr) { // Scan until end of list
    unsigned offset = 0;
    offset = ptr->node_data.Find(parmName);
    if(offset != -1) {
      gxConfigListNode *sptr = (gxConfigListNode *)ptr->next;
      gxString ServerName(sptr->node_data);
      gxString FullPathName(sptr->node_data);
      unsigned offset = ServerName.Find("/");
      if(offset != -1) {
	ServerName.DeleteAt(offset, (ServerName.length() - offset));
	FullPathName.DeleteAt(0, offset);
	cout << "Server: " << ServerName.c_str() << " Path: "
	     << FullPathName.c_str() << endl;
      }
    }
    ptr = (gxConfigListNode *)ptr->next;
  }
}

int main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  gxConfig *CfgData = new gxConfig;
  ProgramgxConfig *cfg = new ProgramgxConfig;
  int Status;

  // Test for all three overloads
  const char *fname = "gxConfig.ini";
  // char *fname = "gxconfig.ini";
  // gxString fname("gxConfig.ini");
  
  cout << "Loading gxConfig File..." << endl;
  Status = CfgData->Load(fname);
  if(!Status) {
    cout << "gxConfig file not found!" << endl;
    return 0;
  }
  else
    cout << "Processing file: " << CfgData->GetFileName() << endl;

  cout << endl;
  DisplayConfig(CfgData, cfg);
  ProgramgxConfig org_gxConfig(*cfg); // Record the original values
  
  cout << "Testing reload function" << endl;
  pause();
  CfgData->ReLoad(fname);
  DisplayConfig(CfgData, cfg);

  cout << "Writing new values to the file" << endl;
  pause();
  CfgData->ChangeConfigValue("String1", "no");
  CfgData->ChangeConfigValue("String2", "yes");
  CfgData->ChangeConfigValue("String3", "false");
  CfgData->ChangeConfigValue("String4", "true");
  
  CfgData->ChangeConfigValue("Float", 1.98712);
  CfgData->ChangeConfigValue("Int", 12345);
  CfgData->ChangeConfigValue("Long", 23889);
  DisplayConfig(CfgData, cfg);
  
  cout << "Restoring orignal values" << endl;
  pause();
  CfgData->ChangeConfigValue("String1", org_gxConfig.s_val1);
  CfgData->ChangeConfigValue("String2", org_gxConfig.s_val2);
  CfgData->ChangeConfigValue("String3", org_gxConfig.s_val3);
  CfgData->ChangeConfigValue("String4", org_gxConfig.s_val4);
  CfgData->ChangeConfigValue("Int", org_gxConfig.i_val);
  CfgData->ChangeConfigValue("Float", org_gxConfig.d_val);
  CfgData->ChangeConfigValue("Long", org_gxConfig.l_val);
  DisplayConfig(CfgData, cfg);

  cout << "Performing a multiple read and parsing operation" << endl;
  pause();
  MultipleRead(CfgData);

  cout << "Reloading the file with a new parameter ID string" << endl;
  pause();
  NewParmID(CfgData);
  
  CfgData->UnLoad();

  delete CfgData;
  delete cfg;
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
