// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxsocket.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 04/28/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

A very simple multi-threaded HTTP server built using the
gxThread library.
*/
// ----------------------------------------------------------- // 
#include "httpserv.h"
#include "string.h"

int gxHTTPServer::InitHTTPServer(int port, int max_connections)
// Initialize the HTTP server. Returns a non-zero value if any
// errors ocurr.
{
  if(InitSocketLibrary() == 0) {
    if(InitSocket(SOCK_STREAM, port) < 0) return 1;
  }
  else {
    return 1;
  }

  // Bind the name to the socket
  if(Bind() < 0) {
    Close();
    return 1;
  }
    
  // Listen for connections with a specifed backlog
  if(Listen(max_connections) < 0) {
    Close();
    return 1;
  }

  return 0;
}

int gxHTTPServer::RemotePortNumber(int &port)
// Pass back the port number actually set by the system
// in the "port" variable.
{
  port = GetRemotePortNumber();
  return 0;
}

int gxHTTPServer::HostName(char *hs)
{
  if(GetHostName(hs) < 0) {
    return 1;
  }
  return 0;
}

int gxHTTPServer::RemoteHostName(char *hs)
{
  if(GetRemoteHostName(hs) < 0) {
    return 1;
  }
  return 0;
}

void *gxHTTPServer::ThreadEntryRoutine(gxThread_t *thread)
// Client thread.
{
  const int rxbuf = 1024;
  char request[rxbuf];
  int rv = RawRemoteRead(request, rxbuf);
  request[rv] = 0; // Null terminate the buffer

  // At this point we need to parse the client request and process it.
  // For simplicity sake these operations have been omitted.
  // ... (parsing operation)
  // ... (processing operation)

  // Simply send a test page (with a header) back to the client.
  const char *test_page = "HTTP/1.0 200 OK\r\nServer: gxThread\r\nConnection: \
close\r\n\r\n<HTML>\n<HEAD>\n<TITLE> gxThread Test Page </TITLE>\n</HEAD>\
<BODY><CENTER><H1>gxThread Test Page</H1></CENTER><HR><PRE>Response from the \
multi-threaded HTTP server</PRE><HR><CENTER>End of document</CENTER>\n</BODY>\
\n</HTML>";

  RemoteSend(test_page, strlen(test_page));
  return 0;
}

void gxHTTPServer::ThreadExitRoutine(gxThread_t *thread)
// Thread exit function used to close the client thread.
{
  CloseRemoteSocket();
}

void gxHTTPServer::ThreadCleanupHandler(gxThread_t *thread)
// Thread cleanup handler used in the event that the thread is
// canceled.
{
  CloseRemoteSocket();
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
