// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/23/2001
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Test program for the embedded POP3 client class.
*/
// ----------------------------------------------------------- // 
#include "gxspop3.h"
#include <iostream.h>

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

int CheckError(gxsPOP3Client *pop3)
{
  if(pop3->GetSocketError() != gxSOCKET_NO_ERROR) {
    cout << pop3->SocketExceptionMessage() << endl << flush;
    if(pop3->reply_buf[0] != 0) { // Check the reply buffer
      cout << pop3->reply_buf << flush;
    }
    pop3->Close();
    return 0;
  }
  return 1; // No errors reported
}


void ClearInputStream(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void Menu()
{
  cout << endl;
  cout << "(c, C)    Reset connection" << endl;
  cout << "(d, D)    Delete a message" << endl;
  cout << "(h, H, ?) Display this menu" << endl;
  cout << "(l, L)    List message numbers" << endl;
  cout << "(r, R)    Retrieve a message" << endl;
  cout << "(t, T)    Retrieve a message header" << endl;   
  cout << "(q, Q)    Quit this program" << endl;
  cout << endl;
}

void Delete(gxsPOP3Client *pop3)
{
  int message_number = 1;
  cout << "Enter the message number> ";
  cin >> message_number;
  if(!cin) {
    cout << "Invalid input" << endl;
    return;
  }

  const int sbuf_size = 8192;
  char sbuf[sbuf_size];

  if(pop3->POP3Delete(message_number, sbuf, sbuf_size) != gxSOCKET_NO_ERROR) {
    cout << pop3->SocketExceptionMessage() << endl << flush;
    return;
  }

  sbuf[pop3->BytesRead()] = 0;
  cout << sbuf << flush;
}

void List(gxsPOP3Client *pop3)
{
  const int sbuf_size = 8192;
  char sbuf[sbuf_size];
  if(pop3->POP3List(sbuf, sbuf_size) != gxSOCKET_NO_ERROR) {
    cout << pop3->SocketExceptionMessage() << endl << flush;
    sbuf[pop3->BytesRead()] = 0;
    cout << sbuf << flush;
    return;
  }
  sbuf[pop3->BytesRead()] = 0;
  cout << sbuf << flush;
}

void Reset(gxsPOP3Client *pop3)
{
  if(pop3->POP3RSet() != gxSOCKET_NO_ERROR) {
    cout << pop3->SocketExceptionMessage() << endl << flush;
    cout << pop3->reply_buf << flush;
    return;
  }
  cout << pop3->reply_buf << flush;
}

void Retrieve(gxsPOP3Client *pop3)
{
  int message_number = 1;
  cout << "Enter the message number> ";
  cin >> message_number;
  if(!cin) {
    cout << "Invalid input" << endl;
    return;
  }

  const int sbuf_size = 8192;
  char sbuf[sbuf_size];
  if(pop3->POP3Retr(message_number, sbuf, sbuf_size) != gxSOCKET_NO_ERROR) {
    cout << pop3->SocketExceptionMessage() << endl << flush;
    return;
  }
  sbuf[pop3->BytesRead()] = 0;
  cout << sbuf << flush;
}

void Top(gxsPOP3Client *pop3)
{
  int message_number = 1;
  cout << "Enter the message number> ";
  cin >> message_number;
  if(!cin) {
    cout << "Invalid input" << endl;
    return;
  }

  const int sbuf_size = 8192;
  char sbuf[sbuf_size];
  if(pop3->POP3Top(message_number, sbuf, sbuf_size) != gxSOCKET_NO_ERROR) {
    cout << pop3->SocketExceptionMessage() << endl << flush;
    sbuf[pop3->BytesRead()] = 0;
    cout << sbuf << flush;
    return;
  }
  sbuf[pop3->BytesRead()] = 0;
  cout << sbuf << flush;
}

int main(int argc, char **argv)
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  if(argc < 4) {
    cout << "Usage: " << argv[0] << " server username password" << endl;
    cout << "server   = Your POP3 mail server" << endl;
    cout << "username = Your POP3 account user name" << endl;
    cout << "username = Your POP3 account password" << endl;
    cout << endl;
    cout << "Example: " << argv[0] 
	 << " popserver.xyz.com myname mypassword" << endl;
    return 1;
  }
  char *server = argv[1];
  char *username = argv[2];
  char *password = argv[3];
 
  gxsPOP3Client pop3;

  cout << "Connecting to the POP3 server" << endl;
  pop3.ConnectClient((const char *)server);
  if(!CheckError(&pop3)) return 1;
  cout << pop3.reply_buf << flush;

  pop3.POP3Login((const char *)username, (const char *)password);
  if(!CheckError(&pop3)) return 1;
  cout << pop3.reply_buf << flush;

  char key;
  Menu();
  int rv = 1;

  while(rv) {
    if (!cin) { 
      ClearInputStream(cin); 
      if (!cin) {  
	cout << "Input stream error" << endl;
	return 0;
      }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue;
    switch(key) {
      case '?' : Menu(); break;
      case 'h' : case 'H' : Menu(); break;
      case 'q' : case 'Q' : rv = 0; break;
      case 'C' : case 'c' : ClearInputStream(cin); Reset(&pop3); break;
      case 'd' : case 'D' : ClearInputStream(cin); Delete(&pop3); break;
      case 'l' : case 'L' : ClearInputStream(cin); List(&pop3); break;
      case 'r' : case 'R' : ClearInputStream(cin); Retrieve(&pop3); break;
      case 't' : case 'T' : ClearInputStream(cin); Top(&pop3); break;
      default:
        cout << "Unrecognized command" << endl;
	break;
    }
  }

  pop3.POP3Logout();
  if(!CheckError(&pop3)) return 1;
  cout << pop3.reply_buf << flush;

  pop3.Close();
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
