// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: gxshttp.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

HTTP client/server constants and data structures shared between
HTTP client and server applications.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_HTTP_HPP__
#define __GX_HTTP_HPP__

// --------------------------------------------------------------
// Include files
// --------------------------------------------------------------
#include "gxstring.h"
#include "gxlist.h"
// --------------------------------------------------------------

// --------------------------------------------------------------
// Constants 
// --------------------------------------------------------------
// Total number of HTTP connection methods. This value must match
// the number constants defeined in the "Methods" enumeration.
const int gxsMAX_HTTP_METHODS = 8;

// Total number of HTTP status codes. This value must match the number
// constants defeined in the "Status Codes" enumeration.
const int gxsMAX_HTTP_STATUS_CODES = 17;
// --------------------------------------------------------------

// --------------------------------------------------------------
// Enumerations
// --------------------------------------------------------------
enum { // HTTP methods enumeration

  gxHTTP_UNKNOWN = 0, // Used for internal processing
  
  // HTTP/1.0 Client/Server Methods
  gxsHTTP_GET,        // Retrieve whatever data is identified by the URI
  gxsHTTP_HEAD,       // Returns only HTTP headers and no document body 
  gxsHTTP_PUT,        // Store the data under the supplied URL
  gxsHTTP_DELETE,     // Delete the information corresponding to the given URL
  gxsHTTP_POST,       // Creates a new object linked to the specified object 
  gxsHTTP_LINK,       // Links an existing object to the specified object 
  gxsHTTP_UNLINK      // Removes link information from an object 
};

enum { // HTTP status codes enumeration

  gxsHTTP_STATUS_UNKNOWN = 0, // Used for internal processing
  
  // HTTP/1.0 Status Codes obtained from:
  // http://sifu.rindu.net/course/one/freesoft/CIE/RFC/1945/1.htm

  // 1xx: Informational - Not used, but reserved for future use.

  // 2xx: Success - The action was successfully received, understood,
  // and accepted. 
  gxsHTTP_STATUS_OK	           = 200, // The request has succeeded.
  gxsHTTP_STATUS_CREATED           = 201, // The request has been fulfilled
                                          // and resulted in a new resource
                                          // being created (Used with POST).
  gxsHTTP_STATUS_ACCEPTED          = 202, // The request has been accepted for
                                          // processing, but the processing has
                                          // not been completed. 
  gxsHTTP_STATUS_NO_CONTENT        = 204, // The server has fulfilled the
                                          // request but there is no new
                                          // information to send back.

  // 3xx: Redirection - Further action must be taken in order to complete
  // the request.
  gxsHTTP_STATUS_MULTIPLE_CHOICES  = 300, // The requested resource is
                                          // available at one or more
                                          // locations. 
  gxsHTTP_STATUS_MOVED_PERMANENTLY = 301, // The requested resource has been
                                          // assigned a new permanent URL and
                                          // any future references to this
                                          // resource should be done using
                                          // that URL.
  gxsHTTP_STATUS_MOVED_TEMPORARILY = 302, // The requested resource resides
                                          // temporarily under a different URL.
  gxsHTTP_STATUS_NOT_MODIFIED      = 304, // Returned if the client has
                                          // performed a conditional GET
                                          // request and access is allowed,
                                          // but the document has not been
                                          // modified since the date and time
                                          // specified in the If-Modified-Since
                                          // field.

  // 4xx: Client Error - The request contains bad syntax or cannot be
  // fulfilled.
  gxsHTTP_STATUS_BAD_REQUEST       = 400, // The request could not be
                                          // understood by the server due to
                                          // malformed syntax.
  gxsHTTP_STATUS_UNAUTHORIZED      = 401, // The request requires user
                                          // authentication. The response must
                                          // include a WWW-Authenticate header
                                          // field containing a challenge
                                          // applicable to the requested
                                          // resource. 
  gxsHTTP_STATUS_FORBIDDEN         = 403, // The server understood the request,
                                          // but is refusing to fulfill it.
                                          // Authorization will not help and
                                          // the request should not be
                                          // repeated.
  gxsHTTP_STATUS_NOT_FOUND         = 404, // The server has not found anything
                                          // matching the Request-URI.

  // 5xx: Server Error - The server failed to fulfill an apparently valid
  // request.
  gxsHTTP_STATUS_INTERNAL          = 500, // The server encountered an
                                          // unexpected condition which
                                          // prevented it from fulfilling
                                          // the request. 
  gxsHTTP_STATUS_NOT_IMPLEMENTED   = 501, // The server does not support the
                                          // functionality required to fulfill
                                          // the request. 
  gxsHTTP_STATUS_BAD_GATEWAY       = 502, // The server, while acting as a
                                          // gateway or proxy, received an
                                          // invalid response from the upstream
                                          // server it accessed in attempting
                                          // to fulfill the request. 
  gxsHTTP_STATUS_UNAVAILABLE       = 503  // The server is currently unable to
                                          // handle the request due to a
                                          // temporary overloading or
                                          // maintenance of the server.
};
// --------------------------------------------------------------

// --------------------------------------------------------------
// Data structures
// --------------------------------------------------------------
struct gxsNetscapeCookie
{
  gxsNetscapeCookie();
  ~gxsNetscapeCookie();
  gxsNetscapeCookie(const gxsNetscapeCookie &ob) { Copy(ob); }
  gxsNetscapeCookie& operator=(const gxsNetscapeCookie &ob) { 
    Copy(ob); return *this; 
  }
  void Copy(const gxsNetscapeCookie &ob);
  friend int operator==(const gxsNetscapeCookie &a,
			const gxsNetscapeCookie &b);

  // Cookie information
  gxString expires;
  gxString domain;
  gxString path;
  gxString host;
  gxString name;
  gxString value;
  int secure;
};

struct gxsHTTPHeader {
  gxsHTTPHeader();
  ~gxsHTTPHeader();
  gxsHTTPHeader(const gxsHTTPHeader &ob) { Copy(ob); }
  gxsHTTPHeader& operator=(const gxsHTTPHeader &ob) { Copy(ob); return *this; }
  void Copy(const gxsHTTPHeader &ob);
  friend int operator==(const gxsHTTPHeader &a, const gxsHTTPHeader &b);
  
  gxString http_header;            // Unchanged or complete HTTP header
  gxString authentication_scheme;  // Authentication scheme used
  gxString realm;                  // Authentication realm 
  gxString current_server;         // Server type
  gxString location;               // Document location
  gxString http_last_modified;     // Date that the document was last modified
  gxString date;                   // Today's date
  gxString http_expires;           // Date this document expires 
  gxString file_extension;         // Document's file extension
  gxString content_type;           // Content type
  gxString mime_type;              // MIME type
  gxString etag;                   // Entity tag for the associated entity
  gxString pragma;                 // Implementation specific directives
  gxString cache_control;          // Cache control parameters
  gxString content_encoding;       // Content encoding used
  float http_version;              // HTTP version
  int http_status;                 // Document/Client/Server status
  int authentication_needed;       // True if authentication is needed
  int not_found;                   // True if the document is not found
  int keep_alive;                  // True if this connection is persistent
  int timeout;                     // Time out value
  int max_conns;                   // Maximum number of connections
  int length;                      // Document length
  int no_cache;                    // True if not using cached copies
  int accept_ranges;               // True if ranges are accepted

  // Netscape cookie infomation
  gxString auth_cookie; // Authentication cookie
  int use_cookies;      // True if using cookies
  gxList<gxsNetscapeCookie> netscape_cookies; // List of parsed cookies
};
// --------------------------------------------------------------

// --------------------------------------------------------------
// Standalone functions
// --------------------------------------------------------------
const char *gxsHTTPMethodMessage(int method);
const char *gxsHTTPStatusCodeMessage(int status);
// --------------------------------------------------------------

#endif // __GX_HTTP_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
