// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxdfptr.cpp 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxDatabase file pointer routines are a collection of classes 
and standalone functions used to define the underlying file system
used by the gxDatabase class. NOTE: None of the data structures
and functions defined here are intended to be used directly. They
are used by the gxDatabase class to call the correct native file
API function for each supported platform.
*/
// ----------------------------------------------------------- // 
#include "gxdfptr.h"

gxdFPTR *gxdFPTRCreate(const char *fname)
// Create a new file and truncate existing files.
// Returns a null value if the file cannot be
// created.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Create(fname);
#else // Use the 32-bit version by default
  gxdFPTR *stream = new gxdFPTR;
  if(!stream) return 0;
  stream->fptr = fopen(fname, "w+b");
  if(stream->fptr == 0) return 0;
  return stream;
#endif
}

gxdFPTR *gxdFPTROpen(const char *fname, gxDatabaseAccessMode mode)
// Open an existing file. The "mode" variable determines if the file
// is opened for read only or read/write access. Returns a null value
// if the specified file cannot be opened. NOTE: This version of the
// open functions will only accept: gxDBASE_READONLY and gxDBASE_READWRITE
// access modes.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Open(fname, mode);
#else // Use the 32-bit version by default
  gxdFPTR *stream = new gxdFPTR;
  if(!stream) return 0;

  if(mode == gxDBASE_READONLY) { // Open for read only access
    stream->fptr = fopen(fname, "rb");
    if(stream->fptr == 0) return 0;
  }
  else { // Open for read/write access
    stream->fptr = fopen(fname, "r+b");
    if(stream->fptr == 0) return 0;
  }
  return stream;
#endif
}

int gxdFPTRClose(gxdFPTR *stream)
// Close an open file. Returns a non-zero value to
// indicate an error condition or zero if successful.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Close(stream);
#else // Use the 32-bit version by default
  if(!stream) return 0; // The file stream is not open
  if(fclose(stream->fptr) != 0) return 1;
  stream->fptr = 0;
  delete stream;
  return 0;
#endif
}

int gxdFPTRFlush(gxdFPTR *stream)
// Flush the any open disk buffers. Returns
// a non-zero value to indicate an error
// condition or zero if successful. 
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Flush(stream);
#else // Use the 32-bit version by default
  if(fflush(stream->fptr) != 0)
    return 1;
  else
    return 0;
#endif
}

int gxdFPTRRead(gxdFPTR *stream, void *buf, __UWORD__ bytes)
// Read a specified number of bytes from the current file position
// into a memory buffer. Returns a non-zero value to indicate an error
// condition or zero if successful.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Read(stream, buf, bytes);
#else // Use the 32-bit version by default
  if(!stream) return 1; // The file stream is not open
  if(fread((unsigned char *)buf, 1, bytes, stream->fptr) != bytes) return 1;
  return 0;
#endif
}

int gxdFPTRWrite(gxdFPTR *stream, const void *buf, __UWORD__ bytes) 
// Write a specific number of bytes from a memory buffer to the
// current file position. Returns a non-zero value to indicate an
// error condition or zero if successful.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Write(stream, buf, bytes);
#else // Use the 32-bit version by default
  if(!stream) return 1; // The file stream is not open
  if(fwrite((const unsigned char *)buf, 1, bytes, stream->fptr) != bytes)
    return 1;
  return 0;
#endif
}

FAU_t gxdFPTRSeek(gxdFPTR *stream, FAU_t offset,
		  gxDatabaseSeekMode mode)
// Seek to the specified offset starting at the beginning (gxDBASE_SEEK_SET),
// end (gxDBASE_SEEK_END) or current offset (gxDBASE_SEEK_CUR). Returns a 
// negative 1 to indicate an error condition or the current stream position 
// if successful.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Seek(stream, offset, mode);
#else // Use the 32-bit version by default
  if(!stream) return 1; // The file stream is not open

  if(mode == gxDBASE_SEEK_BEG) {
    return fseek(stream->fptr, offset, SEEK_SET);
  }
  else if(mode == gxDBASE_SEEK_CUR) {
    return fseek(stream->fptr, offset, SEEK_CUR);
  }
  else if(mode == gxDBASE_SEEK_END) {
    return fseek(stream->fptr, offset, SEEK_CUR);
  }
  else { // An invalid seek mode was specified
    return (FAU_t)-1;
  }
#endif
}

FAU_t gxdFPTRTell(gxdFPTR *stream)
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Tell(stream);
#else // Use the 32-bit version by default
  if(!stream) return (FAU_t)-1; // The file stream is not open
  return ftell(stream->fptr);
#endif
}

int gxdFPTRExists(const char *fname)
// Returns true if the specified file exists.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64Exists(fname);
#else // Use the 32-bit version by default
  struct stat buf;
  return stat(fname, &buf) == (FAU_t)0;
#endif
}

FAU_t gxdFPTRFileSize(const char *fname)
// Returns the length of the specified file or negative 1
// to indicate an error condition.
{
#if defined (__64_BIT_DATABASE_ENGINE__)
  return gxdFPTR64FileSize(fname);
#else // Use the 32-bit version by default
  struct stat buf;
  int result = stat(fname, &buf);
  if(result != 0) return -1;
  return buf.st_size;
#endif
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
